/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class RopeJoint
extends Joint {
    protected Vector2 localAnchor1;
    protected Vector2 localAnchor2;
    protected double upperLimit;
    protected double lowerLimit;
    protected boolean upperLimitEnabled;
    protected boolean lowerLimitEnabled;
    protected double invK;
    protected Vector2 n;
    protected Joint.LimitState limitState;
    protected double impulse;

    public RopeJoint(Body body, Body body2, Vector2 vector2, Vector2 vector22) {
        super(body, body2, false);
        double d;
        if (body == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor1"));
        }
        if (vector22 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor2"));
        }
        this.localAnchor1 = body.getLocalPoint(vector2);
        this.localAnchor2 = body2.getLocalPoint(vector22);
        this.upperLimitEnabled = true;
        this.lowerLimitEnabled = true;
        this.upperLimit = d = vector2.distance(vector22);
        this.lowerLimit = d;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RopeJoint[").append(super.toString()).append("|LocalAnchor1=").append(this.localAnchor1).append("|LocalAnchor2=").append(this.localAnchor2).append("|WorldAnchor1=").append(this.getAnchor1()).append("|WorldAnchor2=").append(this.getAnchor2()).append("|IsLowerLimitEnabled=").append(this.lowerLimitEnabled).append("|LowerLimit").append(this.lowerLimit).append("|IsUpperLimitEnabled=").append(this.upperLimitEnabled).append("|UpperLimit=").append(this.upperLimit).append("]");
        return stringBuilder.toString();
    }

    @Override
    public void initializeConstraints() {
        Step step = this.world.getStep();
        Settings settings = this.world.getSettings();
        double d = settings.getLinearTolerance();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d2 = mass.getInverseMass();
        double d3 = mass2.getInverseMass();
        double d4 = mass.getInverseInertia();
        double d5 = mass2.getInverseInertia();
        Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        this.n = vector2.sum(this.body1.getWorldCenter()).subtract(vector22.sum(this.body2.getWorldCenter()));
        double d6 = this.n.getMagnitude();
        if (d6 < d) {
            this.n.zero();
        } else {
            this.n.multiply(1.0 / d6);
        }
        if (this.upperLimitEnabled && this.lowerLimitEnabled) {
            if (Math.abs(this.upperLimit - this.lowerLimit) < 2.0 * d) {
                this.limitState = Joint.LimitState.EQUAL;
            } else if (this.upperLimit > this.lowerLimit) {
                this.limitState = d6 > this.upperLimit ? Joint.LimitState.AT_UPPER : (d6 < this.lowerLimit ? Joint.LimitState.AT_LOWER : Joint.LimitState.INACTIVE);
            }
        } else {
            this.limitState = this.upperLimitEnabled ? (d6 > this.upperLimit ? Joint.LimitState.AT_UPPER : Joint.LimitState.INACTIVE) : (this.lowerLimitEnabled ? (d6 < this.lowerLimit ? Joint.LimitState.AT_LOWER : Joint.LimitState.INACTIVE) : Joint.LimitState.INACTIVE);
        }
        if (this.limitState != Joint.LimitState.INACTIVE) {
            double d7 = vector2.cross(this.n);
            double d8 = vector22.cross(this.n);
            double d9 = d2 + d4 * d7 * d7;
            this.invK = (d9 += d3 + d5 * d8 * d8) <= Epsilon.E ? 0.0 : 1.0 / d9;
            this.impulse *= step.getDeltaTimeRatio();
            Vector2 vector23 = this.n.product(this.impulse);
            this.body1.getLinearVelocity().add(vector23.product(d2));
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d4 * vector2.cross(vector23));
            this.body2.getLinearVelocity().subtract(vector23.product(d3));
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d5 * vector22.cross(vector23));
        } else {
            this.impulse = 0.0;
        }
    }

    @Override
    public void solveVelocityConstraints() {
        if (this.limitState != Joint.LimitState.INACTIVE) {
            Transform transform = this.body1.getTransform();
            Transform transform2 = this.body2.getTransform();
            Mass mass = this.body1.getMass();
            Mass mass2 = this.body2.getMass();
            double d = mass.getInverseMass();
            double d2 = mass2.getInverseMass();
            double d3 = mass.getInverseInertia();
            double d4 = mass2.getInverseInertia();
            Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
            Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
            Vector2 vector23 = this.body1.getLinearVelocity().sum(vector2.cross(this.body1.getAngularVelocity()));
            Vector2 vector24 = this.body2.getLinearVelocity().sum(vector22.cross(this.body2.getAngularVelocity()));
            double d5 = this.n.dot(vector23.difference(vector24));
            double d6 = -this.invK * d5;
            this.impulse += d6;
            Vector2 vector25 = this.n.product(d6);
            this.body1.getLinearVelocity().add(vector25.product(d));
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d3 * vector2.cross(vector25));
            this.body2.getLinearVelocity().subtract(vector25.product(d2));
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d4 * vector22.cross(vector25));
        }
    }

    @Override
    public boolean solvePositionConstraints() {
        if (this.limitState != Joint.LimitState.INACTIVE) {
            double d = this.upperLimit;
            if (this.limitState == Joint.LimitState.AT_LOWER) {
                d = this.lowerLimit;
            }
            Settings settings = this.world.getSettings();
            double d2 = settings.getLinearTolerance();
            double d3 = settings.getMaximumLinearCorrection();
            Transform transform = this.body1.getTransform();
            Transform transform2 = this.body2.getTransform();
            Mass mass = this.body1.getMass();
            Mass mass2 = this.body2.getMass();
            double d4 = mass.getInverseMass();
            double d5 = mass2.getInverseMass();
            double d6 = mass.getInverseInertia();
            double d7 = mass2.getInverseInertia();
            Vector2 vector2 = this.body1.getWorldCenter();
            Vector2 vector22 = this.body2.getWorldCenter();
            Vector2 vector23 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
            Vector2 vector24 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
            this.n = vector23.sum(this.body1.getWorldCenter()).subtract(vector24.sum(this.body2.getWorldCenter()));
            double d8 = this.n.normalize();
            double d9 = d8 - d;
            d9 = Interval.clamp(d9, -d3, d3);
            double d10 = -this.invK * d9;
            Vector2 vector25 = this.n.product(d10);
            this.body1.translate(vector25.product(d4));
            this.body1.rotate(d6 * vector23.cross(vector25), vector2);
            this.body2.translate(vector25.product(-d5));
            this.body2.rotate(-d7 * vector24.cross(vector25), vector22);
            return Math.abs(d9) < d2;
        }
        return true;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldPoint(this.localAnchor1);
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.localAnchor2);
    }

    @Override
    public Vector2 getReactionForce(double d) {
        return this.n.product(this.impulse * d);
    }

    @Override
    public double getReactionTorque(double d) {
        return 0.0;
    }

    @Override
    protected void shiftCoordinates(Vector2 vector2) {
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.rope.lessThanZeroUpperLimit"));
        }
        if (d < this.lowerLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidUpperLimit"));
        }
        if (this.upperLimitEnabled && d != this.upperLimit) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
        this.upperLimit = d;
    }

    public void setUpperLimitEnabled(boolean bl) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.upperLimitEnabled = bl;
    }

    public boolean isUpperLimitEnabled() {
        return this.upperLimitEnabled;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.rope.lessThanZeroLowerLimit"));
        }
        if (d > this.upperLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLowerLimit"));
        }
        if (this.lowerLimitEnabled && d != this.lowerLimit) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
        this.lowerLimit = d;
    }

    public void setLowerLimitEnabled(boolean bl) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.lowerLimitEnabled = bl;
    }

    public boolean isLowerLimitEnabled() {
        return this.lowerLimitEnabled;
    }

    public void setLimits(double d, double d2) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.rope.lessThanZeroLowerLimit"));
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.rope.lessThanZeroUpperLimit"));
        }
        if (d > d2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLimits"));
        }
        if (this.lowerLimitEnabled && d != this.lowerLimit || this.upperLimitEnabled && d2 != this.upperLimit) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
        this.upperLimit = d2;
        this.lowerLimit = d;
    }

    public void setLimitsEnabled(double d, double d2) {
        this.upperLimitEnabled = true;
        this.lowerLimitEnabled = true;
        this.setLimits(d, d2);
    }

    public void setLimitsEnabled(boolean bl) {
        this.upperLimitEnabled = bl;
        this.lowerLimitEnabled = bl;
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
    }

    public void setLimits(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.rope.invalidLimit"));
        }
        if (this.lowerLimitEnabled && d != this.lowerLimit || this.upperLimitEnabled && d != this.upperLimit) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
        this.upperLimit = d;
        this.lowerLimit = d;
    }

    public void setLimitsEnabled(double d) {
        this.upperLimitEnabled = true;
        this.lowerLimitEnabled = true;
        this.setLimits(d);
    }
}

