/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Matrix33;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Vector3;
import org.dyn4j.resources.Messages;

public class WeldJoint
extends Joint {
    protected Vector2 localAnchor1;
    protected Vector2 localAnchor2;
    protected double referenceAngle;
    protected Matrix33 K;
    protected Vector3 impulse;
    protected double frequency;
    protected double dampingRatio;
    protected double bias;
    protected double gamma;

    public WeldJoint(Body body, Body body2, Vector2 vector2) {
        super(body, body2, false);
        if (body == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor"));
        }
        this.localAnchor1 = body.getLocalPoint(vector2);
        this.localAnchor2 = body2.getLocalPoint(vector2);
        this.referenceAngle = body.getTransform().getRotation() - body2.getTransform().getRotation();
        this.K = new Matrix33();
        this.impulse = new Vector3();
        this.frequency = 0.0;
        this.dampingRatio = 0.0;
        this.gamma = 0.0;
        this.bias = 0.0;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WeldJoint[").append(super.toString()).append("|LocalAnchor1=").append(this.localAnchor1).append("|LocalAnchor2=").append(this.localAnchor2).append("|WorldAnchor=").append(this.getAnchor1()).append("|ReferenceAngle=").append(this.referenceAngle).append("|Frequency=").append(this.frequency).append("|DampingRatio=").append(this.dampingRatio).append("]");
        return stringBuilder.toString();
    }

    @Override
    public void initializeConstraints() {
        Step step = this.world.getStep();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d = mass.getInverseMass();
        double d2 = mass2.getInverseMass();
        double d3 = mass.getInverseInertia();
        double d4 = mass2.getInverseInertia();
        Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        this.K.m00 = d + d2 + vector2.y * vector2.y * d3 + vector22.y * vector22.y * d4;
        this.K.m01 = -vector2.y * vector2.x * d3 - vector22.y * vector22.x * d4;
        this.K.m02 = -vector2.y * d3 - vector22.y * d4;
        this.K.m10 = this.K.m01;
        this.K.m11 = d + d2 + vector2.x * vector2.x * d3 + vector22.x * vector22.x * d4;
        this.K.m12 = vector2.x * d3 + vector22.x * d4;
        this.K.m20 = this.K.m02;
        this.K.m21 = this.K.m12;
        this.K.m22 = d3 + d4;
        if (this.frequency > 0.0) {
            double d5 = d3 + d4;
            double d6 = d5 <= Epsilon.E ? 0.0 : 1.0 / d5;
            double d7 = this.getRelativeRotation();
            double d8 = step.getDeltaTime();
            double d9 = Math.PI * 2 * this.frequency;
            double d10 = 2.0 * d6 * this.dampingRatio * d9;
            double d11 = d6 * d9 * d9;
            this.gamma = d8 * (d10 + d8 * d11);
            this.gamma = this.gamma <= Epsilon.E ? 0.0 : 1.0 / this.gamma;
            this.bias = d7 * d8 * d11 * this.gamma;
            this.K.m22 = d5 <= Epsilon.E ? 0.0 : 1.0 / (d5 += this.gamma);
        } else {
            this.gamma = 0.0;
            this.bias = 0.0;
        }
        this.impulse.multiply(step.getDeltaTimeRatio());
        Vector2 vector23 = new Vector2(this.impulse.x, this.impulse.y);
        this.body1.getLinearVelocity().add(vector23.product(d));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d3 * (vector2.cross(vector23) + this.impulse.z));
        this.body2.getLinearVelocity().subtract(vector23.product(d2));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d4 * (vector22.cross(vector23) + this.impulse.z));
    }

    @Override
    public void solveVelocityConstraints() {
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d = mass.getInverseMass();
        double d2 = mass2.getInverseMass();
        double d3 = mass.getInverseInertia();
        double d4 = mass2.getInverseInertia();
        Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        if (this.frequency > 0.0) {
            double d5 = this.body1.getAngularVelocity() - this.body2.getAngularVelocity();
            double d6 = -this.K.m22 * (d5 + this.bias + this.gamma * this.impulse.z);
            this.impulse.z += d6;
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d3 * d6);
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d4 * d6);
            Vector2 vector23 = this.body1.getLinearVelocity().sum(vector2.cross(this.body1.getAngularVelocity()));
            Vector2 vector24 = this.body2.getLinearVelocity().sum(vector22.cross(this.body2.getAngularVelocity()));
            Vector2 vector25 = vector23.subtract(vector24);
            Vector2 vector26 = this.K.solve22(vector25).negate();
            this.impulse.x += vector26.x;
            this.impulse.y += vector26.y;
            this.body1.getLinearVelocity().add(vector26.product(d));
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d3 * vector2.cross(vector26));
            this.body2.getLinearVelocity().subtract(vector26.product(d2));
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d4 * vector22.cross(vector26));
        } else {
            Vector2 vector27 = this.body1.getLinearVelocity().sum(vector2.cross(this.body1.getAngularVelocity()));
            Vector2 vector28 = this.body2.getLinearVelocity().sum(vector22.cross(this.body2.getAngularVelocity()));
            Vector2 vector29 = vector27.subtract(vector28);
            Vector3 vector3 = new Vector3(vector29.x, vector29.y, this.body1.getAngularVelocity() - this.body2.getAngularVelocity());
            Vector3 vector32 = this.K.solve33(vector3.negate());
            this.impulse.add(vector32);
            Vector2 vector210 = new Vector2(vector32.x, vector32.y);
            this.body1.getLinearVelocity().add(vector210.product(d));
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d3 * (vector2.cross(vector210) + vector32.z));
            this.body2.getLinearVelocity().subtract(vector210.product(d2));
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d4 * (vector22.cross(vector210) + vector32.z));
        }
    }

    @Override
    public boolean solvePositionConstraints() {
        Settings settings = this.world.getSettings();
        double d = settings.getLinearTolerance();
        double d2 = settings.getAngularTolerance();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d3 = mass.getInverseMass();
        double d4 = mass2.getInverseMass();
        double d5 = mass.getInverseInertia();
        double d6 = mass2.getInverseInertia();
        Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 vector23 = this.body1.getWorldCenter().add(vector2);
        Vector2 vector24 = this.body2.getWorldCenter().add(vector22);
        Vector2 vector25 = vector23.difference(vector24);
        double d7 = this.getRelativeRotation();
        Vector3 vector3 = new Vector3(vector25.x, vector25.y, d7);
        double d8 = vector25.getMagnitude();
        double d9 = Math.abs(d7);
        this.K.m00 = d3 + d4 + vector2.y * vector2.y * d5 + vector22.y * vector22.y * d6;
        this.K.m01 = -vector2.y * vector2.x * d5 - vector22.y * vector22.x * d6;
        this.K.m02 = -vector2.y * d5 - vector22.y * d6;
        this.K.m10 = this.K.m01;
        this.K.m11 = d3 + d4 + vector2.x * vector2.x * d5 + vector22.x * vector22.x * d6;
        this.K.m12 = vector2.x * d5 + vector22.x * d6;
        this.K.m20 = this.K.m02;
        this.K.m21 = this.K.m12;
        this.K.m22 = d5 + d6;
        if (this.frequency > 0.0) {
            d9 = 0.0;
            Vector2 vector26 = this.K.solve22(vector25).negate();
            this.body1.translate(vector26.product(d3));
            this.body1.rotateAboutCenter(d5 * vector2.cross(vector26));
            this.body2.translate(vector26.product(-d4));
            this.body2.rotateAboutCenter(-d6 * vector22.cross(vector26));
        } else {
            Vector3 vector32 = this.K.solve33(vector3.negate());
            Vector2 vector27 = new Vector2(vector32.x, vector32.y);
            this.body1.translate(vector27.product(d3));
            this.body1.rotateAboutCenter(d5 * (vector2.cross(vector27) + vector32.z));
            this.body2.translate(vector27.product(-d4));
            this.body2.rotateAboutCenter(-d6 * (vector22.cross(vector27) + vector32.z));
        }
        return d8 <= d && d9 <= d2;
    }

    private double getRelativeRotation() {
        double d = this.body1.getTransform().getRotation() - this.body2.getTransform().getRotation() - this.referenceAngle;
        if (d < -Math.PI) {
            d += Math.PI * 2;
        }
        if (d > Math.PI) {
            d -= Math.PI * 2;
        }
        return d;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldPoint(this.localAnchor1);
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.localAnchor2);
    }

    @Override
    public Vector2 getReactionForce(double d) {
        Vector2 vector2 = new Vector2(this.impulse.x, this.impulse.y);
        return vector2.multiply(d);
    }

    @Override
    public double getReactionTorque(double d) {
        return this.impulse.z * d;
    }

    @Override
    protected void shiftCoordinates(Vector2 vector2) {
    }

    public boolean isSpring() {
        return this.frequency > 0.0;
    }

    public boolean isSpringDamper() {
        return this.frequency > 0.0 && this.dampingRatio > 0.0;
    }

    public double getDampingRatio() {
        return this.dampingRatio;
    }

    public void setDampingRatio(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidDampingRatio"));
        }
        this.dampingRatio = d;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidFrequency"));
        }
        this.frequency = d;
    }

    public double getReferenceAngle() {
        return this.referenceAngle;
    }

    public void setReferenceAngle(double d) {
        this.referenceAngle = d;
    }
}

