/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import java.util.UUID;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;

public abstract class AbstractShape
implements Shape,
Transformable {
    protected UUID id = UUID.randomUUID();
    protected Vector2 center;
    protected double radius;
    protected Object userData;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Id=").append(this.id).append("|Center=").append(this.center).append("|Radius=").append(this.radius);
        return stringBuilder.toString();
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Vector2 getCenter() {
        return this.center;
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(Object object) {
        this.userData = object;
    }

    @Override
    public void rotate(double d) {
        this.rotate(d, 0.0, 0.0);
    }

    @Override
    public void rotateAboutCenter(double d) {
        this.rotate(d, this.center.x, this.center.y);
    }

    @Override
    public void rotate(double d, Vector2 vector2) {
        this.rotate(d, vector2.x, vector2.y);
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        if (!this.center.equals(d2, d3)) {
            this.center.rotate(d, d2, d3);
        }
    }

    @Override
    public void translate(double d, double d2) {
        this.center.add(d, d2);
    }

    @Override
    public void translate(Vector2 vector2) {
        this.translate(vector2.x, vector2.y);
    }

    @Override
    public Interval project(Vector2 vector2) {
        return this.project(vector2, Transform.IDENTITY);
    }

    @Override
    public boolean contains(Vector2 vector2) {
        return this.contains(vector2, Transform.IDENTITY);
    }

    @Override
    public AABB createAABB() {
        return this.createAABB(Transform.IDENTITY);
    }
}

