/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.Epsilon;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.AbstractShape;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Feature;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Vertex;
import org.dyn4j.resources.Messages;

public class Capsule
extends AbstractShape
implements Convex,
Shape,
Transformable {
    protected static final double EDGE_FEATURE_SELECTION_CRITERIA = 0.98;
    protected static final double EDGE_FEATURE_EXPANSION_FACTOR = 0.1;
    protected double length;
    protected double capRadius;
    protected Vector2[] foci;
    protected Vector2 localXAxis;

    public Capsule(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.capsule.invalidWidth"));
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.capsule.invalidHeight"));
        }
        if (Math.abs(d - d2) < Epsilon.E) {
            throw new IllegalArgumentException(Messages.getString("geometry.capsule.degenerate"));
        }
        double d3 = d;
        double d4 = d2;
        boolean bl = false;
        if (d < d2) {
            d3 = d2;
            d4 = d;
            bl = true;
        }
        this.length = d3;
        this.capRadius = d4 * 0.5;
        this.radius = d3 * 0.5;
        this.center = new Vector2();
        double d5 = (d3 - d4) * 0.5;
        if (bl) {
            this.foci = new Vector2[]{new Vector2(0.0, -d5), new Vector2(0.0, d5)};
            this.localXAxis = new Vector2(0.0, 1.0);
        } else {
            this.foci = new Vector2[]{new Vector2(-d5, 0.0), new Vector2(d5, 0.0)};
            this.localXAxis = new Vector2(1.0, 0.0);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Capsule[").append(super.toString()).append("|Width=").append(this.length).append("|CapRadius=").append(this.capRadius).append("|UserData=").append(this.userData).append("]");
        return stringBuilder.toString();
    }

    @Override
    public Vector2[] getAxes(Vector2[] vector2Array, Transform transform) {
        if (vector2Array != null) {
            Vector2[] vector2Array2 = new Vector2[2 + vector2Array.length];
            vector2Array2[0] = transform.getTransformedR(this.localXAxis);
            vector2Array2[1] = transform.getTransformedR(this.localXAxis.getRightHandOrthogonalVector());
            Vector2 vector2 = transform.getTransformed(this.foci[0]);
            Vector2 vector22 = transform.getTransformed(this.foci[1]);
            for (int i = 0; i < vector2Array.length; ++i) {
                double d = vector2.distanceSquared(vector2Array[i]);
                double d2 = vector22.distanceSquared(vector2Array[i]);
                Vector2 vector23 = null;
                vector23 = d < d2 ? vector2.to(vector2Array[i]) : vector22.to(vector2Array[i]);
                vector23.normalize();
                vector2Array2[2 + i] = vector23;
            }
            return vector2Array2;
        }
        return new Vector2[]{transform.getTransformedR(this.localXAxis), transform.getTransformedR(this.localXAxis.getRightHandOrthogonalVector())};
    }

    @Override
    public Vector2[] getFoci(Transform transform) {
        return new Vector2[]{transform.getTransformed(this.foci[0]), transform.getTransformed(this.foci[1])};
    }

    @Override
    public Vector2 getFarthestPoint(Vector2 vector2, Transform transform) {
        vector2.normalize();
        Vector2 vector22 = Segment.getFarthestPoint(this.foci[0], this.foci[1], vector2, transform);
        return vector22.add(vector2.product(this.capRadius));
    }

    @Override
    public Feature getFarthestFeature(Vector2 vector2, Transform transform) {
        Vector2 vector22 = transform.getInverseTransformedR(vector2);
        Vector2 vector23 = this.localXAxis.getLeftHandOrthogonalVector();
        double d = vector22.dot(vector22) * 0.98;
        double d2 = vector22.dot(vector23);
        if (Math.abs(d2) < d) {
            Vector2 vector24 = this.getFarthestPoint(vector2, transform);
            return new Vertex(vector24);
        }
        Vector2 vector25 = vector23.multiply(this.capRadius);
        Vector2 vector26 = this.localXAxis.product(this.length * 0.5 * 0.1);
        if (d2 > 0.0) {
            Vector2 vector27 = this.foci[0].sum(vector25).subtract(vector26);
            Vector2 vector28 = this.foci[1].sum(vector25).add(vector26);
            return Segment.getFarthestFeature(vector27, vector28, vector2, transform);
        }
        Vector2 vector29 = this.foci[0].difference(vector25).subtract(vector26);
        Vector2 vector210 = this.foci[1].difference(vector25).add(vector26);
        return Segment.getFarthestFeature(vector29, vector210, vector2, transform);
    }

    @Override
    public Interval project(Vector2 vector2, Transform transform) {
        Vector2 vector22 = this.getFarthestPoint(vector2, transform);
        Vector2 vector23 = transform.getTransformed(this.center);
        double d = vector23.dot(vector2);
        double d2 = vector22.dot(vector2);
        return new Interval(2.0 * d - d2, d2);
    }

    @Override
    public AABB createAABB(Transform transform) {
        Interval interval = this.project(Vector2.X_AXIS, transform);
        Interval interval2 = this.project(Vector2.Y_AXIS, transform);
        return new AABB(interval.getMin(), interval2.getMin(), interval.getMax(), interval2.getMax());
    }

    @Override
    public Mass createMass(double d) {
        double d2 = this.capRadius * 2.0;
        double d3 = this.length - d2;
        double d4 = this.capRadius * this.capRadius;
        double d5 = d3 * d2;
        double d6 = d4 * Math.PI;
        double d7 = d * d5;
        double d8 = d * d6;
        double d9 = d7 + d8;
        double d10 = d3 * 0.5;
        double d11 = 0.5 * d8 * d4 + d8 * d10 * d10;
        double d12 = d7 * (d2 * d2 + d3 * d3) / 12.0;
        double d13 = d12 + d11;
        return new Mass(this.center, d9, d13);
    }

    @Override
    public double getRadius(Vector2 vector2) {
        return this.radius + this.center.distance(vector2);
    }

    @Override
    public boolean contains(Vector2 vector2, Transform transform) {
        Vector2 vector22 = Segment.getPointOnSegmentClosestToPoint(vector2, transform.getTransformed(this.foci[0]), transform.getTransformed(this.foci[1]));
        double d = this.capRadius * this.capRadius;
        double d2 = vector22.distanceSquared(vector2);
        return d2 <= d;
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        super.rotate(d, d2, d3);
        this.foci[0].rotate(d, d2, d3);
        this.foci[1].rotate(d, d2, d3);
        this.localXAxis.rotate(d);
    }

    @Override
    public void translate(double d, double d2) {
        super.translate(d, d2);
        this.foci[0].add(d, d2);
        this.foci[1].add(d, d2);
    }

    public double getRotation() {
        return Vector2.X_AXIS.getAngleBetween(this.localXAxis);
    }

    public double getLength() {
        return this.length;
    }

    public double getCapRadius() {
        return this.capRadius;
    }
}

