/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.AbstractShape;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Feature;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Vertex;
import org.dyn4j.resources.Messages;

public class Ellipse
extends AbstractShape
implements Convex,
Shape,
Transformable {
    protected double width;
    protected double height;
    protected double a;
    protected double b;
    protected Vector2 localXAxis;

    public Ellipse(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.ellipse.invalidWidth"));
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.ellipse.invalidHeight"));
        }
        this.center = new Vector2();
        this.width = d;
        this.height = d2;
        this.a = d * 0.5;
        this.b = d2 * 0.5;
        this.radius = Math.max(this.a, this.b);
        this.localXAxis = new Vector2(1.0, 0.0);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Ellipse[").append(super.toString()).append("|Width=").append(this.width).append("|Height=").append(this.height).append("|UserData=").append(this.userData).append("]");
        return stringBuilder.toString();
    }

    @Override
    public Vector2[] getAxes(Vector2[] vector2Array, Transform transform) {
        throw new UnsupportedOperationException(Messages.getString("geometry.ellipse.satNotSupported"));
    }

    @Override
    public Vector2[] getFoci(Transform transform) {
        throw new UnsupportedOperationException(Messages.getString("geometry.ellipse.satNotSupported"));
    }

    @Override
    public Vector2 getFarthestPoint(Vector2 vector2, Transform transform) {
        Vector2 vector22 = transform.getInverseTransformedR(vector2);
        double d = this.getRotation();
        vector22.rotate(-d);
        vector22.x *= this.a;
        vector22.y *= this.b;
        vector22.normalize();
        Vector2 vector23 = new Vector2(vector22.x * this.a, vector22.y * this.b);
        vector23.rotate(d);
        vector23.add(this.center);
        transform.transform(vector23);
        return vector23;
    }

    @Override
    public Feature getFarthestFeature(Vector2 vector2, Transform transform) {
        Vector2 vector22 = this.getFarthestPoint(vector2, transform);
        return new Vertex(vector22);
    }

    @Override
    public Interval project(Vector2 vector2, Transform transform) {
        Vector2 vector22 = this.getFarthestPoint(vector2, transform);
        Vector2 vector23 = transform.getTransformed(this.center);
        double d = vector23.dot(vector2);
        double d2 = vector22.dot(vector2);
        return new Interval(2.0 * d - d2, d2);
    }

    @Override
    public AABB createAABB(Transform transform) {
        Interval interval = this.project(Vector2.X_AXIS, transform);
        Interval interval2 = this.project(Vector2.Y_AXIS, transform);
        return new AABB(interval.getMin(), interval2.getMin(), interval.getMax(), interval2.getMax());
    }

    @Override
    public Mass createMass(double d) {
        double d2 = Math.PI * this.a * this.b;
        double d3 = d2 * d;
        double d4 = d3 * (this.a * this.a + this.b * this.b) / 4.0;
        return new Mass(this.center, d3, d4);
    }

    @Override
    public double getRadius(Vector2 vector2) {
        return this.radius + vector2.distance(this.center);
    }

    @Override
    public boolean contains(Vector2 vector2, Transform transform) {
        Vector2 vector22 = transform.getInverseTransformed(vector2);
        double d = this.getRotation();
        vector22.rotate(-d, this.center.x, this.center.y);
        double d2 = vector22.x - this.center.x;
        double d3 = vector22.y - this.center.y;
        double d4 = d2 * d2;
        double d5 = d3 * d3;
        double d6 = this.a * this.a;
        double d7 = this.b * this.b;
        double d8 = d4 / d6 + d5 / d7;
        return d8 <= 1.0;
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        super.rotate(d, d2, d3);
        this.localXAxis.rotate(d);
    }

    public double getRotation() {
        return Vector2.X_AXIS.getAngleBetween(this.localXAxis);
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getHalfWidth() {
        return this.a;
    }

    public double getHalfHeight() {
        return this.b;
    }
}

