/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import java.util.List;
import org.dyn4j.Epsilon;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Mass {
    protected Type type;
    protected Vector2 center;
    protected double mass;
    protected double inertia;
    protected double invMass;
    protected double invInertia;

    public Mass() {
        this.type = Type.INFINITE;
        this.center = new Vector2();
        this.mass = 0.0;
        this.inertia = 0.0;
        this.invMass = 0.0;
        this.invInertia = 0.0;
    }

    public Mass(Vector2 vector2, double d, double d2) {
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("geometry.mass.nullCenter"));
        }
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.mass.invalidMass"));
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.mass.invalidInertia"));
        }
        this.type = Type.NORMAL;
        this.center = vector2.copy();
        this.mass = d;
        this.inertia = d2;
        if (d > Epsilon.E) {
            this.invMass = 1.0 / d;
        } else {
            this.invMass = 0.0;
            this.type = Type.FIXED_LINEAR_VELOCITY;
        }
        if (d2 > Epsilon.E) {
            this.invInertia = 1.0 / d2;
        } else {
            this.invInertia = 0.0;
            this.type = Type.FIXED_ANGULAR_VELOCITY;
        }
        if (d <= Epsilon.E && d2 <= Epsilon.E) {
            this.type = Type.INFINITE;
        }
    }

    public Mass(Mass mass) {
        if (mass == null) {
            throw new NullPointerException(Messages.getString("geometry.mass.nullMass"));
        }
        this.type = mass.type;
        this.center = mass.center.copy();
        this.mass = mass.mass;
        this.inertia = mass.inertia;
        this.invMass = mass.invMass;
        this.invInertia = mass.invInertia;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Mass[Type=").append((Object)this.type).append("|Center=").append(this.center).append("|Mass=").append(this.mass).append("|Inertia=").append(this.inertia).append("]");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.center == null ? 0 : this.center.hashCode());
        long l = Double.doubleToLongBits(this.inertia);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.invInertia);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.invMass);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.mass);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Mass) {
            Mass mass = (Mass)object;
            if (this.type == mass.type && this.mass == mass.mass && this.inertia == mass.inertia && this.center.equals(mass.center)) {
                return true;
            }
        }
        return false;
    }

    public static Mass create(List<Mass> list) {
        Mass mass;
        int n;
        if (list == null) {
            throw new NullPointerException(Messages.getString("geometry.mass.nullMassList"));
        }
        if (list.size() == 0) {
            throw new IllegalArgumentException(Messages.getString("geometry.mass.invalidMassListSize"));
        }
        int n2 = list.size();
        if (n2 == 1) {
            Mass mass2 = list.get(0);
            if (mass2 != null) {
                return new Mass(list.get(0));
            }
            throw new NullPointerException(Messages.getString("geometry.mass.invalidMassListSize"));
        }
        Vector2 vector2 = new Vector2();
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < n2; ++n) {
            mass = list.get(n);
            if (mass == null) {
                throw new NullPointerException(Messages.getString("geometry.mass.nullMassListElement"));
            }
            vector2.add(mass.center.product(mass.mass));
            d += mass.mass;
        }
        if (d > 0.0) {
            vector2.multiply(1.0 / d);
        }
        for (n = 0; n < n2; ++n) {
            mass = list.get(n);
            double d3 = mass.center.distanceSquared(vector2);
            double d4 = mass.inertia + mass.mass * d3;
            d2 += d4;
        }
        return new Mass(vector2, d, d2);
    }

    public boolean isInfinite() {
        return this.type == Type.INFINITE;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new NullPointerException(Messages.getString("geometry.mass.nullMassType"));
        }
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public Vector2 getCenter() {
        return this.center;
    }

    public double getMass() {
        if (this.type == Type.INFINITE || this.type == Type.FIXED_LINEAR_VELOCITY) {
            return 0.0;
        }
        return this.mass;
    }

    public double getInertia() {
        if (this.type == Type.INFINITE || this.type == Type.FIXED_ANGULAR_VELOCITY) {
            return 0.0;
        }
        return this.inertia;
    }

    public double getInverseMass() {
        if (this.type == Type.INFINITE || this.type == Type.FIXED_LINEAR_VELOCITY) {
            return 0.0;
        }
        return this.invMass;
    }

    public double getInverseInertia() {
        if (this.type == Type.INFINITE || this.type == Type.FIXED_ANGULAR_VELOCITY) {
            return 0.0;
        }
        return this.invInertia;
    }

    public static enum Type {
        NORMAL,
        INFINITE,
        FIXED_ANGULAR_VELOCITY,
        FIXED_LINEAR_VELOCITY;

    }
}

