/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.geometry.Geometry;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Polygon;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Rectangle
extends Polygon
implements Shape,
Transformable {
    protected double width;
    protected double height;

    public Rectangle(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.rectangle.invalidWidth"));
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.rectangle.invalidHeight"));
        }
        this.vertices = new Vector2[]{new Vector2(-d * 0.5, -d2 * 0.5), new Vector2(d * 0.5, -d2 * 0.5), new Vector2(d * 0.5, d2 * 0.5), new Vector2(-d * 0.5, d2 * 0.5)};
        this.normals = new Vector2[]{new Vector2(0.0, -1.0), new Vector2(1.0, 0.0), new Vector2(0.0, 1.0), new Vector2(-1.0, 0.0)};
        this.center = Geometry.getAverageCenter(this.vertices);
        this.radius = this.center.distance(this.vertices[0]);
        this.width = d;
        this.height = d2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Rectangle[").append(super.toString()).append("|Width=").append(this.width).append("|Height=").append(this.height).append("]");
        return stringBuilder.toString();
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public double getRotation() {
        return this.normals[1].getAngleBetween(Vector2.X_AXIS);
    }

    @Override
    public Vector2[] getAxes(Vector2[] vector2Array, Transform transform) {
        int n = vector2Array != null ? vector2Array.length : 0;
        Vector2[] vector2Array2 = new Vector2[2 + n];
        int n2 = 0;
        vector2Array2[n2++] = transform.getTransformedR(this.normals[1]);
        vector2Array2[n2++] = transform.getTransformedR(this.normals[2]);
        for (int i = 0; i < n; ++i) {
            Vector2 vector2 = vector2Array[i];
            Vector2 vector22 = transform.getTransformed(this.vertices[0]);
            double d = vector2.distanceSquared(vector22);
            for (int j = 1; j < 4; ++j) {
                Vector2 vector23 = this.vertices[j];
                double d2 = vector2.distanceSquared(vector23 = transform.getTransformed(vector23));
                if (!(d2 < d)) continue;
                vector22 = vector23;
                d = d2;
            }
            Vector2 vector24 = vector2.to(vector22);
            vector24.normalize();
            vector2Array2[n2++] = vector24;
        }
        return vector2Array2;
    }

    @Override
    public boolean contains(Vector2 vector2, Transform transform) {
        Vector2 vector22 = transform.getInverseTransformed(vector2);
        Vector2 vector23 = this.center;
        Vector2 vector24 = this.vertices[0];
        Vector2 vector25 = this.vertices[1];
        Vector2 vector26 = this.vertices[3];
        double d = vector24.distanceSquared(vector25);
        double d2 = vector24.distanceSquared(vector26);
        Vector2 vector27 = vector24.to(vector25);
        Vector2 vector28 = vector24.to(vector26);
        Vector2 vector29 = vector23.to(vector22);
        return vector29.project(vector27).getMagnitudeSquared() <= d * 0.25 && vector29.project(vector28).getMagnitudeSquared() <= d2 * 0.25;
    }

    @Override
    public Interval project(Vector2 vector2, Transform transform) {
        Vector2 vector22 = transform.getTransformed(this.center);
        Vector2 vector23 = transform.getTransformedR(this.normals[1]);
        Vector2 vector24 = transform.getTransformedR(this.normals[2]);
        double d = vector22.dot(vector2);
        double d2 = this.width * 0.5 * Math.abs(vector23.dot(vector2)) + this.height * 0.5 * Math.abs(vector24.dot(vector2));
        return new Interval(d - d2, d + d2);
    }

    @Override
    public Mass createMass(double d) {
        double d2 = this.height;
        double d3 = this.width;
        double d4 = d * d2 * d3;
        double d5 = d4 * (d2 * d2 + d3 * d3) / 12.0;
        return new Mass(this.center, d4, d5);
    }
}

