/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.Epsilon;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Edge;
import org.dyn4j.geometry.Geometry;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Vertex;
import org.dyn4j.geometry.Wound;
import org.dyn4j.resources.Messages;

public class Segment
extends Wound
implements Convex,
Shape,
Transformable {
    protected double length;

    public Segment(Vector2 vector2, Vector2 vector22) {
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("geometry.segment.nullPoint1"));
        }
        if (vector22 == null) {
            throw new NullPointerException(Messages.getString("geometry.segment.nullPoint2"));
        }
        if (vector2.equals(vector22)) {
            throw new IllegalArgumentException(Messages.getString("geometry.segment.samePoint"));
        }
        this.vertices = new Vector2[2];
        this.vertices[0] = vector2;
        this.vertices[1] = vector22;
        this.normals = new Vector2[2];
        this.normals[0] = vector2.to(vector22).right();
        this.normals[0].normalize();
        this.normals[1] = vector2.to(vector22).left();
        this.normals[1].normalize();
        this.center = Geometry.getAverageCenter(this.vertices);
        this.length = vector2.distance(vector22);
        this.radius = this.length * 0.5;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Segment[").append(super.toString()).append("|Length=").append(this.length).append("|UserData=").append(this.userData).append("]");
        return stringBuilder.toString();
    }

    public Vector2 getPoint1() {
        return this.vertices[0];
    }

    public Vector2 getPoint2() {
        return this.vertices[1];
    }

    public double getLength() {
        return this.length;
    }

    public static double getLocation(Vector2 vector2, Vector2 vector22, Vector2 vector23) {
        return (vector23.x - vector22.x) * (vector2.y - vector22.y) - (vector2.x - vector22.x) * (vector23.y - vector22.y);
    }

    public static Vector2 getPointOnLineClosestToPoint(Vector2 vector2, Vector2 vector22, Vector2 vector23) {
        Vector2 vector24 = vector2.difference(vector22);
        Vector2 vector25 = vector23.difference(vector22);
        double d = vector25.dot(vector25);
        if (d <= Epsilon.E) {
            return vector22.copy();
        }
        double d2 = vector24.dot(vector25);
        double d3 = d2 / d;
        return vector25.multiply(d3).add(vector22);
    }

    public Vector2 getPointOnLineClosestToPoint(Vector2 vector2) {
        return Segment.getPointOnLineClosestToPoint(vector2, this.vertices[0], this.vertices[1]);
    }

    public static Vector2 getPointOnSegmentClosestToPoint(Vector2 vector2, Vector2 vector22, Vector2 vector23) {
        Vector2 vector24 = vector2.difference(vector22);
        Vector2 vector25 = vector23.difference(vector22);
        double d = vector25.dot(vector25);
        double d2 = vector24.dot(vector25);
        if (d <= Epsilon.E) {
            return vector22.copy();
        }
        double d3 = d2 / d;
        d3 = Interval.clamp(d3, 0.0, 1.0);
        return vector25.multiply(d3).add(vector22);
    }

    public Vector2 getPointOnSegmentClosestToPoint(Vector2 vector2) {
        return Segment.getPointOnSegmentClosestToPoint(vector2, this.vertices[0], this.vertices[1]);
    }

    public static Vector2 getLineIntersection(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24) {
        Vector2 vector25 = vector2.to(vector22);
        Vector2 vector26 = vector23.to(vector24);
        double d = vector26.cross(vector25);
        if (Math.abs(d) <= Epsilon.E) {
            return null;
        }
        double d2 = vector2.difference(vector23).cross(vector25);
        if (Math.abs(d2) <= Epsilon.E) {
            return null;
        }
        double d3 = d2 / d;
        return vector26.product(d3).add(vector23);
    }

    public Vector2 getLineIntersection(Segment segment) {
        return Segment.getLineIntersection(this.vertices[0], this.vertices[1], segment.vertices[0], segment.vertices[1]);
    }

    public static Vector2 getSegmentIntersection(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24) {
        Vector2 vector25 = vector2.to(vector22);
        Vector2 vector26 = vector23.to(vector24);
        double d = vector26.cross(vector25);
        if (Math.abs(d) <= Epsilon.E) {
            return null;
        }
        double d2 = vector2.difference(vector23).cross(vector25);
        if (Math.abs(d2) <= Epsilon.E) {
            return null;
        }
        double d3 = d2 / d;
        if (d3 < 0.0 || d3 > 1.0) {
            return null;
        }
        Vector2 vector27 = vector26.product(d3).add(vector23);
        double d4 = vector27.difference(vector2).dot(vector25) / vector25.dot(vector25);
        if (d4 < 0.0 || d4 > 1.0) {
            return null;
        }
        return vector27;
    }

    public Vector2 getSegmentIntersection(Segment segment) {
        return Segment.getSegmentIntersection(this.vertices[0], this.vertices[1], segment.vertices[0], segment.vertices[1]);
    }

    public static final Edge getFarthestFeature(Vector2 vector2, Vector2 vector22, Vector2 vector23, Transform transform) {
        Vector2 vector24 = null;
        Vector2 vector25 = transform.getTransformed(vector2);
        Vector2 vector26 = transform.getTransformed(vector22);
        double d = vector23.dot(vector25);
        double d2 = vector23.dot(vector26);
        int n = 0;
        if (d >= d2) {
            vector24 = vector25;
            n = 0;
        } else {
            vector24 = vector26;
            n = 1;
        }
        Vertex vertex = new Vertex(vector25, 0);
        Vertex vertex2 = new Vertex(vector26, 1);
        Vertex vertex3 = new Vertex(vector24, n);
        if (vector25.to(vector26).right().dot(vector23) > 0.0) {
            return new Edge(vertex2, vertex, vertex3, vector26.to(vector25), 0);
        }
        return new Edge(vertex, vertex2, vertex3, vector25.to(vector26), 0);
    }

    public static final Vector2 getFarthestPoint(Vector2 vector2, Vector2 vector22, Vector2 vector23, Transform transform) {
        double d;
        Vector2 vector24 = transform.getTransformed(vector2);
        Vector2 vector25 = transform.getTransformed(vector22);
        double d2 = vector23.dot(vector24);
        if (d2 >= (d = vector23.dot(vector25))) {
            return vector24;
        }
        return vector25;
    }

    @Override
    public Vector2[] getAxes(Vector2[] vector2Array, Transform transform) {
        int n = vector2Array != null ? vector2Array.length : 0;
        Vector2[] vector2Array2 = new Vector2[2 + n];
        int n2 = 0;
        Vector2 vector2 = transform.getTransformed(this.vertices[0]);
        Vector2 vector22 = transform.getTransformed(this.vertices[1]);
        vector2Array2[n2++] = transform.getTransformedR(this.normals[1]);
        vector2Array2[n2++] = transform.getTransformedR(this.normals[0].getLeftHandOrthogonalVector());
        for (int i = 0; i < n; ++i) {
            Vector2 vector23 = vector2Array[i];
            Vector2 vector24 = vector2.distanceSquared(vector23) < vector22.distanceSquared(vector23) ? vector2.to(vector23) : vector22.to(vector23);
            vector24.normalize();
            vector2Array2[n2++] = vector24;
        }
        return vector2Array2;
    }

    @Override
    public Vector2[] getFoci(Transform transform) {
        return null;
    }

    @Override
    public boolean contains(Vector2 vector2, Transform transform) {
        Vector2 vector22;
        Vector2 vector23;
        Vector2 vector24 = transform.getInverseTransformed(vector2);
        double d = Segment.getLocation(vector24, vector23 = this.vertices[0], vector22 = this.vertices[1]);
        if (Math.abs(d) <= Epsilon.E) {
            double d2 = vector23.distanceSquared(vector22);
            return vector24.distanceSquared(vector23) <= d2 && vector24.distanceSquared(vector22) <= d2;
        }
        return false;
    }

    public boolean contains(Vector2 vector2, Transform transform, double d) {
        double d2;
        if (d <= 0.0) {
            return this.contains(vector2, transform);
        }
        Vector2 vector22 = transform.getInverseTransformed(vector2);
        if (this.vertices[0].distanceSquared(vector22) <= d * d) {
            return true;
        }
        if (this.vertices[1].distanceSquared(vector22) <= d * d) {
            return true;
        }
        Vector2 vector23 = this.vertices[0].to(this.vertices[1]);
        Vector2 vector24 = this.vertices[0].to(vector22);
        Vector2 vector25 = this.vertices[1].to(vector22);
        return vector23.dot(vector24) > 0.0 && -vector23.dot(vector25) > 0.0 && (d2 = vector24.project(vector23.getRightHandOrthogonalVector()).getMagnitudeSquared()) <= d * d;
    }

    @Override
    public Interval project(Vector2 vector2, Transform transform) {
        double d;
        double d2 = 0.0;
        Vector2 vector22 = transform.getTransformed(this.vertices[0]);
        Vector2 vector23 = transform.getTransformed(this.vertices[1]);
        double d3 = d = vector2.dot(vector22);
        d2 = vector2.dot(vector23);
        if (d2 < d) {
            d = d2;
        } else if (d2 > d3) {
            d3 = d2;
        }
        return new Interval(d, d3);
    }

    @Override
    public Vector2 getFarthestPoint(Vector2 vector2, Transform transform) {
        return Segment.getFarthestPoint(this.vertices[0], this.vertices[1], vector2, transform);
    }

    @Override
    public Edge getFarthestFeature(Vector2 vector2, Transform transform) {
        return Segment.getFarthestFeature(this.vertices[0], this.vertices[1], vector2, transform);
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        super.rotate(d, d2, d3);
        this.vertices[0].rotate(d, d2, d3);
        this.vertices[1].rotate(d, d2, d3);
        this.normals[0].rotate(d, d2, d3);
        this.normals[1].rotate(d, d2, d3);
    }

    @Override
    public void translate(double d, double d2) {
        super.translate(d, d2);
        this.vertices[0].add(d, d2);
        this.vertices[1].add(d, d2);
    }

    @Override
    public Mass createMass(double d) {
        double d2 = this.length;
        double d3 = d * d2;
        double d4 = d2 * d2 * d3 / 12.0;
        return new Mass(this.center, d3, d4);
    }

    @Override
    public AABB createAABB(Transform transform) {
        double d;
        double d2;
        double d3 = 0.0;
        double d4 = 0.0;
        Vector2 vector2 = transform.getTransformed(this.vertices[0]);
        double d5 = d2 = Vector2.X_AXIS.dot(vector2);
        double d6 = d = Vector2.Y_AXIS.dot(vector2);
        vector2 = transform.getTransformed(this.vertices[1]);
        d3 = Vector2.X_AXIS.dot(vector2);
        d4 = Vector2.Y_AXIS.dot(vector2);
        d2 = Math.min(d2, d3);
        d5 = Math.max(d5, d3);
        d = Math.min(d, d4);
        d6 = Math.max(d6, d4);
        return new AABB(d2, d, d5, d6);
    }
}

