/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.Epsilon;

public class Vector3 {
    public double x;
    public double y;
    public double z;

    public Vector3() {
    }

    public Vector3(Vector3 vector3) {
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
    }

    public Vector3(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vector3(double d, double d2, double d3, double d4, double d5, double d6) {
        this.x = d4 - d;
        this.y = d5 - d2;
        this.z = d6 - d3;
    }

    public Vector3(Vector3 vector3, Vector3 vector32) {
        this.x = vector32.x - vector3.x;
        this.y = vector32.y - vector3.y;
        this.z = vector32.z - vector3.z;
    }

    public Vector3 copy() {
        return new Vector3(this.x, this.y, this.z);
    }

    public double distance(double d, double d2, double d3) {
        double d4 = this.x - d;
        double d5 = this.y - d2;
        double d6 = this.z - d3;
        return Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
    }

    public double distance(Vector3 vector3) {
        double d = this.x - vector3.x;
        double d2 = this.y - vector3.y;
        double d3 = this.z - vector3.z;
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public double distanceSquared(double d, double d2, double d3) {
        double d4 = this.x - d;
        double d5 = this.y - d2;
        double d6 = this.z - d3;
        return d4 * d4 + d5 * d5 + d6 * d6;
    }

    public double distanceSquared(Vector3 vector3) {
        double d = this.x - vector3.x;
        double d2 = this.y - vector3.y;
        double d3 = this.z - vector3.z;
        return d * d + d2 * d2 + d3 * d3;
    }

    public static Vector3 tripleProduct(Vector3 vector3, Vector3 vector32, Vector3 vector33) {
        Vector3 vector34 = new Vector3();
        double d = vector3.x * vector33.x + vector3.y * vector33.y + vector3.z * vector33.z;
        double d2 = vector32.x * vector33.x + vector32.y * vector33.y + vector32.z * vector33.z;
        vector34.x = vector32.x * d - vector3.x * d2;
        vector34.y = vector32.y * d - vector3.y * d2;
        vector34.z = vector32.z * d - vector3.z * d2;
        return vector34;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.x);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.z);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Vector3) {
            Vector3 vector3 = (Vector3)object;
            if (this.x == vector3.x && this.y == vector3.y && this.z == vector3.z) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Vector3 vector3) {
        if (vector3 == null) {
            return false;
        }
        if (this == vector3) {
            return true;
        }
        return this.x == vector3.x && this.y == vector3.y && this.z == vector3.z;
    }

    public boolean equals(double d, double d2, double d3) {
        return this.x == d && this.y == d2 && this.z == d3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append(this.x).append(", ").append(this.y).append(", ").append(this.z).append(")");
        return stringBuilder.toString();
    }

    public Vector3 set(Vector3 vector3) {
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
        return this;
    }

    public Vector3 set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Vector3 getXComponent() {
        return new Vector3(this.x, 0.0, 0.0);
    }

    public Vector3 getYComponent() {
        return new Vector3(0.0, this.y, 0.0);
    }

    public Vector3 getZComponent() {
        return new Vector3(0.0, 0.0, this.z);
    }

    public double getMagnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double getMagnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3 setMagnitude(double d) {
        if (Math.abs(d) <= Epsilon.E) {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
            return this;
        }
        if (this.isZero()) {
            return this;
        }
        double d2 = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        d2 = d / d2;
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        return this;
    }

    public Vector3 add(Vector3 vector3) {
        this.x += vector3.x;
        this.y += vector3.y;
        this.z += vector3.z;
        return this;
    }

    public Vector3 add(double d, double d2, double d3) {
        this.x += d;
        this.y += d2;
        this.z += d3;
        return this;
    }

    public Vector3 sum(Vector3 vector3) {
        return new Vector3(this.x + vector3.x, this.y + vector3.y, this.z + vector3.z);
    }

    public Vector3 sum(double d, double d2, double d3) {
        return new Vector3(this.x + d, this.y + d2, this.z + d3);
    }

    public Vector3 subtract(Vector3 vector3) {
        this.x -= vector3.x;
        this.y -= vector3.y;
        this.z -= vector3.z;
        return this;
    }

    public Vector3 subtract(double d, double d2, double d3) {
        this.x -= d;
        this.y -= d2;
        this.z -= d3;
        return this;
    }

    public Vector3 difference(Vector3 vector3) {
        return new Vector3(this.x - vector3.x, this.y - vector3.y, this.z - vector3.z);
    }

    public Vector3 difference(double d, double d2, double d3) {
        return new Vector3(this.x - d, this.y - d2, this.z - d3);
    }

    public Vector3 to(Vector3 vector3) {
        return new Vector3(vector3.x - this.x, vector3.y - this.y, vector3.z - this.z);
    }

    public Vector3 to(double d, double d2, double d3) {
        return new Vector3(d - this.x, d2 - this.y, d3 - this.z);
    }

    public Vector3 multiply(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public Vector3 product(double d) {
        return new Vector3(this.x * d, this.y * d, this.z * d);
    }

    public double dot(Vector3 vector3) {
        return this.x * vector3.x + this.y * vector3.y + this.z * vector3.z;
    }

    public double dot(double d, double d2, double d3) {
        return this.x * d + this.y * d2 + this.z * d3;
    }

    public Vector3 cross(Vector3 vector3) {
        return new Vector3(this.y * vector3.z - this.z * vector3.y, this.z * vector3.x - this.x * vector3.z, this.x * vector3.y - this.y * vector3.x);
    }

    public Vector3 cross(double d, double d2, double d3) {
        return new Vector3(this.y * d3 - this.z * d2, this.z * d - this.x * d3, this.x * d2 - this.y * d);
    }

    public boolean isOrthogonal(Vector3 vector3) {
        return Math.abs(this.x * vector3.x + this.y * vector3.y + this.z * vector3.z) <= Epsilon.E;
    }

    public boolean isOrthogonal(double d, double d2, double d3) {
        return Math.abs(this.x * d + this.y * d2 + this.z * d3) <= Epsilon.E;
    }

    public boolean isZero() {
        return Math.abs(this.x) <= Epsilon.E && Math.abs(this.y) <= Epsilon.E && Math.abs(this.z) <= Epsilon.E;
    }

    public Vector3 negate() {
        this.x *= -1.0;
        this.y *= -1.0;
        this.z *= -1.0;
        return this;
    }

    public Vector3 getNegative() {
        return new Vector3(-this.x, -this.y, -this.z);
    }

    public Vector3 zero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        return this;
    }

    public Vector3 project(Vector3 vector3) {
        double d = this.dot(vector3);
        double d2 = vector3.dot(vector3);
        if (d2 <= Epsilon.E) {
            return new Vector3();
        }
        d2 = d / d2;
        return new Vector3(d2 * vector3.x, d2 * vector3.y, d2 * vector3.z);
    }

    public Vector3 getNormalized() {
        double d = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (d <= Epsilon.E) {
            return new Vector3();
        }
        d = 1.0 / d;
        return new Vector3(this.x * d, this.y * d, this.z * d);
    }

    public double normalize() {
        double d = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (d <= Epsilon.E) {
            return 0.0;
        }
        double d2 = 1.0 / d;
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        return d;
    }
}

