/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.geometry.AbstractShape;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;

public abstract class Wound
extends AbstractShape
implements Shape,
Transformable {
    protected Vector2[] vertices;
    protected Vector2[] normals;

    @Override
    public double getRadius(Vector2 vector2) {
        int n = this.vertices.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = vector2.distanceSquared(this.vertices[i]);
            d = Math.max(d, d2);
        }
        return Math.sqrt(d);
    }

    @Override
    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("|Vertices{");
        for (n = 0; n < this.vertices.length; ++n) {
            if (n != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.vertices[n]);
        }
        stringBuilder.append("}|Normals{");
        for (n = 0; n < this.normals.length; ++n) {
            if (n != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.normals[n]);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public Vector2[] getVertices() {
        return this.vertices;
    }

    public Vector2[] getNormals() {
        return this.normals;
    }
}

