/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.decompose;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dyn4j.Epsilon;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Geometry;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.decompose.Decomposer;
import org.dyn4j.resources.Messages;

public class Bayazit
implements Decomposer {
    @Override
    public List<Convex> decompose(Vector2 ... vector2Array) {
        if (vector2Array == null) {
            throw new NullPointerException(Messages.getString("geometry.decompose.nullArray"));
        }
        int n = vector2Array.length;
        if (n < 4) {
            throw new IllegalArgumentException(Messages.getString("geometry.decompose.invalidSize"));
        }
        double d = Geometry.getWinding(vector2Array);
        if (d < 0.0) {
            Geometry.reverseWinding(vector2Array);
        }
        ArrayList<Vector2> arrayList = new ArrayList<Vector2>();
        Collections.addAll(arrayList, vector2Array);
        ArrayList<Convex> arrayList2 = new ArrayList<Convex>();
        this.decomposePolygon(arrayList, arrayList2);
        return arrayList2;
    }

    protected void decomposePolygon(List<Vector2> list, List<Convex> list2) {
        int n = list.size();
        Vector2 vector2 = new Vector2();
        Vector2 vector22 = new Vector2();
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        ArrayList<Vector2> arrayList = new ArrayList<Vector2>();
        ArrayList<Vector2> arrayList2 = new ArrayList<Vector2>();
        for (int i = 0; i < n; ++i) {
            Vector2 vector23;
            int n5;
            Vector2 vector24;
            Vector2 vector25 = list.get(i);
            Vector2 vector26 = list.get(i - 1 < 0 ? n - 1 : i - 1);
            if (!this.isReflex(vector26, vector25, vector24 = list.get(i + 1 == n ? 0 : i + 1))) continue;
            for (n5 = 0; n5 < n; ++n5) {
                double d4;
                vector23 = list.get(n5);
                Vector2 vector27 = list.get(n5 - 1 < 0 ? n - 1 : n5 - 1);
                Vector2 vector28 = list.get(n5 + 1 == n ? 0 : n5 + 1);
                Vector2 vector29 = new Vector2();
                if (this.left(vector26, vector25, vector23) && this.rightOn(vector26, vector25, vector27) && this.getIntersection(vector26, vector25, vector23, vector27, vector29) && this.right(vector24, vector25, vector29) && (d4 = vector25.distanceSquared(vector29)) < d2) {
                    d2 = d4;
                    vector22.set(vector29);
                    n3 = n5;
                }
                if (!this.left(vector24, vector25, vector28) || !this.rightOn(vector24, vector25, vector23) || !this.getIntersection(vector24, vector25, vector23, vector28, vector29) || !this.left(vector26, vector25, vector29) || !((d4 = vector25.distanceSquared(vector29)) < d)) continue;
                d = d4;
                vector2.set(vector29);
                n2 = n5;
            }
            if (n3 == (n2 + 1) % n) {
                Vector2 vector210 = vector2.sum(vector22).multiply(0.5);
                if (i < n2) {
                    arrayList.addAll(list.subList(i, n2 + 1));
                    arrayList.add(vector210);
                    arrayList2.add(vector210);
                    if (n3 != 0) {
                        arrayList2.addAll(list.subList(n3, n));
                    }
                    arrayList2.addAll(list.subList(0, i + 1));
                } else {
                    if (i != 0) {
                        arrayList.addAll(list.subList(i, n));
                    }
                    arrayList.addAll(list.subList(0, n2 + 1));
                    arrayList.add(vector210);
                    arrayList2.add(vector210);
                    arrayList2.addAll(list.subList(n3, i + 1));
                }
            } else {
                if (n3 > n2) {
                    n2 += n;
                }
                for (n5 = n3; n5 <= n2; ++n5) {
                    double d5;
                    vector23 = list.get(n5 % n);
                    if (!this.leftOn(vector26, vector25, vector23) || !this.rightOn(vector24, vector25, vector23) || !((d5 = vector25.distanceSquared(vector23)) < d3)) continue;
                    d3 = d5;
                    n4 = n5 % n;
                }
                if (i < n4) {
                    arrayList.addAll(list.subList(i, n4 + 1));
                    if (n4 != 0) {
                        arrayList2.addAll(list.subList(n4, n));
                    }
                    arrayList2.addAll(list.subList(0, i + 1));
                } else {
                    if (i != 0) {
                        arrayList.addAll(list.subList(i, n));
                    }
                    arrayList.addAll(list.subList(0, n4 + 1));
                    arrayList2.addAll(list.subList(n4, i + 1));
                }
            }
            if (arrayList.size() < arrayList2.size()) {
                this.decomposePolygon(arrayList, list2);
                this.decomposePolygon(arrayList2, list2);
            } else {
                this.decomposePolygon(arrayList2, list2);
                this.decomposePolygon(arrayList, list2);
            }
            return;
        }
        if (list.size() < 3) {
            throw new IllegalArgumentException(Messages.getString("geometry.decompose.crossingEdges"));
        }
        Vector2[] vector2Array = new Vector2[list.size()];
        list.toArray(vector2Array);
        list2.add(Geometry.createPolygon(vector2Array));
    }

    protected boolean isReflex(Vector2 vector2, Vector2 vector22, Vector2 vector23) {
        return this.right(vector23, vector2, vector22);
    }

    protected boolean left(Vector2 vector2, Vector2 vector22, Vector2 vector23) {
        return Segment.getLocation(vector23, vector2, vector22) > 0.0;
    }

    protected boolean leftOn(Vector2 vector2, Vector2 vector22, Vector2 vector23) {
        return Segment.getLocation(vector23, vector2, vector22) >= 0.0;
    }

    protected boolean right(Vector2 vector2, Vector2 vector22, Vector2 vector23) {
        return Segment.getLocation(vector23, vector2, vector22) < 0.0;
    }

    protected boolean rightOn(Vector2 vector2, Vector2 vector22, Vector2 vector23) {
        return Segment.getLocation(vector23, vector2, vector22) <= 0.0;
    }

    protected boolean getIntersection(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24, Vector2 vector25) {
        Vector2 vector26;
        Vector2 vector27 = vector2.difference(vector22);
        double d = vector27.cross(vector26 = vector23.difference(vector24));
        if (Math.abs(d) <= Epsilon.E) {
            return false;
        }
        d = 1.0 / d;
        double d2 = d * (vector2.cross(vector27) - vector23.cross(vector27));
        vector25.x = vector23.x * (1.0 - d2) + vector24.x * d2;
        vector25.y = vector23.y * (1.0 - d2) + vector24.y * d2;
        return true;
    }
}

