/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.decompose;

import java.util.List;
import java.util.PriorityQueue;
import org.dyn4j.BinarySearchTree;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Geometry;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Triangle;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.decompose.Decomposer;
import org.dyn4j.geometry.decompose.DoublyConnectedEdgeList;
import org.dyn4j.geometry.decompose.MonotonePolygon;
import org.dyn4j.geometry.decompose.Triangulator;
import org.dyn4j.resources.Messages;

public class SweepLine
implements Decomposer,
Triangulator {
    @Override
    public List<Convex> decompose(Vector2 ... vector2Array) {
        DoublyConnectedEdgeList doublyConnectedEdgeList = this.createTriangulation(vector2Array);
        doublyConnectedEdgeList.hertelMehlhorn();
        return doublyConnectedEdgeList.getConvexDecomposition();
    }

    @Override
    public List<Triangle> triangulate(Vector2 ... vector2Array) {
        DoublyConnectedEdgeList doublyConnectedEdgeList = this.createTriangulation(vector2Array);
        return doublyConnectedEdgeList.getTriangulation();
    }

    protected DoublyConnectedEdgeList createTriangulation(Vector2 ... vector2Array) {
        Object object;
        if (vector2Array == null) {
            throw new NullPointerException(Messages.getString("geometry.decompose.nullArray"));
        }
        int n = vector2Array.length;
        if (n < 4) {
            throw new IllegalArgumentException(Messages.getString("geometry.decompose.invalidSize"));
        }
        double d = Geometry.getWinding(vector2Array);
        if (d < 0.0) {
            Geometry.reverseWinding(vector2Array);
        }
        DoublyConnectedEdgeList doublyConnectedEdgeList = new DoublyConnectedEdgeList(vector2Array);
        EdgeBinaryTree edgeBinaryTree = new EdgeBinaryTree();
        PriorityQueue<Vertex> priorityQueue = this.initialize(vector2Array, doublyConnectedEdgeList, edgeBinaryTree);
        while (!priorityQueue.isEmpty()) {
            object = priorityQueue.poll();
            if (((Vertex)object).type == Vertex.Type.START) {
                this.start((Vertex)object, edgeBinaryTree);
                continue;
            }
            if (((Vertex)object).type == Vertex.Type.END) {
                this.end((Vertex)object, edgeBinaryTree, doublyConnectedEdgeList);
                continue;
            }
            if (((Vertex)object).type == Vertex.Type.SPLIT) {
                this.split((Vertex)object, edgeBinaryTree, doublyConnectedEdgeList);
                continue;
            }
            if (((Vertex)object).type == Vertex.Type.MERGE) {
                this.merge((Vertex)object, edgeBinaryTree, doublyConnectedEdgeList);
                continue;
            }
            if (((Vertex)object).type != Vertex.Type.REGULAR) continue;
            this.regular((Vertex)object, edgeBinaryTree, doublyConnectedEdgeList);
        }
        object = doublyConnectedEdgeList.getYMonotonePolygons();
        int n2 = object.size();
        for (int i = 0; i < n2; ++i) {
            doublyConnectedEdgeList.triangulateMonotoneY((MonotonePolygon)object.get(i));
        }
        return doublyConnectedEdgeList;
    }

    protected PriorityQueue<Vertex> initialize(Vector2[] vector2Array, DoublyConnectedEdgeList doublyConnectedEdgeList, EdgeBinaryTree edgeBinaryTree) {
        int n = vector2Array.length;
        PriorityQueue<Vertex> priorityQueue = new PriorityQueue<Vertex>(n);
        Vertex vertex = null;
        Vertex vertex2 = null;
        Edge edge = null;
        Edge edge2 = null;
        for (int i = 0; i < n; ++i) {
            Vector2 vector2 = vector2Array[i];
            Vertex vertex3 = new Vertex();
            vertex3.point = vector2;
            vertex3.type = Vertex.Type.REGULAR;
            vertex3.prev = vertex2;
            vertex3.dcelReference = doublyConnectedEdgeList.vertices.get(i);
            if (vertex2 != null) {
                vertex2.next = vertex3;
            }
            if (vertex == null) {
                vertex = vertex3;
            }
            Vector2 vector22 = vector2Array[i + 1 == n ? 0 : i + 1];
            Vector2 vector23 = vector2Array[i == 0 ? n - 1 : i - 1];
            vertex3.type = this.getType(vector23, vector2, vector22);
            vertex2 = vertex3;
            priorityQueue.offer(vertex3);
            Edge edge3 = new Edge();
            edge3.tree = edgeBinaryTree;
            edge3.prev = edge2;
            edge3.v0 = vertex3;
            double d = vector2.y - vector22.y;
            if (d == 0.0) {
                edge3.slope = Double.POSITIVE_INFINITY;
            } else {
                double d2 = vector2.x - vector22.x;
                edge3.slope = d2 / d;
            }
            if (edge2 != null) {
                edge2.v1 = vertex3;
                edge2.next = edge3;
            }
            if (edge == null) {
                edge = edge3;
            }
            vertex3.left = edge3;
            vertex3.right = edge2;
            edge2 = edge3;
        }
        edge.prev = edge2;
        edge2.next = edge;
        edge2.v1 = edge.v0;
        vertex.right = edge2;
        vertex.prev = vertex2;
        vertex2.next = vertex;
        return priorityQueue;
    }

    protected Vertex.Type getType(Vector2 vector2, Vector2 vector22, Vector2 vector23) {
        Vector2 vector24 = vector2.to(vector22);
        Vector2 vector25 = vector22.to(vector23);
        if (vector24.isZero() || vector25.isZero()) {
            throw new IllegalArgumentException(Messages.getString("geometry.decompose.coincident"));
        }
        double d = vector24.cross(vector25);
        boolean bl = this.isBelow(vector22, vector2);
        boolean bl2 = this.isBelow(vector22, vector23);
        if (bl && bl2) {
            if (d > 0.0) {
                return Vertex.Type.END;
            }
            return Vertex.Type.MERGE;
        }
        if (!bl && !bl2) {
            if (d > 0.0) {
                return Vertex.Type.START;
            }
            return Vertex.Type.SPLIT;
        }
        return Vertex.Type.REGULAR;
    }

    protected boolean isBelow(Vector2 vector2, Vector2 vector22) {
        double d = vector2.y - vector22.y;
        if (d == 0.0) {
            return vector2.x > vector22.x;
        }
        return d < 0.0;
    }

    protected void start(Vertex vertex, EdgeBinaryTree edgeBinaryTree) {
        Edge edge = vertex.left;
        edgeBinaryTree.referenceY = vertex.point.y;
        edgeBinaryTree.insert(edge);
        edge.helper = vertex;
    }

    protected void end(Vertex vertex, EdgeBinaryTree edgeBinaryTree, DoublyConnectedEdgeList doublyConnectedEdgeList) {
        Edge edge = vertex.right;
        if (edge.helper.type == Vertex.Type.MERGE) {
            doublyConnectedEdgeList.addHalfEdges(vertex.dcelReference, edge.helper.dcelReference);
        }
        edgeBinaryTree.referenceY = vertex.point.y;
        edgeBinaryTree.remove(edge);
    }

    protected void split(Vertex vertex, EdgeBinaryTree edgeBinaryTree, DoublyConnectedEdgeList doublyConnectedEdgeList) {
        Edge edge = edgeBinaryTree.findClosest(vertex);
        doublyConnectedEdgeList.addHalfEdges(vertex.dcelReference, edge.helper.dcelReference);
        edge.helper = vertex;
        edgeBinaryTree.referenceY = vertex.point.y;
        edgeBinaryTree.insert(vertex.left);
        vertex.left.helper = vertex;
    }

    protected void merge(Vertex vertex, EdgeBinaryTree edgeBinaryTree, DoublyConnectedEdgeList doublyConnectedEdgeList) {
        Edge edge = vertex.right;
        if (edge.helper.type == Vertex.Type.MERGE) {
            doublyConnectedEdgeList.addHalfEdges(vertex.dcelReference, edge.helper.dcelReference);
        }
        edgeBinaryTree.referenceY = vertex.point.y;
        edgeBinaryTree.remove(edge);
        Edge edge2 = edgeBinaryTree.findClosest(vertex);
        if (edge2.helper.type == Vertex.Type.MERGE) {
            doublyConnectedEdgeList.addHalfEdges(vertex.dcelReference, edge2.helper.dcelReference);
        }
        edge2.helper = vertex;
    }

    protected void regular(Vertex vertex, EdgeBinaryTree edgeBinaryTree, DoublyConnectedEdgeList doublyConnectedEdgeList) {
        if (vertex.isInteriorRight()) {
            if (vertex.right.helper.type == Vertex.Type.MERGE) {
                doublyConnectedEdgeList.addHalfEdges(vertex.dcelReference, vertex.right.helper.dcelReference);
            }
            edgeBinaryTree.referenceY = vertex.point.y;
            edgeBinaryTree.remove(vertex.right);
            edgeBinaryTree.insert(vertex.left);
            vertex.left.helper = vertex;
        } else {
            Edge edge = edgeBinaryTree.findClosest(vertex);
            if (edge.helper.type == Vertex.Type.MERGE) {
                doublyConnectedEdgeList.addHalfEdges(vertex.dcelReference, edge.helper.dcelReference);
            }
            edge.helper = vertex;
        }
    }

    protected static class EdgeBinaryTree
    extends BinarySearchTree<Edge> {
        protected double referenceY = 0.0;

        public EdgeBinaryTree() {
            super(true);
        }

        public Edge findClosest(Vertex vertex) {
            BinarySearchTree.Node node;
            if (this.root == null) {
                return null;
            }
            BinarySearchTree.Node node2 = node = this.root;
            while (node != null) {
                Edge edge = (Edge)node.comparable;
                if (vertex.isLeft(edge)) {
                    node = node.left;
                    continue;
                }
                node2 = node;
                node = node.right;
            }
            return (Edge)node2.comparable;
        }
    }

    protected class Edge
    implements Comparable<Edge> {
        protected EdgeBinaryTree tree;
        protected Edge next;
        protected Edge prev;
        protected Vertex v0;
        protected Vertex v1;
        protected Vertex helper;
        protected double slope;

        protected Edge() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SweepLine.Edge[V0=").append(this.v0).append("|V1=").append(this.v1).append("]");
            return stringBuilder.toString();
        }

        @Override
        public int compareTo(Edge edge) {
            double d;
            if (this == edge) {
                return 0;
            }
            double d2 = this.tree.referenceY;
            double d3 = this.getSortValue(d2);
            if (d3 < (d = edge.getSortValue(d2))) {
                return -1;
            }
            return 1;
        }

        public double getSortValue(double d) {
            Vector2 vector2 = this.v0.point;
            if (this.v1.point.x < this.v0.point.x) {
                vector2 = this.v1.point;
            }
            if (this.slope == Double.POSITIVE_INFINITY) {
                return vector2.x;
            }
            return vector2.x + (d - vector2.y) * this.slope;
        }

        public boolean isInteriorRight() {
            double d = this.v0.point.y - this.v1.point.y;
            if (d == 0.0) {
                return this.v0.point.x < this.v1.point.x;
            }
            return d > 0.0;
        }
    }

    protected static class Vertex
    implements Comparable<Vertex> {
        protected Vector2 point;
        protected Type type;
        protected Vertex next;
        protected Vertex prev;
        protected Edge left;
        protected Edge right;
        protected DoublyConnectedEdgeList.Vertex dcelReference;

        protected Vertex() {
        }

        @Override
        public int compareTo(Vertex vertex) {
            Vector2 vector2 = this.point;
            Vector2 vector22 = vertex.point;
            double d = vector22.y - vector2.y;
            if (d == 0.0) {
                return (int)Math.signum(vector2.x - vector22.x);
            }
            return (int)Math.signum(d);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SweepLine.Vertex[Point=").append(this.point).append("|Type=").append((Object)this.type).append("]");
            return stringBuilder.toString();
        }

        public boolean isLeft(Edge edge) {
            double d = Segment.getLocation(this.point, edge.v0.point, edge.v1.point);
            return d < 0.0;
        }

        public boolean isInteriorRight() {
            return this.left.isInteriorRight();
        }

        protected static enum Type {
            START,
            SPLIT,
            END,
            MERGE,
            REGULAR;

        }
    }
}

