/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.hull;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.hull.HullGenerator;
import org.dyn4j.resources.Messages;

public class MonotoneChain
implements HullGenerator {
    @Override
    public Vector2[] generate(Vector2 ... vector2Array) {
        Vector2 vector2;
        Vector2 vector22;
        Vector2 vector23;
        Vector2 vector24;
        if (vector2Array == null) {
            throw new NullPointerException(Messages.getString("geometry.hull.nullArray"));
        }
        int n = vector2Array.length;
        if (n == 1 || n == 2) {
            return vector2Array;
        }
        try {
            Arrays.sort(vector2Array, new PointComparator());
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException(Messages.getString("geometry.hull.nullPoints"));
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 1; i < n; ++i) {
            vector24 = vector2Array[n2];
            vector23 = vector2Array[n3];
            Vector2 vector25 = vector2Array[n4];
            vector22 = vector2Array[n5];
            Vector2 vector26 = vector2Array[i];
            if (vector26.x < vector24.x) {
                n2 = i;
                n3 = i;
            } else if (vector26.x == vector24.x) {
                if (vector26.y > vector23.y) {
                    n3 = i;
                } else if (vector26.y < vector24.y) {
                    n2 = i;
                }
            }
            if (vector26.x > vector25.x) {
                n4 = i;
                n5 = i;
                continue;
            }
            if (vector26.x != vector25.x) continue;
            if (vector26.y > vector22.y) {
                n5 = i;
                continue;
            }
            if (!(vector26.y < vector25.y)) continue;
            n4 = i;
        }
        ArrayList<Vector2> arrayList = new ArrayList<Vector2>();
        vector24 = vector2Array[n4];
        vector23 = vector2Array[n2];
        arrayList.add(vector2Array[n2]);
        for (int i = n3 + 1; i <= n4; ++i) {
            vector22 = vector2Array[i];
            if (!(Segment.getLocation(vector22, vector24, vector23) >= 0.0)) continue;
            for (int j = arrayList.size(); j >= 2; --j) {
                Vector2 vector27 = (Vector2)arrayList.get(j - 1);
                vector2 = (Vector2)arrayList.get(j - 2);
                if (Segment.getLocation(vector22, vector2, vector27) > 0.0) break;
                arrayList.remove(j - 1);
            }
            arrayList.add(vector22);
        }
        ArrayList<Vector2> arrayList2 = new ArrayList<Vector2>();
        vector22 = vector2Array[n3];
        Vector2 vector28 = vector2Array[n5];
        arrayList2.add(vector2Array[n5]);
        for (int i = n5 - 1; i >= n3; --i) {
            vector2 = vector2Array[i];
            if (!(Segment.getLocation(vector2, vector22, vector28) >= 0.0)) continue;
            for (int j = arrayList2.size(); j >= 2; --j) {
                Vector2 vector29 = (Vector2)arrayList2.get(j - 1);
                Vector2 vector210 = (Vector2)arrayList2.get(j - 2);
                if (Segment.getLocation(vector2, vector210, vector29) > 0.0) break;
                arrayList2.remove(j - 1);
            }
            arrayList2.add(vector2);
        }
        if (arrayList2.get(0) == arrayList.get(arrayList.size() - 1)) {
            arrayList2.remove(0);
        }
        if (arrayList.get(0) == arrayList2.get(arrayList2.size() - 1)) {
            arrayList.remove(0);
        }
        arrayList.addAll(arrayList2);
        Vector2[] vector2Array2 = new Vector2[arrayList.size()];
        arrayList.toArray(vector2Array2);
        return vector2Array2;
    }

    private class PointComparator
    implements Comparator<Vector2> {
        private PointComparator() {
        }

        @Override
        public int compare(Vector2 vector2, Vector2 vector22) {
            int n = (int)Math.signum(vector2.x - vector22.x);
            if (n == 0) {
                return (int)Math.signum(vector2.y - vector22.y);
            }
            return n;
        }
    }
}

