/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision;

import org.dyn4j.collision.Filter;

public class CategoryFilter
implements Filter {
    protected int category;
    protected int mask;

    public CategoryFilter() {
        this.category = 1;
        this.mask = Integer.MAX_VALUE;
    }

    public CategoryFilter(int n, int n2) {
        this.category = n;
        this.mask = n2;
    }

    @Override
    public boolean isAllowed(Filter filter) {
        if (filter == null) {
            return true;
        }
        if (filter instanceof CategoryFilter) {
            CategoryFilter categoryFilter = (CategoryFilter)filter;
            return (this.category & categoryFilter.mask) > 0 && (categoryFilter.category & this.mask) > 0;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CategoryFilter[Category=").append(this.category).append("|Mask=").append(this.mask).append("]");
        return stringBuilder.toString();
    }

    public int getCategory() {
        return this.category;
    }

    public int getMask() {
        return this.mask;
    }

    public void setCategory(int n) {
        this.category = n;
    }

    public void setMask(int n) {
        this.mask = n;
    }
}

