/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision;

import java.util.UUID;
import org.dyn4j.collision.Filter;
import org.dyn4j.geometry.Convex;
import org.dyn4j.resources.Messages;

public class Fixture {
    protected UUID id = UUID.randomUUID();
    protected Convex shape;
    protected Filter filter;
    protected boolean sensor;
    protected Object userData;

    public Fixture(Convex convex) {
        if (convex == null) {
            throw new NullPointerException(Messages.getString("collision.fixture.nullShape"));
        }
        this.shape = convex;
        this.filter = Filter.DEFAULT_FILTER;
        this.sensor = false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Fixture[Id=").append(this.id).append("|Shape=").append(this.shape).append("|Filter=").append(this.filter).append("|IsSensor=").append(this.sensor).append("|UserData=").append(this.userData).append("]");
        return stringBuilder.toString();
    }

    public UUID getId() {
        return this.id;
    }

    public Convex getShape() {
        return this.shape;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        if (filter == null) {
            throw new NullPointerException(Messages.getString("collision.fixture.nullFilter"));
        }
        this.filter = filter;
    }

    public boolean isSensor() {
        return this.sensor;
    }

    public void setSensor(boolean bl) {
        this.sensor = bl;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }
}

