/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.broadphase;

import java.util.List;
import org.dyn4j.collision.Collidable;
import org.dyn4j.collision.broadphase.BroadphasePair;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Ray;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;

public interface BroadphaseDetector<E extends Collidable> {
    public static final double DEFAULT_AABB_EXPANSION = 0.2;

    public void add(E var1);

    public void remove(E var1);

    public void update(E var1);

    public void clear();

    public AABB getAABB(E var1);

    public List<BroadphasePair<E>> detect();

    public List<E> detect(AABB var1);

    public List<E> raycast(Ray var1, double var2);

    public boolean detect(E var1, E var2);

    public boolean detect(Convex var1, Transform var2, Convex var3, Transform var4);

    public double getAABBExpansion();

    public void setAABBExpansion(double var1);

    public void shiftCoordinates(Vector2 var1);
}

