/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.broadphase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.dyn4j.collision.Collidable;
import org.dyn4j.collision.Collisions;
import org.dyn4j.collision.broadphase.AbstractAABBDetector;
import org.dyn4j.collision.broadphase.BroadphaseDetector;
import org.dyn4j.collision.broadphase.BroadphasePair;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Ray;
import org.dyn4j.geometry.Vector2;

public class SapBruteForce<E extends Collidable>
extends AbstractAABBDetector<E>
implements BroadphaseDetector<E> {
    protected List<Proxy> proxyList;
    protected Map<UUID, Proxy> proxyMap;
    protected ArrayList<PairList> potentialPairs;
    protected boolean sort = false;

    public SapBruteForce() {
        this(64);
    }

    public SapBruteForce(int n) {
        this.proxyList = new ArrayList<Proxy>(n);
        this.proxyMap = new HashMap<UUID, Proxy>(n * 4 / 3 + 1, 0.75f);
        this.potentialPairs = new ArrayList(n);
    }

    @Override
    public void add(E e) {
        UUID uUID = e.getId();
        AABB aABB = e.createAABB();
        aABB.expand(this.expansion);
        Proxy proxy = new Proxy();
        proxy.collidable = e;
        proxy.aabb = aABB;
        this.proxyList.add(proxy);
        this.proxyMap.put(uUID, proxy);
        this.sort = true;
    }

    @Override
    public void remove(E e) {
        Iterator<Proxy> iterator = this.proxyList.iterator();
        while (iterator.hasNext()) {
            Proxy proxy = iterator.next();
            if (proxy.collidable != e) continue;
            iterator.remove();
            break;
        }
        this.proxyMap.remove(e.getId());
    }

    @Override
    public void update(E e) {
        Proxy proxy = this.proxyMap.get(e.getId());
        if (proxy == null) {
            return;
        }
        AABB aABB = e.createAABB();
        if (proxy.aabb.contains(aABB)) {
            return;
        }
        aABB.expand(this.expansion);
        proxy.aabb = aABB;
        this.sort = true;
    }

    @Override
    public void clear() {
        this.proxyList.clear();
        this.proxyMap.clear();
    }

    @Override
    public AABB getAABB(E e) {
        Proxy proxy = this.proxyMap.get(e.getId());
        if (proxy != null) {
            return proxy.aabb;
        }
        return null;
    }

    @Override
    public List<BroadphasePair<E>> detect() {
        int n;
        Object object;
        int n2;
        int n3 = this.proxyList.size();
        if (n3 == 0) {
            return Collections.emptyList();
        }
        int n4 = Collisions.getEstimatedCollisionPairs(n3);
        ArrayList arrayList = new ArrayList(n4);
        this.potentialPairs.clear();
        this.potentialPairs.ensureCapacity(n3);
        if (this.sort) {
            Collections.sort(this.proxyList);
            this.sort = false;
        }
        PairList pairList = new PairList();
        for (n2 = 0; n2 < n3; ++n2) {
            object = this.proxyList.get(n2);
            for (n = n2 + 1; n < n3; ++n) {
                Proxy proxy = this.proxyList.get(n);
                if (!(((Proxy)object).aabb.getMaxX() >= proxy.aabb.getMinX())) break;
                pairList.potentials.add(proxy);
            }
            if (pairList.potentials.size() <= 0) continue;
            pairList.proxy = object;
            this.potentialPairs.add(pairList);
            pairList = new PairList();
        }
        n3 = this.potentialPairs.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = this.potentialPairs.get(n2);
            n = ((PairList)object).potentials.size();
            for (int i = 0; i < n; ++i) {
                Proxy proxy = ((PairList)object).potentials.get(i);
                if (!((PairList)object).proxy.aabb.overlaps(proxy.aabb)) continue;
                BroadphasePair broadphasePair = new BroadphasePair(((PairList)object).proxy.collidable, proxy.collidable);
                arrayList.add(broadphasePair);
            }
        }
        return arrayList;
    }

    @Override
    public List<E> detect(AABB aABB) {
        int n = this.proxyList.size();
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList(Collisions.getEstimatedCollisions());
        if (this.sort) {
            Collections.sort(this.proxyList);
            this.sort = false;
        }
        int n2 = n / 2;
        int n3 = n;
        int n4 = 0;
        while (true) {
            Proxy proxy = this.proxyList.get(n2);
            if (proxy.aabb.getMinX() < aABB.getMinX()) {
                n4 = n2;
            } else {
                n3 = n2;
            }
            if (n3 - n4 == 1) break;
            n2 = (n4 + n3) / 2;
        }
        for (int i = 0; i < n; ++i) {
            Proxy proxy = this.proxyList.get(i);
            if (proxy.aabb.getMaxX() > aABB.getMinX()) {
                if (!proxy.aabb.overlaps(aABB)) continue;
                arrayList.add(proxy.collidable);
                continue;
            }
            if (i >= n2) break;
        }
        return arrayList;
    }

    @Override
    public List<E> raycast(Ray ray, double d) {
        if (this.proxyList.size() == 0) {
            return Collections.emptyList();
        }
        Vector2 vector2 = ray.getStart();
        Vector2 vector22 = ray.getDirectionVector();
        double d2 = d;
        if (d <= 0.0) {
            d2 = Double.MAX_VALUE;
        }
        double d3 = vector2.x;
        double d4 = vector2.x + vector22.x * d2;
        double d5 = vector2.y;
        double d6 = vector2.y + vector22.y * d2;
        Vector2 vector23 = new Vector2(Math.min(d3, d4), Math.min(d5, d6));
        Vector2 vector24 = new Vector2(Math.max(d3, d4), Math.max(d5, d6));
        AABB aABB = new AABB(vector23, vector24);
        return this.detect(aABB);
    }

    @Override
    public void shiftCoordinates(Vector2 vector2) {
        int n = this.proxyList.size();
        for (int i = 0; i < n; ++i) {
            Proxy proxy = this.proxyList.get(i);
            proxy.aabb.translate(vector2);
        }
    }

    protected class PairList {
        public Proxy proxy;
        public List<Proxy> potentials = new ArrayList<Proxy>(Collisions.getEstimatedCollisions());

        protected PairList() {
        }
    }

    protected class Proxy
    implements Comparable<Proxy> {
        public E collidable;
        public AABB aabb;

        protected Proxy() {
        }

        @Override
        public int compareTo(Proxy proxy) {
            if (this == proxy) {
                return 0;
            }
            double d = this.aabb.getMinX() - proxy.aabb.getMinX();
            if (d > 0.0) {
                return 1;
            }
            if (d < 0.0) {
                return -1;
            }
            d = this.aabb.getMinY() - proxy.aabb.getMinY();
            if (d > 0.0) {
                return 1;
            }
            if (d < 0.0) {
                return -1;
            }
            return this.collidable.getId().compareTo(proxy.collidable.getId());
        }

        public String toString() {
            return this.aabb.toString();
        }
    }
}

