/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.broadphase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import org.dyn4j.collision.Collidable;
import org.dyn4j.collision.Collisions;
import org.dyn4j.collision.broadphase.AbstractAABBDetector;
import org.dyn4j.collision.broadphase.BroadphaseDetector;
import org.dyn4j.collision.broadphase.BroadphasePair;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Ray;
import org.dyn4j.geometry.Vector2;

public class SapTree<E extends Collidable>
extends AbstractAABBDetector<E>
implements BroadphaseDetector<E> {
    protected TreeSet<Proxy> proxyTree = new TreeSet();
    protected Map<UUID, Proxy> proxyMap;
    protected ArrayList<PairList> potentialPairs;

    public SapTree() {
        this(64);
    }

    public SapTree(int n) {
        this.proxyMap = new HashMap<UUID, Proxy>(n * 4 / 3 + 1, 0.75f);
        this.potentialPairs = new ArrayList(n);
    }

    @Override
    public void add(E e) {
        UUID uUID = e.getId();
        AABB aABB = e.createAABB();
        aABB.expand(this.expansion);
        Proxy proxy = new Proxy();
        proxy.collidable = e;
        proxy.aabb = aABB;
        this.proxyTree.add(proxy);
        this.proxyMap.put(uUID, proxy);
    }

    @Override
    public void remove(E e) {
        Proxy proxy = this.proxyMap.remove(e.getId());
        if (proxy != null) {
            this.proxyTree.remove(proxy);
        }
    }

    @Override
    public void update(E e) {
        Proxy proxy = this.proxyMap.get(e.getId());
        if (proxy == null) {
            return;
        }
        AABB aABB = e.createAABB();
        if (proxy.aabb.contains(aABB)) {
            return;
        }
        aABB.expand(this.expansion);
        this.proxyTree.remove(proxy);
        proxy.aabb = aABB;
        this.proxyTree.add(proxy);
    }

    @Override
    public void clear() {
        this.proxyTree.clear();
        this.proxyMap.clear();
    }

    @Override
    public AABB getAABB(E e) {
        Proxy proxy = this.proxyMap.get(e.getId());
        if (proxy != null) {
            return proxy.aabb;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<BroadphasePair<E>> detect() {
        Object object;
        int n = this.proxyTree.size();
        if (n == 0) {
            return Collections.emptyList();
        }
        int n2 = Collisions.getEstimatedCollisionPairs(n);
        ArrayList arrayList = new ArrayList(n2);
        this.potentialPairs.clear();
        this.potentialPairs.ensureCapacity(n);
        for (Proxy object22 : this.proxyTree) {
            object22.tested = false;
        }
        PairList pairList = new PairList();
        for (Proxy proxy : this.proxyTree) {
            void var5_7;
            object = this.proxyTree.tailSet(proxy, false);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Proxy proxy2 = (Proxy)iterator.next();
                if (proxy2.collidable == proxy.collidable || proxy2.tested) continue;
                if (!(proxy.aabb.getMaxX() >= proxy2.aabb.getMinX())) break;
                var5_7.potentials.add(proxy2);
            }
            if (var5_7.potentials.size() > 0) {
                var5_7.proxy = proxy;
                this.potentialPairs.add((PairList)var5_7);
                PairList pairList2 = new PairList();
            }
            proxy.tested = true;
        }
        n = this.potentialPairs.size();
        for (int i = 0; i < n; ++i) {
            object = this.potentialPairs.get(i);
            int n3 = ((PairList)object).potentials.size();
            for (int j = 0; j < n3; ++j) {
                Proxy proxy = ((PairList)object).potentials.get(j);
                if (!((PairList)object).proxy.aabb.overlaps(proxy.aabb)) continue;
                BroadphasePair broadphasePair = new BroadphasePair(((PairList)object).proxy.collidable, proxy.collidable);
                arrayList.add(broadphasePair);
            }
        }
        return arrayList;
    }

    @Override
    public List<E> detect(AABB aABB) {
        int n = this.proxyTree.size();
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList(Collisions.getEstimatedCollisions());
        Proxy proxy = new Proxy();
        proxy.aabb = aABB;
        proxy.collidable = null;
        proxy.tested = false;
        Proxy proxy2 = this.proxyTree.ceiling(proxy);
        Iterator<Proxy> iterator = this.proxyTree.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Proxy proxy3 = iterator.next();
            if (proxy3 == proxy2) {
                bl = true;
            }
            if (proxy3.aabb.getMaxX() > aABB.getMinX()) {
                if (!proxy3.aabb.overlaps(aABB)) continue;
                arrayList.add(proxy3.collidable);
                continue;
            }
            if (!bl) continue;
            break;
        }
        return arrayList;
    }

    @Override
    public List<E> raycast(Ray ray, double d) {
        if (this.proxyTree.size() == 0) {
            return Collections.emptyList();
        }
        Vector2 vector2 = ray.getStart();
        Vector2 vector22 = ray.getDirectionVector();
        double d2 = d;
        if (d <= 0.0) {
            d2 = Double.MAX_VALUE;
        }
        double d3 = vector2.x;
        double d4 = vector2.x + vector22.x * d2;
        double d5 = vector2.y;
        double d6 = vector2.y + vector22.y * d2;
        Vector2 vector23 = new Vector2(Math.min(d3, d4), Math.min(d5, d6));
        Vector2 vector24 = new Vector2(Math.max(d3, d4), Math.max(d5, d6));
        AABB aABB = new AABB(vector23, vector24);
        return this.detect(aABB);
    }

    @Override
    public void shiftCoordinates(Vector2 vector2) {
        for (Proxy proxy : this.proxyTree) {
            proxy.aabb.translate(vector2);
        }
    }

    protected class PairList {
        public Proxy proxy;
        public List<Proxy> potentials = new ArrayList<Proxy>(8);

        protected PairList() {
        }
    }

    protected class Proxy
    implements Comparable<Proxy> {
        public E collidable;
        public AABB aabb;
        public boolean tested;

        protected Proxy() {
        }

        @Override
        public int compareTo(Proxy proxy) {
            if (this == proxy) {
                return 0;
            }
            double d = this.aabb.getMinX() - proxy.aabb.getMinX();
            if (d > 0.0) {
                return 1;
            }
            if (d < 0.0) {
                return -1;
            }
            d = this.aabb.getMinY() - proxy.aabb.getMinY();
            if (d > 0.0) {
                return 1;
            }
            if (d < 0.0) {
                return -1;
            }
            if (proxy.collidable == null) {
                return 1;
            }
            if (this.collidable == null) {
                return -1;
            }
            return this.collidable.getId().compareTo(proxy.collidable.getId());
        }

        public String toString() {
            return this.aabb.toString();
        }
    }
}

