/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.narrowphase;

import org.dyn4j.collision.narrowphase.Penetration;
import org.dyn4j.collision.narrowphase.Raycast;
import org.dyn4j.collision.narrowphase.Separation;
import org.dyn4j.geometry.Circle;
import org.dyn4j.geometry.Ray;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;

public class CircleDetector {
    public static boolean detect(Circle circle, Transform transform, Circle circle2, Transform transform2, Penetration penetration) {
        Vector2 vector2 = transform.getTransformed(circle.getCenter());
        Vector2 vector22 = transform2.getTransformed(circle2.getCenter());
        Vector2 vector23 = vector2.to(vector22);
        double d = circle.getRadius() + circle2.getRadius();
        double d2 = vector23.getMagnitude();
        if (d2 < d) {
            penetration.normal = vector23;
            penetration.depth = d - vector23.normalize();
            return true;
        }
        return false;
    }

    public static boolean detect(Circle circle, Transform transform, Circle circle2, Transform transform2) {
        Vector2 vector2 = transform.getTransformed(circle.getCenter());
        Vector2 vector22 = transform2.getTransformed(circle2.getCenter());
        Vector2 vector23 = vector2.to(vector22);
        double d = circle.getRadius() + circle2.getRadius();
        double d2 = vector23.getMagnitude();
        return d2 < d;
    }

    public static boolean distance(Circle circle, Transform transform, Circle circle2, Transform transform2, Separation separation) {
        Vector2 vector2 = transform.getTransformed(circle.getCenter());
        Vector2 vector22 = transform2.getTransformed(circle2.getCenter());
        double d = circle.getRadius();
        double d2 = circle2.getRadius();
        Vector2 vector23 = vector2.to(vector22);
        double d3 = d + d2;
        double d4 = vector23.getMagnitude();
        if (d4 >= d3) {
            separation.normal = vector23;
            separation.distance = vector23.normalize() - d3;
            separation.point1 = vector2.add(vector23.x * d, vector23.y * d);
            separation.point2 = vector22.add(-vector23.x * d2, -vector23.y * d2);
            return true;
        }
        return false;
    }

    public static boolean raycast(Ray ray, double d, Circle circle, Transform transform, Raycast raycast) {
        Vector2 vector2 = ray.getStart();
        Vector2 vector22 = ray.getDirectionVector();
        Vector2 vector23 = transform.getTransformed(circle.getCenter());
        double d2 = circle.getRadius();
        if (circle.contains(vector2, transform)) {
            return false;
        }
        Vector2 vector24 = vector2.difference(vector23);
        double d3 = vector22.dot(vector22);
        double d4 = 2.0 * vector22.dot(vector24);
        double d5 = vector24.dot(vector24) - d2 * d2;
        double d6 = 1.0 / (2.0 * d3);
        double d7 = d4 * d4 - 4.0 * d3 * d5;
        if (d7 < 0.0) {
            return false;
        }
        double d8 = Math.sqrt(d7);
        double d9 = (-d4 + d8) * d6;
        double d10 = (-d4 - d8) * d6;
        double d11 = 0.0;
        if (d9 < 0.0) {
            if (d10 < 0.0) {
                return false;
            }
            d11 = d10;
        } else {
            d11 = d10 < 0.0 ? d9 : (d9 < d10 ? d9 : d10);
        }
        if (d > 0.0 && d11 > d) {
            return false;
        }
        Vector2 vector25 = vector22.product(d11).add(vector2);
        Vector2 vector26 = vector23.to(vector25);
        vector26.normalize();
        raycast.point = vector25;
        raycast.normal = vector26;
        raycast.distance = d11;
        return true;
    }
}

