/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.narrowphase;

import java.util.List;
import org.dyn4j.Epsilon;
import org.dyn4j.collision.narrowphase.MinkowskiPenetrationSolver;
import org.dyn4j.collision.narrowphase.MinkowskiSum;
import org.dyn4j.collision.narrowphase.Penetration;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Epa
implements MinkowskiPenetrationSolver {
    public static final int DEFAULT_MAX_ITERATIONS = 100;
    public static final double DEFAULT_DISTANCE_EPSILON = Math.sqrt(Epsilon.E);
    protected int maxIterations = 100;
    protected double distanceEpsilon = DEFAULT_DISTANCE_EPSILON;

    @Override
    public void getPenetration(List<Vector2> list, MinkowskiSum minkowskiSum, Penetration penetration) {
        int n = this.getWinding(list);
        Vector2 vector2 = null;
        Edge edge = null;
        for (int i = 0; i < this.maxIterations; ++i) {
            edge = this.findClosestEdge(list, n);
            vector2 = minkowskiSum.support(edge.normal);
            double d = vector2.dot(edge.normal);
            if (d - edge.distance < this.distanceEpsilon) {
                penetration.normal = edge.normal;
                penetration.depth = d;
                return;
            }
            list.add(edge.index, vector2);
        }
        penetration.normal = edge.normal;
        penetration.depth = vector2.dot(edge.normal);
    }

    protected Edge findClosestEdge(List<Vector2> list, int n) {
        int n2 = list.size();
        Edge edge = new Edge();
        edge.distance = Double.MAX_VALUE;
        edge.normal = new Vector2();
        Vector2 vector2 = new Vector2();
        for (int i = 0; i < n2; ++i) {
            int n3 = i + 1 == n2 ? 0 : i + 1;
            Vector2 vector22 = list.get(i);
            Vector2 vector23 = list.get(n3);
            vector2.set(vector23.x - vector22.x, vector23.y - vector22.y);
            if (n < 0) {
                vector2.right();
            } else {
                vector2.left();
            }
            vector2.normalize();
            double d = Math.abs(vector22.dot(vector2));
            if (!(d < edge.distance)) continue;
            edge.distance = d;
            edge.normal.set(vector2);
            edge.index = n3;
        }
        return edge;
    }

    protected int getWinding(List<Vector2> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Vector2 vector2;
            int n2 = i + 1 == n ? 0 : i + 1;
            Vector2 vector22 = list.get(i);
            if (vector22.cross(vector2 = list.get(n2)) > 0.0) {
                return 1;
            }
            if (!(vector22.cross(vector2) < 0.0)) continue;
            return -1;
        }
        return 0;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int n) {
        if (n < 5) {
            throw new IllegalArgumentException(Messages.getString("collision.narrowphase.epa.invalidMaximumIterations"));
        }
        this.maxIterations = n;
    }

    public double getDistanceEpsilon() {
        return this.distanceEpsilon;
    }

    public void setDistanceEpsilon(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("collision.narrowphase.epa.invalidDistanceEpsilon"));
        }
        this.distanceEpsilon = d;
    }

    protected static class Edge {
        public double distance;
        public Vector2 normal;
        public int index;

        protected Edge() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Epa.Edge[Normal=").append(this.normal).append("|Index=").append(this.index).append("|Distance=").append(this.distance).append("]");
            return stringBuilder.toString();
        }
    }
}

