/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.narrowphase;

import java.util.ArrayList;
import java.util.List;
import org.dyn4j.Epsilon;
import org.dyn4j.collision.narrowphase.CircleDetector;
import org.dyn4j.collision.narrowphase.DistanceDetector;
import org.dyn4j.collision.narrowphase.Epa;
import org.dyn4j.collision.narrowphase.MinkowskiPenetrationSolver;
import org.dyn4j.collision.narrowphase.MinkowskiSum;
import org.dyn4j.collision.narrowphase.NarrowphaseDetector;
import org.dyn4j.collision.narrowphase.Penetration;
import org.dyn4j.collision.narrowphase.Raycast;
import org.dyn4j.collision.narrowphase.RaycastDetector;
import org.dyn4j.collision.narrowphase.SegmentDetector;
import org.dyn4j.collision.narrowphase.Separation;
import org.dyn4j.geometry.Circle;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Ray;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Gjk
implements NarrowphaseDetector,
DistanceDetector,
RaycastDetector {
    protected static final Vector2 ORIGIN = new Vector2();
    public static final int DEFAULT_MAX_ITERATIONS = 30;
    public static final double DEFAULT_DISTANCE_EPSILON = Math.sqrt(Epsilon.E);
    protected MinkowskiPenetrationSolver minkowskiPenetrationSolver = new Epa();
    protected int maxIterations = 30;
    protected double distanceEpsilon = DEFAULT_DISTANCE_EPSILON;

    public Gjk() {
    }

    public Gjk(MinkowskiPenetrationSolver minkowskiPenetrationSolver) {
        if (minkowskiPenetrationSolver == null) {
            throw new NullPointerException(Messages.getString("collision.narrowphase.gjk.nullMinkowskiPenetrationSolver"));
        }
        this.minkowskiPenetrationSolver = minkowskiPenetrationSolver;
    }

    @Override
    public boolean detect(Convex convex, Transform transform, Convex convex2, Transform transform2, Penetration penetration) {
        if (convex instanceof Circle && convex2 instanceof Circle) {
            return CircleDetector.detect((Circle)convex, transform, (Circle)convex2, transform2, penetration);
        }
        MinkowskiSum minkowskiSum = new MinkowskiSum(convex, transform, convex2, transform2);
        ArrayList<Vector2> arrayList = new ArrayList<Vector2>(3);
        Vector2 vector2 = this.getInitialDirection(convex, transform, convex2, transform2);
        if (this.detect(minkowskiSum, arrayList, vector2)) {
            this.minkowskiPenetrationSolver.getPenetration(arrayList, minkowskiSum, penetration);
            return true;
        }
        return false;
    }

    @Override
    public boolean detect(Convex convex, Transform transform, Convex convex2, Transform transform2) {
        if (convex instanceof Circle && convex2 instanceof Circle) {
            return CircleDetector.detect((Circle)convex, transform, (Circle)convex2, transform2);
        }
        ArrayList<Vector2> arrayList = new ArrayList<Vector2>(3);
        MinkowskiSum minkowskiSum = new MinkowskiSum(convex, transform, convex2, transform2);
        Vector2 vector2 = this.getInitialDirection(convex, transform, convex2, transform2);
        return this.detect(minkowskiSum, arrayList, vector2);
    }

    protected Vector2 getInitialDirection(Convex convex, Transform transform, Convex convex2, Transform transform2) {
        Vector2 vector2 = transform.getTransformed(convex.getCenter());
        Vector2 vector22 = transform2.getTransformed(convex2.getCenter());
        return vector2.to(vector22);
    }

    protected boolean detect(MinkowskiSum minkowskiSum, List<Vector2> list, Vector2 vector2) {
        if (vector2.isZero()) {
            vector2.set(1.0, 0.0);
        }
        list.add(minkowskiSum.support(vector2));
        if (list.get(0).dot(vector2) <= 0.0) {
            return false;
        }
        vector2.negate();
        do {
            list.add(minkowskiSum.support(vector2));
            if (!(list.get(list.size() - 1).dot(vector2) <= 0.0)) continue;
            return false;
        } while (!this.checkSimplex(list, vector2));
        return true;
    }

    protected boolean checkSimplex(List<Vector2> list, Vector2 vector2) {
        Vector2 vector22 = list.get(list.size() - 1);
        Vector2 vector23 = vector22.getNegative();
        if (list.size() == 3) {
            Vector2 vector24 = list.get(1);
            Vector2 vector25 = list.get(0);
            Vector2 vector26 = vector22.to(vector24);
            Vector2 vector27 = vector22.to(vector25);
            Vector2 vector28 = Vector2.tripleProduct(vector27, vector26, vector26);
            Vector2 vector29 = Vector2.tripleProduct(vector26, vector27, vector27);
            double d = vector29.dot(vector23);
            if (d >= 0.0) {
                list.remove(1);
                vector2.set(vector29);
            } else {
                double d2 = vector28.dot(vector23);
                if (d2 < 0.0) {
                    return true;
                }
                list.remove(0);
                vector2.set(vector28);
            }
        } else {
            Vector2 vector210 = list.get(0);
            Vector2 vector211 = vector22.to(vector210);
            vector2.set(Vector2.tripleProduct(vector211, vector23, vector211));
            if (vector2.getMagnitudeSquared() <= Epsilon.E) {
                vector2.set(vector211.left());
            }
        }
        return false;
    }

    @Override
    public boolean distance(Convex convex, Transform transform, Convex convex2, Transform transform2, Separation separation) {
        Vector2 vector2;
        if (convex instanceof Circle && convex2 instanceof Circle) {
            return CircleDetector.distance((Circle)convex, transform, (Circle)convex2, transform2, separation);
        }
        MinkowskiSum minkowskiSum = new MinkowskiSum(convex, transform, convex2, transform2);
        MinkowskiSum.Point point = new MinkowskiSum.Point();
        MinkowskiSum.Point point2 = new MinkowskiSum.Point();
        MinkowskiSum.Point point3 = new MinkowskiSum.Point();
        Vector2 vector22 = transform.getTransformed(convex.getCenter());
        Vector2 vector23 = vector22.to(vector2 = transform2.getTransformed(convex2.getCenter()));
        if (vector23.isZero()) {
            return false;
        }
        minkowskiSum.support(vector23, point);
        vector23.negate();
        minkowskiSum.support(vector23, point2);
        vector23 = Segment.getPointOnSegmentClosestToPoint(ORIGIN, point2.p, point.p);
        for (int i = 0; i < this.maxIterations; ++i) {
            vector23.negate();
            if (vector23.getMagnitudeSquared() <= Epsilon.E) {
                return false;
            }
            minkowskiSum.support(vector23, point3);
            if (this.containsOrigin(point.p, point2.p, point3.p)) {
                return false;
            }
            double d = point3.p.dot(vector23);
            if (d - point.p.dot(vector23) < this.distanceEpsilon) {
                vector23.normalize();
                separation.normal = vector23;
                separation.distance = -point3.p.dot(vector23);
                this.findClosestPoints(point, point2, separation);
                return true;
            }
            Vector2 vector24 = Segment.getPointOnSegmentClosestToPoint(ORIGIN, point.p, point3.p);
            Vector2 vector25 = Segment.getPointOnSegmentClosestToPoint(ORIGIN, point3.p, point2.p);
            double d2 = vector24.getMagnitudeSquared();
            double d3 = vector25.getMagnitudeSquared();
            if (d2 <= Epsilon.E) {
                vector23.normalize();
                separation.distance = vector24.normalize();
                separation.normal = vector23;
                this.findClosestPoints(point, point3, separation);
                return true;
            }
            if (d3 <= Epsilon.E) {
                vector23.normalize();
                separation.distance = vector25.normalize();
                separation.normal = vector23;
                this.findClosestPoints(point3, point2, separation);
                return true;
            }
            if (d2 < d3) {
                point2.set(point3);
                vector23 = vector24;
                continue;
            }
            point.set(point3);
            vector23 = vector25;
        }
        vector23.normalize();
        separation.normal = vector23;
        separation.distance = -point3.p.dot(vector23);
        this.findClosestPoints(point, point2, separation);
        return true;
    }

    protected void findClosestPoints(MinkowskiSum.Point point, MinkowskiSum.Point point2, Separation separation) {
        Vector2 vector2 = new Vector2();
        Vector2 vector22 = new Vector2();
        Vector2 vector23 = point.p.to(point2.p);
        if (vector23.isZero()) {
            vector2.set(point.p1);
            vector22.set(point.p2);
        } else {
            double d = vector23.dot(vector23);
            double d2 = -vector23.dot(point.p) / d;
            double d3 = 1.0 - d2;
            if (d3 < 0.0) {
                vector2.set(point2.p1);
                vector22.set(point2.p2);
            } else if (d2 < 0.0) {
                vector2.set(point.p1);
                vector22.set(point.p2);
            } else {
                vector2.x = point.p1.x * d3 + point2.p1.x * d2;
                vector2.y = point.p1.y * d3 + point2.p1.y * d2;
                vector22.x = point.p2.x * d3 + point2.p2.x * d2;
                vector22.y = point.p2.y * d3 + point2.p2.y * d2;
            }
        }
        separation.point1 = vector2;
        separation.point2 = vector22;
    }

    protected boolean containsOrigin(Vector2 vector2, Vector2 vector22, Vector2 vector23) {
        double d = vector2.cross(vector22);
        double d2 = vector22.cross(vector23);
        double d3 = vector23.cross(vector2);
        return d * d2 > 0.0 && d * d3 > 0.0;
    }

    @Override
    public boolean raycast(Ray ray, double d, Convex convex, Transform transform, Raycast raycast) {
        Vector2 vector2;
        if (convex instanceof Circle) {
            return CircleDetector.raycast(ray, d, (Circle)convex, transform, raycast);
        }
        if (convex instanceof Segment) {
            return SegmentDetector.raycast(ray, d, (Segment)convex, transform, raycast);
        }
        double d2 = 0.0;
        boolean bl = d > 0.0;
        Vector2 vector22 = null;
        Vector2 vector23 = null;
        Vector2 vector24 = vector2 = ray.getStart();
        Vector2 vector25 = ray.getDirectionVector();
        Vector2 vector26 = new Vector2();
        if (convex.contains(vector2, transform)) {
            return false;
        }
        Vector2 vector27 = transform.getTransformed(convex.getCenter());
        Vector2 vector28 = vector27.to(vector24);
        double d3 = Double.MAX_VALUE;
        int n = 0;
        while (d3 > this.distanceEpsilon) {
            Vector2 vector29 = convex.getFarthestPoint(vector28, transform);
            Vector2 vector210 = vector29.to(vector24);
            double d4 = vector28.dot(vector210);
            if (d4 > 0.0) {
                double d5 = vector28.dot(vector25);
                if (d5 >= 0.0) {
                    return false;
                }
                d2 -= d4 / d5;
                if (bl && d2 > d) {
                    return false;
                }
                vector24 = vector25.product(d2).add(vector2);
                vector26.set(vector28);
            }
            if (vector22 != null) {
                Vector2 vector211;
                if (vector23 != null) {
                    Vector2 vector212 = Segment.getPointOnSegmentClosestToPoint(vector24, vector22, vector29);
                    vector211 = Segment.getPointOnSegmentClosestToPoint(vector24, vector29, vector23);
                    if (vector212.distanceSquared(vector24) < vector211.distanceSquared(vector24)) {
                        vector23.set(vector29);
                        d3 = vector212.distanceSquared(vector24);
                    } else {
                        vector22.set(vector29);
                        d3 = vector211.distanceSquared(vector24);
                    }
                    Vector2 vector213 = vector22.to(vector23);
                    Vector2 vector214 = vector22.to(vector24);
                    vector28 = Vector2.tripleProduct(vector213, vector214, vector213);
                } else {
                    vector23 = vector29;
                    Vector2 vector215 = vector22.to(vector23);
                    vector211 = vector22.to(vector24);
                    vector28 = Vector2.tripleProduct(vector215, vector211, vector215);
                }
            } else {
                vector22 = vector29;
                vector28.negate();
            }
            if (n == this.maxIterations) {
                return false;
            }
            ++n;
        }
        raycast.point = vector24;
        raycast.normal = vector26;
        vector26.normalize();
        raycast.distance = d2;
        return true;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int n) {
        if (n < 5) {
            throw new IllegalArgumentException(Messages.getString("collision.narrowphase.gjk.invalidMaximumIterations"));
        }
        this.maxIterations = n;
    }

    public double getDistanceEpsilon() {
        return this.distanceEpsilon;
    }

    public void setDistanceEpsilon(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("collision.narrowphase.gjk.invalidDistanceEpsilon"));
        }
        this.distanceEpsilon = d;
    }

    public MinkowskiPenetrationSolver getMinkowskiPenetrationSolver() {
        return this.minkowskiPenetrationSolver;
    }

    public void setMinkowskiPenetrationSolver(MinkowskiPenetrationSolver minkowskiPenetrationSolver) {
        if (minkowskiPenetrationSolver == null) {
            throw new NullPointerException(Messages.getString("collision.narrowphase.gjk.nullMinkowskiPenetrationSolver"));
        }
        this.minkowskiPenetrationSolver = minkowskiPenetrationSolver;
    }
}

