/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

import java.util.ArrayList;
import java.util.List;
import org.dyn4j.Epsilon;
import org.dyn4j.collision.Collisions;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Capacity;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.World;
import org.dyn4j.dynamics.contact.ContactConstraint;
import org.dyn4j.dynamics.contact.ContactConstraintSolver;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Island {
    protected World world;
    protected ContactConstraintSolver contactConstraintSolver;
    protected List<Body> bodies;
    protected List<ContactConstraint> contactConstraints;
    protected List<Joint> joints;

    public Island(World world) {
        this(world, Capacity.DEFAULT_CAPACITY);
    }

    public Island(World world, Capacity capacity) {
        if (world == null) {
            throw new NullPointerException(Messages.getString("dynamics.nullWorld"));
        }
        if (capacity == null) {
            throw new NullPointerException(Messages.getString("dynamics.nullCapacity"));
        }
        this.world = world;
        this.bodies = new ArrayList<Body>(capacity.getBodyCount());
        this.joints = new ArrayList<Joint>(capacity.getJointCount());
        this.contactConstraintSolver = new ContactConstraintSolver(world);
        int n = Collisions.getEstimatedCollisionPairs(capacity.getBodyCount());
        this.contactConstraints = new ArrayList<ContactConstraint>(n);
    }

    public void clear() {
        this.bodies.clear();
        this.joints.clear();
        this.contactConstraints.clear();
    }

    public void add(Body body) {
        this.bodies.add(body);
    }

    public void add(ContactConstraint contactConstraint) {
        Body body = contactConstraint.getBody1();
        Body body2 = contactConstraint.getBody2();
        if (body.isStatic() || body2.isStatic()) {
            this.contactConstraints.add(0, contactConstraint);
        } else {
            this.contactConstraints.add(contactConstraint);
        }
    }

    public void add(Joint joint) {
        this.joints.add(joint);
    }

    public void solve() {
        int n;
        double d;
        Object object;
        int n2;
        Vector2 vector2 = this.world.gravity;
        Step step = this.world.step;
        Settings settings = this.world.settings;
        int n3 = settings.getVelocityConstraintSolverIterations();
        int n4 = settings.getPositionConstraintSolverIterations();
        double d2 = settings.getSleepAngularVelocitySquared();
        double d3 = settings.getSleepLinearVelocitySquared();
        double d4 = settings.getSleepTime();
        int n5 = this.bodies.size();
        int n6 = this.joints.size();
        double d5 = step.dt;
        for (n2 = 0; n2 < n5; ++n2) {
            object = this.bodies.get(n2);
            if (!((Body)object).isDynamic()) continue;
            ((Body)object).accumulate(d5);
            double d6 = ((Body)object).mass.getInverseMass();
            double d7 = ((Body)object).mass.getInverseInertia();
            if (d6 > Epsilon.E) {
                ((Body)object).velocity.x += (((Body)object).force.x * d6 + vector2.x * ((Body)object).gravityScale) * d5;
                ((Body)object).velocity.y += (((Body)object).force.y * d6 + vector2.y * ((Body)object).gravityScale) * d5;
            }
            if (d7 > Epsilon.E) {
                ((Body)object).angularVelocity += d5 * d7 * ((Body)object).torque;
            }
            double d8 = 1.0 - d5 * ((Body)object).linearDamping;
            d = 1.0 - d5 * ((Body)object).angularDamping;
            d8 = Interval.clamp(d8, 0.0, 1.0);
            d = Interval.clamp(d, 0.0, 1.0);
            ((Body)object).velocity.x *= d8;
            ((Body)object).velocity.y *= d8;
            ((Body)object).angularVelocity *= d;
        }
        this.contactConstraintSolver.setup(this.contactConstraints);
        this.contactConstraintSolver.initializeConstraints(step);
        for (n2 = 0; n2 < n6; ++n2) {
            object = this.joints.get(n2);
            ((Joint)object).initializeConstraints();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i = 0; i < n6; ++i) {
                Joint joint = this.joints.get(i);
                joint.solveVelocityConstraints();
            }
            this.contactConstraintSolver.solveVelocityContraints();
        }
        double d9 = settings.getMaximumTranslation();
        double d10 = settings.getMaximumRotation();
        d = settings.getMaximumTranslationSquared();
        double d11 = settings.getMaximumRotationSquared();
        for (n = 0; n < n5; ++n) {
            double d12;
            Body body = this.bodies.get(n);
            if (body.isStatic()) continue;
            Vector2 vector22 = body.velocity.product(d5);
            double d13 = body.angularVelocity * d5;
            if (vector22.getMagnitudeSquared() > d) {
                d12 = d9 / vector22.getMagnitude();
                body.velocity.multiply(d12);
            }
            if (d13 * d13 > d11) {
                d12 = d10 / Math.abs(d13);
                body.angularVelocity *= d12;
            }
            body.translate(body.velocity.x * d5, body.velocity.y * d5);
            body.rotateAboutCenter(body.angularVelocity * d5);
        }
        n = 0;
        for (int i = 0; i < n4; ++i) {
            boolean bl = this.contactConstraintSolver.solvePositionContraints();
            boolean bl2 = true;
            for (int j = 0; j < n6; ++j) {
                Joint joint = this.joints.get(j);
                boolean bl3 = joint.solvePositionConstraints();
                bl2 = bl2 && bl3;
            }
            if (!bl || !bl2) continue;
            n = 1;
            break;
        }
        if (settings.isAutoSleepingEnabled()) {
            int n7;
            double d14 = Double.MAX_VALUE;
            for (n7 = 0; n7 < n5; ++n7) {
                Body body = this.bodies.get(n7);
                if (body.isStatic()) continue;
                if (body.isAutoSleepingEnabled()) {
                    if (body.velocity.dot(body.velocity) > d3 || body.angularVelocity * body.angularVelocity > d2) {
                        body.sleepTime = 0.0;
                        d14 = 0.0;
                        continue;
                    }
                    body.sleepTime += step.dt;
                    d14 = Math.min(d14, body.getSleepTime());
                    continue;
                }
                body.sleepTime = 0.0;
                d14 = 0.0;
            }
            if (d14 >= d4 && n != 0) {
                for (n7 = 0; n7 < n5; ++n7) {
                    Body body = this.bodies.get(n7);
                    body.setAsleep(true);
                }
            }
        }
    }
}

