/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

public class Step {
    protected double dt0;
    protected double invdt0;
    protected double dt;
    protected double invdt;
    protected double dtRatio;

    public Step(double d) {
        this.dt = d;
        this.invdt = 1.0 / d;
        this.dt0 = this.dt;
        this.invdt0 = this.invdt;
        this.dtRatio = 1.0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Step[DeltaTime=").append(this.dt).append("|InverseDeltaTime=").append(this.invdt).append("|PreviousDeltaTime=").append(this.dt0).append("|PreviousInverseDeltaTime=").append(this.invdt0).append("|DeltaTimeRatio=").append(this.dtRatio).append("]");
        return stringBuilder.toString();
    }

    protected void update(double d) {
        this.dt0 = this.dt;
        this.invdt0 = this.invdt;
        this.dt = d;
        this.invdt = 1.0 / d;
        this.dtRatio = this.invdt0 * d;
    }

    public double getDeltaTime() {
        return this.dt;
    }

    public double getInverseDeltaTime() {
        return this.invdt;
    }

    public double getDeltaTimeRatio() {
        return this.dtRatio;
    }

    public double getPrevousDeltaTime() {
        return this.dt0;
    }

    public double getPreviousInverseDeltaTime() {
        return this.invdt0;
    }
}

