/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dyn4j.Listener;
import org.dyn4j.collision.Bounds;
import org.dyn4j.collision.BoundsListener;
import org.dyn4j.collision.Collidable;
import org.dyn4j.collision.Filter;
import org.dyn4j.collision.broadphase.BroadphaseDetector;
import org.dyn4j.collision.broadphase.BroadphasePair;
import org.dyn4j.collision.broadphase.DynamicAABBTree;
import org.dyn4j.collision.continuous.ConservativeAdvancement;
import org.dyn4j.collision.continuous.TimeOfImpact;
import org.dyn4j.collision.continuous.TimeOfImpactDetector;
import org.dyn4j.collision.manifold.ClippingManifoldSolver;
import org.dyn4j.collision.manifold.Manifold;
import org.dyn4j.collision.manifold.ManifoldSolver;
import org.dyn4j.collision.narrowphase.Gjk;
import org.dyn4j.collision.narrowphase.NarrowphaseDetector;
import org.dyn4j.collision.narrowphase.Penetration;
import org.dyn4j.collision.narrowphase.Raycast;
import org.dyn4j.collision.narrowphase.RaycastDetector;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.BodyFixture;
import org.dyn4j.dynamics.Capacity;
import org.dyn4j.dynamics.CoefficientMixer;
import org.dyn4j.dynamics.CollisionListener;
import org.dyn4j.dynamics.Constraint;
import org.dyn4j.dynamics.ConvexCastListener;
import org.dyn4j.dynamics.ConvexCastResult;
import org.dyn4j.dynamics.DestructionListener;
import org.dyn4j.dynamics.DetectListener;
import org.dyn4j.dynamics.DetectResult;
import org.dyn4j.dynamics.Island;
import org.dyn4j.dynamics.RaycastListener;
import org.dyn4j.dynamics.RaycastResult;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.StepListener;
import org.dyn4j.dynamics.TimeOfImpactListener;
import org.dyn4j.dynamics.contact.Contact;
import org.dyn4j.dynamics.contact.ContactConstraint;
import org.dyn4j.dynamics.contact.ContactEdge;
import org.dyn4j.dynamics.contact.ContactManager;
import org.dyn4j.dynamics.contact.ContactPoint;
import org.dyn4j.dynamics.contact.ContactPointId;
import org.dyn4j.dynamics.contact.TimeOfImpactSolver;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.dynamics.joint.JointEdge;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Ray;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class World {
    public static final Vector2 EARTH_GRAVITY = new Vector2(0.0, -9.8);
    public static final Vector2 ZERO_GRAVITY = new Vector2(0.0, 0.0);
    protected Settings settings;
    protected Step step;
    protected Vector2 gravity;
    protected Bounds bounds;
    protected BroadphaseDetector<Body> broadphaseDetector;
    protected NarrowphaseDetector narrowphaseDetector;
    protected ManifoldSolver manifoldSolver;
    protected TimeOfImpactDetector timeOfImpactDetector;
    protected RaycastDetector raycastDetector;
    protected ContactManager contactManager;
    protected CoefficientMixer coefficientMixer;
    protected TimeOfImpactSolver timeOfImpactSolver;
    protected List<Listener> listeners;
    protected List<Body> bodies;
    protected List<Joint> joints;
    protected Object userData;
    protected Island island;
    protected double time;
    protected boolean updateRequired;

    public World() {
        this(Capacity.DEFAULT_CAPACITY, null);
    }

    public World(Capacity capacity) {
        this(capacity, null);
    }

    public World(Bounds bounds) {
        this(Capacity.DEFAULT_CAPACITY, bounds);
    }

    public World(Capacity capacity, Bounds bounds) {
        if (capacity == null) {
            throw new NullPointerException(Messages.getString("dynamics.nullCapacity"));
        }
        this.settings = new Settings();
        this.step = new Step(this.settings.getStepFrequency());
        this.gravity = EARTH_GRAVITY;
        this.bounds = bounds;
        this.broadphaseDetector = new DynamicAABBTree<Body>(capacity.getBodyCount());
        this.narrowphaseDetector = new Gjk();
        this.manifoldSolver = new ClippingManifoldSolver();
        this.timeOfImpactDetector = new ConservativeAdvancement();
        this.raycastDetector = new Gjk();
        this.coefficientMixer = CoefficientMixer.DEFAULT_MIXER;
        this.bodies = new ArrayList<Body>(capacity.getBodyCount());
        this.joints = new ArrayList<Joint>(capacity.getJointCount());
        this.listeners = new ArrayList<Listener>(capacity.getListenerCount());
        this.timeOfImpactSolver = new TimeOfImpactSolver(this);
        this.contactManager = new ContactManager(this, capacity);
        this.island = new Island(this, capacity);
        this.time = 0.0;
        this.updateRequired = true;
    }

    public boolean update(double d) {
        if (d <= 0.0) {
            return false;
        }
        this.time += d;
        double d2 = this.settings.getStepFrequency();
        if (this.time >= d2) {
            this.step.update(d2);
            this.time -= d2;
            this.step();
            return true;
        }
        return false;
    }

    public void updatev(double d) {
        if (d <= 0.0) {
            return;
        }
        this.step.update(d);
        this.step();
    }

    public void step(int n) {
        double d = this.settings.getStepFrequency();
        this.step(n, d);
    }

    public void step(int n, double d) {
        if (n <= 0) {
            return;
        }
        if (d <= 0.0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.step.update(d);
            this.step();
        }
    }

    protected void step() {
        int n;
        List<StepListener> list = this.getListeners(StepListener.class);
        for (StepListener stepListener : list) {
            stepListener.begin(this.step, this);
        }
        if (this.updateRequired) {
            this.detect();
            for (StepListener stepListener : list) {
                stepListener.updatePerformed(this.step, this);
            }
            this.updateRequired = false;
        }
        this.contactManager.preSolveNotify();
        Settings.ContinuousDetectionMode continuousDetectionMode = this.settings.getContinuousDetectionMode();
        int n2 = this.bodies.size();
        for (n = 0; n < n2; ++n) {
            Body body = this.bodies.get(n);
            body.setOnIsland(false);
            if (continuousDetectionMode == Settings.ContinuousDetectionMode.NONE) continue;
            body.transform0.set(body.transform);
        }
        n = this.joints.size();
        for (int i = 0; i < n; ++i) {
            Joint joint = this.joints.get(i);
            joint.setOnIsland(false);
        }
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>(n2);
        for (int i = 0; i < n2; ++i) {
            Body object = this.bodies.get(i);
            if (object.isOnIsland() || object.isAsleep() || !object.isActive() || object.isStatic()) continue;
            Island island = this.island;
            island.clear();
            arrayDeque.clear();
            arrayDeque.push(object);
            while (arrayDeque.size() > 0) {
                Object object2;
                Object object3;
                int n3;
                Body body = (Body)arrayDeque.pop();
                island.add(body);
                body.setOnIsland(true);
                body.setAsleep(false);
                if (body.isStatic()) continue;
                int n4 = body.contacts.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    ContactEdge contactEdge = body.contacts.get(n3);
                    object3 = contactEdge.getContactConstraint();
                    if (((ContactConstraint)object3).isSensor()) continue;
                    object2 = contactEdge.getOther();
                    if (((Constraint)object3).isOnIsland()) continue;
                    island.add((ContactConstraint)object3);
                    ((Constraint)object3).setOnIsland(true);
                    if (((Body)object2).isOnIsland()) continue;
                    arrayDeque.push(object2);
                    ((Body)object2).setOnIsland(true);
                }
                n3 = body.joints.size();
                for (int j = 0; j < n3; ++j) {
                    object3 = body.joints.get(j);
                    object2 = ((JointEdge)object3).getJoint();
                    if (!((Joint)object2).isActive()) continue;
                    Body body2 = ((JointEdge)object3).getOther();
                    if (((Constraint)object2).isOnIsland() || !body2.isActive()) continue;
                    island.add((Joint)object2);
                    ((Constraint)object2).setOnIsland(true);
                    if (body2.isOnIsland()) continue;
                    arrayDeque.push(body2);
                    body2.setOnIsland(true);
                }
            }
            island.solve();
            for (int j = 0; j < n2; ++j) {
                Body body = this.bodies.get(j);
                if (!body.isStatic()) continue;
                body.setOnIsland(false);
            }
        }
        this.contactManager.postSolveNotify();
        if (continuousDetectionMode != Settings.ContinuousDetectionMode.NONE) {
            this.solveTOI(continuousDetectionMode);
        }
        this.detect();
        this.updateRequired = false;
        for (StepListener stepListener : list) {
            stepListener.end(this.step, this);
        }
    }

    protected void detect() {
        List<BoundsListener> list = this.getListeners(BoundsListener.class);
        List<CollisionListener> list2 = this.getListeners(CollisionListener.class);
        this.contactManager.clear();
        int n = this.bodies.size();
        for (int i = 0; i < n; ++i) {
            Body body = this.bodies.get(i);
            if (!body.isActive()) continue;
            body.contacts.clear();
            if (this.bounds != null && this.bounds.isOutside(body)) {
                body.setActive(false);
                for (BoundsListener object2 : list) {
                    object2.outside(body);
                }
            }
            this.broadphaseDetector.update(body);
        }
        if (n > 0) {
            List<BroadphasePair<Body>> list3 = this.broadphaseDetector.detect();
            int n2 = list3.size();
            for (int i = 0; i < n2; ++i) {
                BroadphasePair<Body> broadphasePair = list3.get(i);
                Body body = broadphasePair.getA();
                Body body2 = broadphasePair.getB();
                if (!body.isActive() || !body2.isActive() || !body.isDynamic() && !body2.isDynamic() || body.isConnected(body2, false)) continue;
                boolean bl = true;
                for (CollisionListener collisionListener : list2) {
                    if (collisionListener.collision(body, body2)) continue;
                    bl = false;
                }
                if (!bl) continue;
                Transform transform = body.transform;
                Transform transform2 = body2.transform;
                int n3 = body.getFixtureCount();
                int n4 = body2.getFixtureCount();
                for (int j = 0; j < n3; ++j) {
                    BodyFixture bodyFixture = body.getFixture(j);
                    Filter filter = bodyFixture.getFilter();
                    for (int k = 0; k < n4; ++k) {
                        Object object4;
                        Object object2;
                        Penetration penetration;
                        BodyFixture bodyFixture2 = body2.getFixture(k);
                        Filter filter2 = bodyFixture2.getFilter();
                        if (!filter.isAllowed(filter2)) continue;
                        Convex convex = bodyFixture2.getShape();
                        Convex convex2 = bodyFixture.getShape();
                        if (!this.narrowphaseDetector.detect(convex2, transform, convex, transform2, penetration = new Penetration()) || penetration.getDepth() == 0.0) continue;
                        bl = true;
                        Object object3 = list2.iterator();
                        while (object3.hasNext()) {
                            object2 = object3.next();
                            if (object2.collision(body, bodyFixture, body2, bodyFixture2, penetration)) continue;
                            bl = false;
                        }
                        if (!bl || !this.manifoldSolver.getManifold(penetration, convex2, transform, convex, transform2, (Manifold)(object3 = new Manifold())) || ((Manifold)object3).getPoints().size() == 0) continue;
                        bl = true;
                        for (CollisionListener collisionListener : list2) {
                            if (collisionListener.collision(body, bodyFixture, body2, bodyFixture2, (Manifold)object3)) continue;
                            bl = false;
                        }
                        if (!bl) continue;
                        object2 = new ContactConstraint(body, bodyFixture, body2, bodyFixture2, (Manifold)object3, this);
                        bl = true;
                        for (Object object4 : list2) {
                            if (object4.collision((ContactConstraint)object2)) continue;
                            bl = false;
                        }
                        if (!bl) continue;
                        ContactEdge contactEdge = new ContactEdge(body2, (ContactConstraint)object2);
                        object4 = new ContactEdge(body, (ContactConstraint)object2);
                        body.contacts.add(contactEdge);
                        body2.contacts.add((ContactEdge)object4);
                        this.contactManager.add((ContactConstraint)object2);
                    }
                }
            }
        }
        this.contactManager.updateContacts();
    }

    protected void solveTOI(Settings.ContinuousDetectionMode continuousDetectionMode) {
        List<TimeOfImpactListener> list = this.getListeners(TimeOfImpactListener.class);
        int n = this.bodies.size();
        boolean bl = continuousDetectionMode == Settings.ContinuousDetectionMode.BULLETS_ONLY;
        for (int i = 0; i < n; ++i) {
            Body body = this.bodies.get(i);
            if (bl && !body.isBullet() || body.isKinematic() || body.isStatic() || !body.isOnIsland() || body.isAsleep()) continue;
            this.solveTOI(body, list);
        }
    }

    protected void solveTOI(Body body, List<TimeOfImpactListener> list) {
        int n = this.bodies.size();
        AABB aABB = body.createSweptAABB();
        boolean bl = body.isBullet();
        double d = 0.0;
        double d2 = 1.0;
        TimeOfImpact timeOfImpact = null;
        Body body2 = null;
        for (int i = 0; i < n; ++i) {
            AABB aABB2;
            Body body3 = this.bodies.get(i);
            if (body == body3 || !body3.isActive() || body3.isDynamic() && !bl || body.isConnected(body3, false) || body.isInContact(body3) || !aABB.overlaps(aABB2 = body3.createSweptAABB())) continue;
            TimeOfImpact timeOfImpact2 = new TimeOfImpact();
            int n2 = body.getFixtureCount();
            int n3 = body3.getFixtureCount();
            double d3 = this.step.getDeltaTime();
            Vector2 vector2 = body.getLinearVelocity().product(d3);
            Vector2 vector22 = body3.getLinearVelocity().product(d3);
            double d4 = body.getAngularVelocity() * d3;
            double d5 = body3.getAngularVelocity() * d3;
            Transform transform = body.getInitialTransform();
            Transform transform2 = body3.getInitialTransform();
            for (int j = 0; j < n2; ++j) {
                BodyFixture bodyFixture = body.getFixture(j);
                if (bodyFixture.isSensor()) continue;
                for (int k = 0; k < n3; ++k) {
                    double d6;
                    Convex convex;
                    Convex convex2;
                    Filter filter;
                    Filter filter2;
                    BodyFixture bodyFixture2 = body3.getFixture(k);
                    if (bodyFixture2.isSensor() || !(filter2 = bodyFixture.getFilter()).isAllowed(filter = bodyFixture2.getFilter()) || !this.timeOfImpactDetector.getTimeOfImpact(convex2 = bodyFixture.getShape(), transform, vector2, d4, convex = bodyFixture2.getShape(), transform2, vector22, d5, d, d2, timeOfImpact2) || !((d6 = timeOfImpact2.getTime()) < d2)) continue;
                    boolean bl2 = true;
                    for (TimeOfImpactListener timeOfImpactListener : list) {
                        if (timeOfImpactListener.collision(body, bodyFixture, body3, bodyFixture2, timeOfImpact2)) continue;
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    d2 = d6;
                    timeOfImpact = timeOfImpact2;
                    body2 = body3;
                }
            }
        }
        if (timeOfImpact != null) {
            double d7 = timeOfImpact.getTime();
            body.transform0.lerp(body.transform, d7, body.transform);
            if (body2.isDynamic()) {
                body2.transform0.lerp(body2.transform, d7, body2.transform);
            }
            this.timeOfImpactSolver.solve(body, body2, timeOfImpact);
        }
    }

    public boolean raycast(Vector2 vector2, Vector2 vector22, boolean bl, boolean bl2, List<RaycastResult> list) {
        return this.raycast(vector2, vector22, bl, true, bl2, list);
    }

    public boolean raycast(Vector2 vector2, Vector2 vector22, boolean bl, boolean bl2, boolean bl3, List<RaycastResult> list) {
        return this.raycast(vector2, vector22, bl, bl2, bl3, list);
    }

    public boolean raycast(Vector2 vector2, Vector2 vector22, Filter filter, boolean bl, boolean bl2, boolean bl3, List<RaycastResult> list) {
        Vector2 vector23 = vector2.to(vector22);
        double d = vector23.normalize();
        Ray ray = new Ray(vector2, vector23);
        return this.raycast(ray, d, filter, bl, bl2, bl3, list);
    }

    public boolean raycast(Ray ray, double d, boolean bl, boolean bl2, List<RaycastResult> list) {
        return this.raycast(ray, d, bl, true, bl2, list);
    }

    public boolean raycast(Ray ray, double d, boolean bl, boolean bl2, boolean bl3, List<RaycastResult> list) {
        return this.raycast(ray, d, null, bl, bl2, bl3, list);
    }

    public boolean raycast(Ray ray, double d, Filter filter, boolean bl, boolean bl2, boolean bl3, List<RaycastResult> list) {
        double d2 = 0.0;
        if (d > 0.0) {
            d2 = d;
        }
        RaycastResult raycastResult = new RaycastResult();
        List<Body> list2 = this.broadphaseDetector.raycast(ray, d);
        int n = list2.size();
        boolean bl4 = false;
        for (int i = 0; i < n; ++i) {
            Body body = list2.get(i);
            if (bl2 && !body.isActive() || !this.raycast(ray, body, d2, filter, bl, raycastResult)) continue;
            if (!bl3) {
                d2 = raycastResult.raycast.getDistance();
                if (list.size() != 0) continue;
                list.add(raycastResult);
                bl4 = true;
                continue;
            }
            list.add(raycastResult);
            bl4 = true;
            raycastResult = new RaycastResult();
        }
        return bl4;
    }

    public boolean raycast(Vector2 vector2, Vector2 vector22, Body body, boolean bl, RaycastResult raycastResult) {
        return this.raycast(vector2, vector22, body, null, bl, raycastResult);
    }

    public boolean raycast(Vector2 vector2, Vector2 vector22, Body body, Filter filter, boolean bl, RaycastResult raycastResult) {
        Vector2 vector23 = vector2.to(vector22);
        double d = vector23.normalize();
        Ray ray = new Ray(vector2, vector23);
        return this.raycast(ray, body, d, filter, bl, raycastResult);
    }

    public boolean raycast(Ray ray, Body body, double d, boolean bl, RaycastResult raycastResult) {
        return this.raycast(ray, body, d, null, bl, raycastResult);
    }

    public boolean raycast(Ray ray, Body body, double d, Filter filter, boolean bl, RaycastResult raycastResult) {
        List<RaycastListener> list = this.getListeners(RaycastListener.class);
        boolean bl2 = true;
        for (RaycastListener object2 : list) {
            if (object2.allow(ray, body)) continue;
            bl2 = false;
        }
        if (!bl2) {
            return false;
        }
        int n = body.getFixtureCount();
        Transform transform = body.getTransform();
        double d2 = 0.0;
        if (d > 0.0) {
            d2 = d;
        }
        Raycast raycast = new Raycast();
        boolean bl3 = false;
        for (int i = 0; i < n; ++i) {
            BodyFixture bodyFixture = body.getFixture(i);
            if (bl && bodyFixture.isSensor() || filter != null && !filter.isAllowed(bodyFixture.getFilter())) continue;
            bl2 = true;
            Object object = list.iterator();
            while (object.hasNext()) {
                RaycastListener raycastListener = object.next();
                if (raycastListener.allow(ray, body, bodyFixture)) continue;
                bl2 = false;
            }
            if (!bl2 || !this.raycastDetector.raycast(ray, d2, (Convex)(object = bodyFixture.getShape()), transform, raycast)) continue;
            bl2 = true;
            for (RaycastListener raycastListener : list) {
                if (raycastListener.allow(ray, body, bodyFixture, raycast)) continue;
                bl2 = false;
            }
            if (!bl2) continue;
            d2 = raycast.getDistance();
            raycastResult.fixture = bodyFixture;
            bl3 = true;
        }
        if (bl3) {
            raycastResult.body = body;
            raycastResult.raycast = raycast;
        }
        return bl3;
    }

    public boolean convexCast(Convex convex, Transform transform, Vector2 vector2, boolean bl, boolean bl2, List<ConvexCastResult> list) {
        return this.convexCast(convex, transform, vector2, 0.0, null, bl, true, bl2, list);
    }

    public boolean convexCast(Convex convex, Transform transform, Vector2 vector2, boolean bl, boolean bl2, boolean bl3, List<ConvexCastResult> list) {
        return this.convexCast(convex, transform, vector2, 0.0, null, bl, bl2, bl3, list);
    }

    public boolean convexCast(Convex convex, Transform transform, Vector2 vector2, double d, boolean bl, boolean bl2, List<ConvexCastResult> list) {
        return this.convexCast(convex, transform, vector2, d, null, bl, true, bl2, list);
    }

    public boolean convexCast(Convex convex, Transform transform, Vector2 vector2, double d, boolean bl, boolean bl2, boolean bl3, List<ConvexCastResult> list) {
        return this.convexCast(convex, transform, vector2, d, null, bl, bl2, bl3, list);
    }

    public boolean convexCast(Convex convex, Transform transform, Vector2 vector2, double d, Filter filter, boolean bl, boolean bl2, boolean bl3, List<ConvexCastResult> list) {
        List<ConvexCastListener> list2 = this.getListeners(ConvexCastListener.class);
        double d2 = convex.getRadius();
        Vector2 vector22 = transform.getTransformed(convex.getCenter());
        AABB aABB = new AABB(vector22, d2);
        Transform transform2 = transform.lerped(vector2, d, 1.0);
        Vector2 vector23 = transform2.getTransformed(convex.getCenter());
        AABB aABB2 = new AABB(vector23, d2);
        AABB aABB3 = aABB.getUnion(aABB2);
        ConvexCastResult convexCastResult = null;
        Vector2 vector24 = new Vector2();
        double d3 = 1.0;
        boolean bl4 = false;
        List<Body> list3 = this.broadphaseDetector.detect(aABB3);
        for (Body body : list3) {
            if (bl2 && !body.isActive()) continue;
            boolean bl5 = true;
            for (ConvexCastListener convexCastListener : list2) {
                if (convexCastListener.allow(convex, body)) continue;
                bl5 = false;
            }
            if (!bl5) continue;
            double d4 = d3;
            Object object = null;
            BodyFixture bodyFixture = null;
            int n = body.getFixtureCount();
            Transform transform3 = body.getTransform();
            for (int i = 0; i < n; ++i) {
                Object object2;
                BodyFixture bodyFixture2 = body.getFixture(i);
                if (bl && bodyFixture2.isSensor() || filter != null && !filter.isAllowed(bodyFixture2.getFilter())) continue;
                bl5 = true;
                Object object3 = list2.iterator();
                while (object3.hasNext()) {
                    object2 = object3.next();
                    if (object2.allow(convex, body, bodyFixture2)) continue;
                    bl5 = false;
                }
                if (!bl5 || !this.timeOfImpactDetector.getTimeOfImpact(convex, transform, vector2, d, (Convex)(object3 = bodyFixture2.getShape()), transform3, vector24, 0.0, 0.0, d4, (TimeOfImpact)(object2 = new TimeOfImpact()))) continue;
                bl5 = true;
                for (ConvexCastListener convexCastListener : list2) {
                    if (convexCastListener.allow(convex, body, bodyFixture2, (TimeOfImpact)object2)) continue;
                    bl5 = false;
                }
                if (!bl5 || object != null && !(((TimeOfImpact)object2).getTime() < ((TimeOfImpact)object).getTime())) continue;
                d4 = ((TimeOfImpact)object2).getTime();
                object = object2;
                bodyFixture = bodyFixture2;
            }
            if (object == null) continue;
            if (!bl3) {
                d3 = ((TimeOfImpact)object).getTime();
                if (convexCastResult == null) {
                    convexCastResult = new ConvexCastResult();
                    convexCastResult.timeOfImpact = object;
                    convexCastResult.fixture = bodyFixture;
                    convexCastResult.body = body;
                } else if (((TimeOfImpact)object).getTime() < convexCastResult.timeOfImpact.getTime()) {
                    convexCastResult.timeOfImpact = object;
                    convexCastResult.fixture = bodyFixture;
                    convexCastResult.body = body;
                }
            } else {
                ConvexCastResult convexCastResult2 = new ConvexCastResult();
                convexCastResult2.timeOfImpact = object;
                convexCastResult2.fixture = bodyFixture;
                convexCastResult2.body = body;
                list.add(convexCastResult2);
            }
            bl4 = true;
        }
        if (convexCastResult != null) {
            list.add(convexCastResult);
        }
        return bl4;
    }

    public boolean convexCast(Convex convex, Transform transform, Vector2 vector2, Body body, boolean bl, ConvexCastResult convexCastResult) {
        return this.convexCast(convex, transform, vector2, 0.0, body, null, bl, convexCastResult);
    }

    public boolean convexCast(Convex convex, Transform transform, Vector2 vector2, double d, Body body, boolean bl, ConvexCastResult convexCastResult) {
        return this.convexCast(convex, transform, vector2, d, body, null, bl, convexCastResult);
    }

    public boolean convexCast(Convex convex, Transform transform, Vector2 vector2, double d, Body body, Filter filter, boolean bl, ConvexCastResult convexCastResult) {
        List<ConvexCastListener> list = this.getListeners(ConvexCastListener.class);
        boolean bl2 = true;
        for (ConvexCastListener object2 : list) {
            if (object2.allow(convex, body)) continue;
            bl2 = false;
        }
        if (!bl2) {
            return false;
        }
        boolean bl3 = false;
        Vector2 vector22 = new Vector2();
        double d2 = 1.0;
        int n = body.getFixtureCount();
        Transform transform2 = body.getTransform();
        for (int i = 0; i < n; ++i) {
            TimeOfImpact timeOfImpact;
            BodyFixture bodyFixture = body.getFixture(i);
            if (bl && bodyFixture.isSensor() || filter != null && !filter.isAllowed(bodyFixture.getFilter())) continue;
            bl2 = true;
            for (ConvexCastListener convexCastListener : list) {
                if (convexCastListener.allow(convex, body, bodyFixture)) continue;
                bl2 = false;
            }
            if (!bl2) {
                return false;
            }
            Convex convex2 = bodyFixture.getShape();
            if (!this.timeOfImpactDetector.getTimeOfImpact(convex, transform, vector2, d, convex2, transform2, vector22, 0.0, 0.0, d2, timeOfImpact = new TimeOfImpact())) continue;
            bl2 = true;
            for (ConvexCastListener convexCastListener : list) {
                if (convexCastListener.allow(convex, body, bodyFixture, timeOfImpact)) continue;
                bl2 = false;
            }
            if (!bl2) continue;
            d2 = timeOfImpact.getTime();
            convexCastResult.fixture = bodyFixture;
            convexCastResult.timeOfImpact = timeOfImpact;
            convexCastResult.body = body;
            bl3 = true;
        }
        return bl3;
    }

    public boolean detect(AABB aABB, List<Body> list) {
        return this.detect(aABB, true, list);
    }

    public boolean detect(AABB aABB, boolean bl, List<Body> list) {
        List<DetectListener> list2 = this.getListeners(DetectListener.class);
        List<Body> list3 = this.broadphaseDetector.detect(aABB);
        boolean bl2 = false;
        int n = list3.size();
        for (int i = 0; i < n; ++i) {
            Body body = list3.get(i);
            if (bl && !body.isActive()) continue;
            boolean bl3 = true;
            for (DetectListener detectListener : list2) {
                if (detectListener.allow(aABB, body)) continue;
                bl3 = false;
            }
            if (!bl3) continue;
            list.add(body);
            bl2 = true;
        }
        return bl2;
    }

    public boolean detect(AABB aABB, boolean bl, boolean bl2, List<DetectResult> list) {
        return this.detect(aABB, null, bl, bl2, list);
    }

    public boolean detect(AABB aABB, Filter filter, boolean bl, boolean bl2, List<DetectResult> list) {
        List<DetectListener> list2 = this.getListeners(DetectListener.class);
        List<Body> list3 = this.broadphaseDetector.detect(aABB);
        boolean bl3 = false;
        int n = list3.size();
        for (int i = 0; i < n; ++i) {
            Body body = list3.get(i);
            if (bl2 && !body.isActive()) continue;
            boolean bl4 = true;
            for (DetectListener detectListener : list2) {
                if (detectListener.allow(aABB, body)) continue;
                bl4 = false;
            }
            if (!bl4) continue;
            Transform transform = body.getTransform();
            int n2 = body.getFixtureCount();
            for (int j = 0; j < n2; ++j) {
                Object object;
                BodyFixture bodyFixture = body.getFixture(j);
                if (bl && bodyFixture.isSensor() || filter != null && !filter.isAllowed(bodyFixture.getFilter())) continue;
                bl4 = true;
                Object object2 = list2.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (object.allow(aABB, body, bodyFixture)) continue;
                    bl4 = false;
                }
                if (!bl4 || !aABB.overlaps((AABB)(object2 = bodyFixture.getShape().createAABB(transform)))) continue;
                object = new DetectResult();
                ((DetectResult)object).body = body;
                ((DetectResult)object).fixture = bodyFixture;
                list.add((DetectResult)object);
                bl3 = true;
            }
        }
        return bl3;
    }

    public boolean detect(Convex convex, List<DetectResult> list) {
        return this.detect(convex, Transform.IDENTITY, null, false, true, false, list);
    }

    public boolean detect(Convex convex, boolean bl, List<DetectResult> list) {
        return this.detect(convex, Transform.IDENTITY, null, bl, true, false, list);
    }

    public boolean detect(Convex convex, boolean bl, boolean bl2, List<DetectResult> list) {
        return this.detect(convex, Transform.IDENTITY, null, bl, bl2, false, list);
    }

    public boolean detect(Convex convex, Filter filter, boolean bl, boolean bl2, List<DetectResult> list) {
        return this.detect(convex, Transform.IDENTITY, filter, bl, bl2, false, list);
    }

    public boolean detect(Convex convex, Filter filter, boolean bl, boolean bl2, boolean bl3, List<DetectResult> list) {
        return this.detect(convex, Transform.IDENTITY, filter, bl, bl2, bl3, list);
    }

    public boolean detect(Convex convex, Transform transform, List<DetectResult> list) {
        return this.detect(convex, transform, null, false, true, false, list);
    }

    public boolean detect(Convex convex, Transform transform, boolean bl, List<DetectResult> list) {
        return this.detect(convex, transform, null, bl, true, false, list);
    }

    public boolean detect(Convex convex, Transform transform, boolean bl, boolean bl2, List<DetectResult> list) {
        return this.detect(convex, transform, null, bl, bl2, false, list);
    }

    public boolean detect(Convex convex, Transform transform, Filter filter, boolean bl, boolean bl2, List<DetectResult> list) {
        return this.detect(convex, transform, filter, bl, bl2, false, list);
    }

    public boolean detect(Convex convex, Transform transform, Filter filter, boolean bl, boolean bl2, boolean bl3, List<DetectResult> list) {
        List<DetectListener> list2 = this.getListeners(DetectListener.class);
        boolean bl4 = true;
        AABB aABB = convex.createAABB(transform);
        List<Body> list3 = this.broadphaseDetector.detect(aABB);
        int n = list3.size();
        boolean bl5 = false;
        for (int i = 0; i < n; ++i) {
            Body body = list3.get(i);
            bl4 = true;
            for (DetectListener detectListener : list2) {
                if (detectListener.allow(convex, transform, body)) continue;
                bl4 = false;
            }
            if (!bl4) continue;
            Transform transform2 = body.getTransform();
            int n2 = body.getFixtureCount();
            if (bl2 && !body.isActive()) continue;
            for (int j = 0; j < n2; ++j) {
                BodyFixture bodyFixture = body.getFixture(j);
                if (bl && bodyFixture.isSensor()) continue;
                Filter filter2 = bodyFixture.getFilter();
                if (filter != null && !filter2.isAllowed(filter)) continue;
                bl4 = true;
                for (DetectListener detectListener : list2) {
                    if (detectListener.allow(convex, transform, body, bodyFixture)) continue;
                    bl4 = false;
                }
                if (!bl4) continue;
                Convex convex2 = bodyFixture.getShape();
                boolean bl6 = false;
                Penetration penetration = bl3 ? new Penetration() : null;
                bl6 = bl3 ? this.narrowphaseDetector.detect(convex, transform, convex2, transform2) : this.narrowphaseDetector.detect(convex, transform, convex2, transform2, penetration);
                if (!bl6) continue;
                DetectResult detectResult = new DetectResult();
                detectResult.body = body;
                detectResult.fixture = bodyFixture;
                detectResult.penetration = penetration;
                list.add(detectResult);
                bl5 = true;
            }
        }
        return bl5;
    }

    public boolean detect(AABB aABB, Body body, boolean bl, List<DetectResult> list) {
        return this.detect(aABB, body, null, bl, list);
    }

    /*
     * WARNING - void declaration
     */
    public boolean detect(AABB aABB, Body body, Filter filter, boolean bl, List<DetectResult> list) {
        void var9_13;
        List<DetectListener> list2 = this.getListeners(DetectListener.class);
        boolean bl2 = true;
        for (DetectListener object2 : list2) {
            if (object2.allow(aABB, body)) continue;
            bl2 = false;
        }
        if (!bl2) {
            return false;
        }
        boolean bl3 = false;
        AABB aABB2 = this.broadphaseDetector.getAABB(body);
        if (aABB2 == null) {
            AABB aABB3 = body.createAABB();
        }
        if (aABB.overlaps((AABB)var9_13)) {
            Transform transform = body.getTransform();
            int n = body.getFixtureCount();
            for (int i = 0; i < n; ++i) {
                Object object;
                BodyFixture bodyFixture = body.getFixture(i);
                if (bl && bodyFixture.isSensor() || filter != null && !filter.isAllowed(bodyFixture.getFilter())) continue;
                bl2 = true;
                Object object2 = list2.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (object.allow(aABB, body, bodyFixture)) continue;
                    bl2 = false;
                }
                if (!bl2 || !aABB.overlaps((AABB)(object2 = bodyFixture.getShape().createAABB(transform)))) continue;
                object = new DetectResult();
                ((DetectResult)object).body = body;
                ((DetectResult)object).fixture = bodyFixture;
                list.add((DetectResult)object);
                bl3 = true;
            }
        }
        return bl3;
    }

    public boolean detect(Convex convex, Body body, boolean bl, List<DetectResult> list) {
        return this.detect(convex, Transform.IDENTITY, body, null, bl, false, list);
    }

    public boolean detect(Convex convex, Body body, Filter filter, boolean bl, List<DetectResult> list) {
        return this.detect(convex, Transform.IDENTITY, body, filter, bl, false, list);
    }

    public boolean detect(Convex convex, Body body, Filter filter, boolean bl, boolean bl2, List<DetectResult> list) {
        return this.detect(convex, Transform.IDENTITY, body, filter, bl, bl2, list);
    }

    public boolean detect(Convex convex, Transform transform, Body body, boolean bl, List<DetectResult> list) {
        return this.detect(convex, transform, body, null, bl, false, list);
    }

    public boolean detect(Convex convex, Transform transform, Body body, Filter filter, boolean bl, List<DetectResult> list) {
        return this.detect(convex, transform, body, filter, bl, false, list);
    }

    /*
     * WARNING - void declaration
     */
    public boolean detect(Convex convex, Transform transform, Body body, Filter filter, boolean bl, boolean bl2, List<DetectResult> list) {
        void var11_14;
        List<DetectListener> list2 = this.getListeners(DetectListener.class);
        boolean bl3 = true;
        for (DetectListener object2 : list2) {
            if (object2.allow(convex, transform, body)) continue;
            bl3 = false;
        }
        if (!bl3) {
            return false;
        }
        AABB aABB = convex.createAABB(transform);
        AABB aABB2 = this.broadphaseDetector.getAABB(body);
        if (aABB2 == null) {
            AABB aABB3 = body.createAABB();
        }
        boolean bl4 = false;
        if (aABB.overlaps((AABB)var11_14)) {
            Transform transform2 = body.getTransform();
            int n = body.getFixtureCount();
            for (int i = 0; i < n; ++i) {
                BodyFixture bodyFixture = body.getFixture(i);
                if (bl && bodyFixture.isSensor()) continue;
                Filter filter2 = bodyFixture.getFilter();
                if (filter != null && !filter2.isAllowed(filter)) continue;
                bl3 = true;
                for (DetectListener detectListener : list2) {
                    if (detectListener.allow(convex, transform, body, bodyFixture)) continue;
                    bl3 = false;
                }
                if (!bl3) continue;
                Convex convex2 = bodyFixture.getShape();
                boolean bl5 = false;
                Penetration penetration = bl2 ? new Penetration() : null;
                bl5 = bl2 ? this.narrowphaseDetector.detect(convex, transform, convex2, transform2) : this.narrowphaseDetector.detect(convex, transform, convex2, transform2, penetration);
                if (!bl5) continue;
                DetectResult detectResult = new DetectResult();
                detectResult.body = body;
                detectResult.fixture = bodyFixture;
                detectResult.penetration = penetration;
                list.add(detectResult);
                bl4 = true;
            }
        }
        return bl4;
    }

    public void shiftCoordinates(Vector2 vector2) {
        int n;
        int n2 = this.bodies.size();
        for (n = 0; n < n2; ++n) {
            Body body = this.bodies.get(n);
            body.shiftCoordinates(vector2);
        }
        n = this.joints.size();
        for (int i = 0; i < n; ++i) {
            Joint joint = this.joints.get(i);
            joint.shiftCoordinates(vector2);
        }
        this.broadphaseDetector.shiftCoordinates(vector2);
        if (this.bounds != null) {
            this.bounds.shiftCoordinates(vector2);
        }
        this.contactManager.shiftCoordinates(vector2);
    }

    public void addBody(Body body) {
        if (body == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.addNullBody"));
        }
        if (body.world == this) {
            throw new IllegalArgumentException(Messages.getString("dynamics.world.addExistingBody"));
        }
        if (body.world != null) {
            throw new IllegalArgumentException(Messages.getString("dynamics.world.addOtherWorldBody"));
        }
        this.bodies.add(body);
        body.setWorld(this);
        this.broadphaseDetector.add(body);
    }

    public void addJoint(Joint joint) {
        if (joint == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.addNullJoint"));
        }
        if (joint.world == this) {
            throw new IllegalArgumentException(Messages.getString("dynamics.world.addExistingJoint"));
        }
        if (joint.world != null) {
            throw new IllegalArgumentException(Messages.getString("dynamics.world.addOtherWorldJoint"));
        }
        this.joints.add(joint);
        joint.setWorld(this);
        Body body = joint.getBody1();
        Body body2 = joint.getBody2();
        JointEdge jointEdge = new JointEdge(body2, joint);
        body.joints.add(jointEdge);
        JointEdge jointEdge2 = new JointEdge(body, joint);
        body2.joints.add(jointEdge2);
    }

    public boolean containsBody(Body body) {
        return this.bodies.contains(body);
    }

    public boolean containsJoint(Joint joint) {
        return this.joints.contains(joint);
    }

    public boolean removeBody(Body body) {
        return this.removeBody(body, false);
    }

    public boolean removeBody(Body body, boolean bl) {
        List<DestructionListener> list = null;
        if (bl) {
            list = this.getListeners(DestructionListener.class);
        }
        if (body == null) {
            return false;
        }
        boolean bl2 = this.bodies.remove(body);
        if (bl2) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            body.world = null;
            this.broadphaseDetector.remove(body);
            Iterator<JointEdge> iterator = body.joints.iterator();
            while (iterator.hasNext()) {
                object6 = iterator.next();
                iterator.remove();
                object5 = ((JointEdge)object6).getJoint();
                object4 = ((JointEdge)object6).getOther();
                ((Body)object4).setAsleep(false);
                object3 = ((Body)object4).joints.iterator();
                while (object3.hasNext()) {
                    object2 = (JointEdge)object3.next();
                    Joint joint = ((JointEdge)object2).getJoint();
                    if (joint != object5) continue;
                    object3.remove();
                    break;
                }
                if (bl) {
                    for (DestructionListener destructionListener : list) {
                        destructionListener.destroyed((Joint)object5);
                    }
                }
                this.joints.remove(object5);
                ((Joint)object5).world = null;
            }
            object6 = body.contacts.iterator();
            while (object6.hasNext()) {
                object5 = (ContactEdge)object6.next();
                object6.remove();
                object4 = ((ContactEdge)object5).getContactConstraint();
                object3 = ((ContactEdge)object5).getOther();
                ((Body)object3).setAsleep(false);
                object2 = ((Body)object3).contacts.iterator();
                while (object2.hasNext()) {
                    ContactEdge contactEdge = (ContactEdge)((Object)object2.next());
                    ContactConstraint contactConstraint = contactEdge.getContactConstraint();
                    if (contactConstraint != object4) continue;
                    object2.remove();
                    break;
                }
                this.contactManager.remove((ContactConstraint)object4);
                ((ContactConstraint)object4).world = null;
                List<Contact> list2 = ((ContactConstraint)object4).getContacts();
                int n = list2.size();
                for (int i = 0; i < n; ++i) {
                    Contact contact = list2.get(i);
                    ContactPoint contactPoint = new ContactPoint(new ContactPointId(((ContactConstraint)object4).getId(), contact.getId()), ((ContactConstraint)object4).getBody1(), ((ContactConstraint)object4).getFixture1(), ((ContactConstraint)object4).getBody2(), ((ContactConstraint)object4).getFixture2(), contact.isEnabled(), contact.getPoint(), ((ContactConstraint)object4).getNormal(), contact.getDepth());
                    if (!bl) continue;
                    for (DestructionListener destructionListener : list) {
                        destructionListener.destroyed(contactPoint);
                    }
                }
            }
        }
        return bl2;
    }

    public boolean removeJoint(Joint joint) {
        if (joint == null) {
            return false;
        }
        boolean bl = this.joints.remove(joint);
        if (bl) {
            JointEdge jointEdge;
            joint.world = null;
            Body body = joint.getBody1();
            Body body2 = joint.getBody2();
            Iterator<JointEdge> iterator = body.joints.iterator();
            while (iterator.hasNext()) {
                jointEdge = iterator.next();
                if (jointEdge.getJoint() != joint) continue;
                iterator.remove();
                break;
            }
            iterator = body2.joints.iterator();
            while (iterator.hasNext()) {
                jointEdge = iterator.next();
                if (jointEdge.getJoint() != joint) continue;
                iterator.remove();
                break;
            }
            body.setAsleep(false);
            body2.setAsleep(false);
        }
        return bl;
    }

    public void removeAllBodiesAndJoints() {
        this.removeAllBodiesAndJoints(false);
    }

    public void removeAllBodiesAndJoints(boolean bl) {
        int n;
        List<DestructionListener> list = null;
        if (bl) {
            list = this.getListeners(DestructionListener.class);
        }
        int n2 = this.bodies.size();
        for (n = 0; n < n2; ++n) {
            Body body = this.bodies.get(n);
            body.joints.clear();
            if (bl) {
                for (ContactEdge contactEdge : body.contacts) {
                    Object object;
                    Body body2 = contactEdge.getOther();
                    ContactConstraint contactConstraint = contactEdge.getContactConstraint();
                    Iterator<ContactEdge> iterator = body2.contacts.iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        ContactConstraint contactConstraint2 = ((ContactEdge)object).getContactConstraint();
                        if (contactConstraint2 != contactConstraint) continue;
                        iterator.remove();
                        break;
                    }
                    contactConstraint.world = null;
                    object = contactConstraint.getContacts();
                    int n3 = object.size();
                    for (int i = 0; i < n3; ++i) {
                        Contact contact = (Contact)object.get(i);
                        ContactPoint contactPoint = new ContactPoint(new ContactPointId(contactConstraint.getId(), contact.getId()), contactConstraint.getBody1(), contactConstraint.getFixture1(), contactConstraint.getBody2(), contactConstraint.getFixture2(), contact.isEnabled(), contact.getPoint(), contactConstraint.getNormal(), contact.getDepth());
                        for (DestructionListener destructionListener : list) {
                            destructionListener.destroyed(contactPoint);
                        }
                    }
                }
                for (DestructionListener destructionListener : list) {
                    destructionListener.destroyed(body);
                }
            }
            body.contacts.clear();
            body.world = null;
        }
        if (bl) {
            n = this.joints.size();
            for (int i = 0; i < n; ++i) {
                Joint joint = this.joints.get(i);
                for (DestructionListener destructionListener : list) {
                    destructionListener.destroyed(joint);
                }
                joint.world = null;
            }
        }
        this.broadphaseDetector.clear();
        this.joints.clear();
        this.bodies.clear();
        this.contactManager.reset();
    }

    public void removeAllBodies() {
        this.removeAllBodiesAndJoints(false);
    }

    public void removeAllBodies(boolean bl) {
        this.removeAllBodiesAndJoints(bl);
    }

    public void removeAllJoints() {
        this.removeAllJoints(false);
    }

    public void removeAllJoints(boolean bl) {
        List<DestructionListener> list = null;
        if (bl) {
            list = this.getListeners(DestructionListener.class);
        }
        int n = this.joints.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Joint joint = this.joints.get(i);
            Body body = joint.getBody1();
            Body body2 = joint.getBody2();
            Iterator<JointEdge> iterator = body.joints.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (((JointEdge)object).getJoint() != joint) continue;
                iterator.remove();
                break;
            }
            iterator = body2.joints.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (((JointEdge)object).getJoint() != joint) continue;
                iterator.remove();
                break;
            }
            body.setAsleep(false);
            body2.setAsleep(false);
            if (bl) {
                for (DestructionListener destructionListener : list) {
                    destructionListener.destroyed(joint);
                }
            }
            joint.world = null;
        }
        this.joints.clear();
    }

    public boolean isUpdateRequired() {
        return this.updateRequired;
    }

    public void setUpdateRequired(boolean bl) {
        this.updateRequired = bl;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        if (settings == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullSettings"));
        }
        this.settings = settings;
    }

    public void setGravity(Vector2 vector2) {
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullGravity"));
        }
        this.gravity = vector2;
    }

    public Vector2 getGravity() {
        return this.gravity;
    }

    public void setBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public <T extends Listener> List<T> getListeners(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Listener listener : this.listeners) {
            if (!clazz.isInstance(listener)) continue;
            arrayList.add(clazz.cast(listener));
        }
        return arrayList;
    }

    public <T extends Listener> void getListeners(Class<T> clazz, List<T> list) {
        if (clazz == null || list == null) {
            return;
        }
        for (Listener listener : this.listeners) {
            if (!clazz.isInstance(listener)) continue;
            list.add(clazz.cast(listener));
        }
    }

    public void addListener(Listener listener) {
        if (listener == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullListener"));
        }
        if (this.listeners.contains(listener)) {
            throw new IllegalArgumentException("dynamics.world.addExistingListener");
        }
        this.listeners.add(listener);
    }

    public boolean containsListener(Listener listener) {
        return this.listeners.contains(listener);
    }

    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    public int removeAllListeners() {
        int n = this.listeners.size();
        this.listeners.clear();
        return n;
    }

    public <T extends Listener> int removeAllListeners(Class<T> clazz) {
        if (clazz == null) {
            return 0;
        }
        if (this.listeners.isEmpty()) {
            return 0;
        }
        int n = 0;
        Iterator<Listener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Listener listener = iterator.next();
            if (!clazz.isInstance(listener)) continue;
            iterator.remove();
            ++n;
        }
        return n;
    }

    public int getListenerCount() {
        return this.listeners.size();
    }

    public <T extends Listener> int getListenerCount(Class<T> clazz) {
        if (clazz == null) {
            return 0;
        }
        int n = 0;
        for (Listener listener : this.listeners) {
            if (!clazz.isInstance(listener)) continue;
            ++n;
        }
        return n;
    }

    public void setBroadphaseDetector(BroadphaseDetector<Body> broadphaseDetector) {
        if (broadphaseDetector == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullBroadphaseDetector"));
        }
        this.broadphaseDetector.clear();
        this.broadphaseDetector = broadphaseDetector;
        int n = this.bodies.size();
        for (int i = 0; i < n; ++i) {
            this.broadphaseDetector.add((Body)((Collidable)this.bodies.get(i)));
        }
    }

    public BroadphaseDetector<Body> getBroadphaseDetector() {
        return this.broadphaseDetector;
    }

    public void setNarrowphaseDetector(NarrowphaseDetector narrowphaseDetector) {
        if (narrowphaseDetector == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullNarrowphaseDetector"));
        }
        this.narrowphaseDetector = narrowphaseDetector;
    }

    public NarrowphaseDetector getNarrowphaseDetector() {
        return this.narrowphaseDetector;
    }

    public void setManifoldSolver(ManifoldSolver manifoldSolver) {
        if (manifoldSolver == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullManifoldSolver"));
        }
        this.manifoldSolver = manifoldSolver;
    }

    public ManifoldSolver getManifoldSolver() {
        return this.manifoldSolver;
    }

    public void setTimeOfImpactDetector(TimeOfImpactDetector timeOfImpactDetector) {
        if (timeOfImpactDetector == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullTimeOfImpactDetector"));
        }
        this.timeOfImpactDetector = timeOfImpactDetector;
    }

    public TimeOfImpactDetector getTimeOfImpactDetector() {
        return this.timeOfImpactDetector;
    }

    public void setRaycastDetector(RaycastDetector raycastDetector) {
        if (raycastDetector == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullRaycastDetector"));
        }
        this.raycastDetector = raycastDetector;
    }

    public RaycastDetector getRaycastDetector() {
        return this.raycastDetector;
    }

    public CoefficientMixer getCoefficientMixer() {
        return this.coefficientMixer;
    }

    public void setCoefficientMixer(CoefficientMixer coefficientMixer) {
        if (coefficientMixer == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullCoefficientMixer"));
        }
        this.coefficientMixer = coefficientMixer;
    }

    public ContactManager getContactManager() {
        return this.contactManager;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public int getBodyCount() {
        return this.bodies.size();
    }

    public Body getBody(int n) {
        return this.bodies.get(n);
    }

    public List<Body> getBodies() {
        ArrayList<Body> arrayList = new ArrayList<Body>(this.bodies.size());
        arrayList.addAll(this.bodies);
        return arrayList;
    }

    public int getJointCount() {
        return this.joints.size();
    }

    public Joint getJoint(int n) {
        return this.joints.get(n);
    }

    public List<Joint> getJoints() {
        ArrayList<Joint> arrayList = new ArrayList<Joint>(this.joints.size());
        arrayList.addAll(this.joints);
        return arrayList;
    }

    public Step getStep() {
        return this.step;
    }

    public boolean isEmpty() {
        int n = this.bodies.size();
        int n2 = this.joints.size();
        return n == 0 && n2 == 0;
    }

    @Deprecated
    public void add(Body body) {
        this.addBody(body);
    }

    @Deprecated
    public void add(Joint joint) {
        this.addJoint(joint);
    }

    @Deprecated
    public boolean remove(Body body) {
        return this.removeBody(body);
    }

    @Deprecated
    public boolean remove(Body body, boolean bl) {
        return this.removeBody(body, bl);
    }

    @Deprecated
    public boolean remove(Joint joint) {
        return this.removeJoint(joint);
    }

    @Deprecated
    public void removeAll() {
        this.removeAllBodiesAndJoints(false);
    }

    @Deprecated
    public void removeAll(boolean bl) {
        this.removeAllBodiesAndJoints(bl);
    }

    @Deprecated
    public void removeListeners() {
        this.removeAllListeners();
    }

    @Deprecated
    public List<Body> detect(AABB aABB) {
        ArrayList<Body> arrayList = new ArrayList<Body>();
        this.detect(aABB, true, arrayList);
        return arrayList;
    }

    @Deprecated
    public List<Body> detect(Convex convex) {
        return this.detect(convex, Transform.IDENTITY);
    }

    @Deprecated
    public List<Body> detect(Convex convex, Transform transform) {
        List<DetectListener> list = this.getListeners(DetectListener.class);
        boolean bl = true;
        AABB aABB = convex.createAABB(transform);
        List<Body> list2 = this.broadphaseDetector.detect(aABB);
        Iterator<Body> iterator = list2.iterator();
        while (iterator.hasNext()) {
            Body body = iterator.next();
            bl = true;
            for (DetectListener detectListener : list) {
                if (detectListener.allow(convex, transform, body)) continue;
                bl = false;
            }
            if (!bl) {
                iterator.remove();
                continue;
            }
            Transform transform2 = body.getTransform();
            int n = body.getFixtureCount();
            boolean bl2 = false;
            for (int i = 0; i < n; ++i) {
                BodyFixture bodyFixture = body.getFixture(i);
                bl = true;
                Object object = list.iterator();
                while (object.hasNext()) {
                    DetectListener detectListener = object.next();
                    if (detectListener.allow(convex, transform, body, bodyFixture)) continue;
                    bl = false;
                }
                if (!bl || !this.narrowphaseDetector.detect(convex, transform, (Convex)(object = bodyFixture.getShape()), transform2)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            iterator.remove();
        }
        return list2;
    }
}

