/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.contact;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dyn4j.collision.Collisions;
import org.dyn4j.collision.manifold.ManifoldPointId;
import org.dyn4j.dynamics.Capacity;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.World;
import org.dyn4j.dynamics.contact.Contact;
import org.dyn4j.dynamics.contact.ContactConstraint;
import org.dyn4j.dynamics.contact.ContactConstraintId;
import org.dyn4j.dynamics.contact.ContactListener;
import org.dyn4j.dynamics.contact.ContactPoint;
import org.dyn4j.dynamics.contact.ContactPointId;
import org.dyn4j.dynamics.contact.PersistedContactPoint;
import org.dyn4j.dynamics.contact.SolvedContactPoint;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class ContactManager {
    protected World world;
    protected Map<ContactConstraintId, ContactConstraint> map;
    protected List<ContactConstraint> list;
    protected List<ContactListener> listeners;

    public ContactManager(World world) {
        this(world, Capacity.DEFAULT_CAPACITY);
    }

    public ContactManager(World world, Capacity capacity) {
        if (world == null) {
            throw new NullPointerException(Messages.getString("dynamics.nullWorld"));
        }
        if (capacity == null) {
            throw new NullPointerException(Messages.getString("dynamics.nullCapacity"));
        }
        this.world = world;
        int n = Collisions.getEstimatedCollisionPairs(capacity.getBodyCount());
        this.map = new HashMap<ContactConstraintId, ContactConstraint>(n * 4 / 3 + 1, 0.75f);
        this.list = new ArrayList<ContactConstraint>(n);
        this.listeners = null;
    }

    public void add(ContactConstraint contactConstraint) {
        this.list.add(contactConstraint);
    }

    public boolean remove(ContactConstraint contactConstraint) {
        return this.map.remove(contactConstraint.id) != null;
    }

    public void clear() {
        this.list.clear();
    }

    public void reset() {
        this.list.clear();
        this.map.clear();
    }

    public void shiftCoordinates(Vector2 vector2) {
        for (ContactConstraint contactConstraint : this.map.values()) {
            contactConstraint.shiftCoordinates(vector2);
        }
    }

    public void updateContacts() {
        int n = this.list.size();
        this.listeners = this.world.getListeners(ContactListener.class);
        Settings settings = this.world.getSettings();
        double d = settings.getWarmStartDistanceSquared();
        HashMap<ContactConstraintId, ContactConstraint> hashMap = null;
        if (n > 0) {
            hashMap = new HashMap<ContactConstraintId, ContactConstraint>(n * 4 / 3 + 1, 0.75f);
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            ContactConstraint contactConstraint = this.list.get(i);
            ContactConstraint contactConstraint2 = null;
            List<Contact> list = contactConstraint.contacts;
            int n3 = list.size();
            if (contactConstraint.isSensor()) {
                for (n2 = 0; n2 < n3; ++n2) {
                    Contact contact = list.get(n2);
                    ContactPoint contactPoint = new ContactPoint(new ContactPointId(contactConstraint.id, contact.id), contactConstraint.getBody1(), contactConstraint.fixture1, contactConstraint.getBody2(), contactConstraint.fixture2, false, contact.p, contactConstraint.normal, contact.depth);
                    for (ContactListener contactListener : this.listeners) {
                        contactListener.sensed(contactPoint);
                    }
                }
                continue;
            }
            contactConstraint2 = this.map.remove(contactConstraint.id);
            if (contactConstraint2 != null) {
                int n4;
                List<Contact> list2 = contactConstraint2.contacts;
                int n5 = list2.size();
                boolean[] blArray = new boolean[n5];
                for (n4 = 0; n4 < n3; ++n4) {
                    Contact contact = list.get(n4);
                    boolean bl = false;
                    for (int j = 0; j < n5; ++j) {
                        Contact contact2 = list2.get(j);
                        if (!(contact.id == ManifoldPointId.DISTANCE && contact.p.distanceSquared(contact2.p) <= d) && !contact.id.equals(contact2.id)) continue;
                        contact.jn = contact2.jn;
                        contact.jt = contact2.jt;
                        PersistedContactPoint persistedContactPoint = new PersistedContactPoint(new ContactPointId(contactConstraint.id, contact.id), contactConstraint.getBody1(), contactConstraint.getFixture1(), contactConstraint.getBody2(), contactConstraint.getFixture2(), true, contact.p, contactConstraint.normal, contact.depth, contact2.p, contactConstraint2.normal, contact2.depth);
                        boolean bl2 = true;
                        for (ContactListener contactListener : this.listeners) {
                            if (contactListener.persist(persistedContactPoint)) continue;
                            bl2 = false;
                        }
                        contact.enabled = bl2;
                        blArray[j] = true;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    ContactPoint contactPoint = new ContactPoint(new ContactPointId(contactConstraint.id, contact.id), contactConstraint.getBody1(), contactConstraint.fixture1, contactConstraint.getBody2(), contactConstraint.fixture2, false, contact.p, contactConstraint.normal, contact.depth);
                    boolean bl3 = true;
                    for (ContactListener contactListener : this.listeners) {
                        if (contactListener.begin(contactPoint)) continue;
                        bl3 = false;
                    }
                    contact.enabled = bl3;
                }
                n4 = blArray.length;
                for (int j = 0; j < n4; ++j) {
                    if (blArray[j]) continue;
                    Contact contact = list2.get(j);
                    ContactPoint contactPoint = new ContactPoint(new ContactPointId(contactConstraint.id, contact.id), contactConstraint.getBody1(), contactConstraint.fixture1, contactConstraint.getBody2(), contactConstraint.fixture2, false, contact.p, contactConstraint.normal, contact.depth);
                    for (ContactListener contactListener : this.listeners) {
                        contactListener.end(contactPoint);
                    }
                }
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    Contact contact = list.get(n2);
                    ContactPoint contactPoint = new ContactPoint(new ContactPointId(contactConstraint.id, contact.id), contactConstraint.getBody1(), contactConstraint.fixture1, contactConstraint.getBody2(), contactConstraint.fixture2, false, contact.p, contactConstraint.normal, contact.depth);
                    boolean bl = true;
                    for (ContactListener contactListener : this.listeners) {
                        if (contactListener.begin(contactPoint)) continue;
                        bl = false;
                    }
                    contact.enabled = bl;
                }
            }
            hashMap.put(contactConstraint.id, contactConstraint);
        }
        if (!this.map.isEmpty()) {
            for (ContactConstraint contactConstraint : this.map.values()) {
                int n6 = contactConstraint.contacts.size();
                for (int i = 0; i < n6; ++i) {
                    Contact contact = contactConstraint.contacts.get(i);
                    ContactPoint contactPoint = new ContactPoint(new ContactPointId(contactConstraint.id, contact.id), contactConstraint.getBody1(), contactConstraint.fixture1, contactConstraint.getBody2(), contactConstraint.fixture2, false, contact.p, contactConstraint.normal, contact.depth);
                    for (ContactListener contactListener : this.listeners) {
                        contactListener.end(contactPoint);
                    }
                }
            }
        }
        if (n > 0) {
            this.map = hashMap;
        } else {
            this.map.clear();
        }
    }

    public void preSolveNotify() {
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            ContactConstraint contactConstraint = this.list.get(i);
            if (contactConstraint.isSensor()) continue;
            int n2 = contactConstraint.contacts.size();
            for (int j = 0; j < n2; ++j) {
                Contact contact = contactConstraint.contacts.get(j);
                ContactPoint contactPoint = new ContactPoint(new ContactPointId(contactConstraint.id, contact.id), contactConstraint.getBody1(), contactConstraint.fixture1, contactConstraint.getBody2(), contactConstraint.fixture2, false, contact.p, contactConstraint.normal, contact.depth);
                boolean bl = true;
                for (ContactListener contactListener : this.listeners) {
                    if (contactListener.preSolve(contactPoint)) continue;
                    bl = false;
                }
                contact.enabled = bl;
            }
        }
    }

    public void postSolveNotify() {
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            ContactConstraint contactConstraint = this.list.get(i);
            if (contactConstraint.isSensor()) continue;
            int n2 = contactConstraint.contacts.size();
            for (int j = 0; j < n2; ++j) {
                Contact contact = contactConstraint.contacts.get(j);
                SolvedContactPoint solvedContactPoint = new SolvedContactPoint(new ContactPointId(contactConstraint.id, contact.id), contactConstraint.getBody1(), contactConstraint.fixture1, contactConstraint.getBody2(), contactConstraint.fixture2, false, contact.p, contactConstraint.normal, contact.depth, contact.jn, contact.jt);
                for (ContactListener contactListener : this.listeners) {
                    contactListener.postSolve(solvedContactPoint);
                }
            }
        }
    }

    public boolean isListEmpty() {
        return this.list.isEmpty();
    }

    public boolean isCacheEmpty() {
        return this.map.isEmpty();
    }

    @Deprecated
    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

