/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.contact;

import org.dyn4j.collision.continuous.TimeOfImpact;
import org.dyn4j.collision.narrowphase.Separation;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.World;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Vector2;

public class TimeOfImpactSolver {
    protected World world;

    public TimeOfImpactSolver(World world) {
        this.world = world;
    }

    public void solve(Body body, Body body2, TimeOfImpact timeOfImpact) {
        Settings settings = this.world.getSettings();
        double d = settings.getLinearTolerance();
        double d2 = settings.getMaximumLinearCorrection();
        Vector2 vector2 = body.getWorldCenter();
        Vector2 vector22 = body2.getWorldCenter();
        Mass mass = body.getMass();
        Mass mass2 = body2.getMass();
        double d3 = mass.getMass();
        double d4 = mass2.getMass();
        double d5 = d3 * mass.getInverseMass();
        double d6 = d3 * mass.getInverseInertia();
        double d7 = d4 * mass2.getInverseMass();
        double d8 = d4 * mass2.getInverseInertia();
        Separation separation = timeOfImpact.getSeparation();
        Vector2 vector23 = separation.getPoint1();
        Vector2 vector24 = separation.getPoint2();
        Vector2 vector25 = vector2.to(vector23);
        Vector2 vector26 = vector22.to(vector24);
        Vector2 vector27 = separation.getNormal();
        double d9 = separation.getDistance();
        double d10 = Interval.clamp(d9 - d, -d2, 0.0);
        double d11 = vector25.cross(vector27);
        double d12 = vector26.cross(vector27);
        double d13 = d5 + d7 + d6 * d11 * d11 + d8 * d12 * d12;
        double d14 = 0.0;
        if (d13 > 0.0) {
            d14 = -d10 / d13;
        }
        Vector2 vector28 = vector27.product(d14);
        body.translate(vector28.product(d5));
        body.rotate(d6 * vector25.cross(vector28), vector2.x, vector2.y);
        body2.translate(vector28.product(-d7));
        body2.rotate(-d8 * vector26.cross(vector28), vector22.x, vector22.y);
    }
}

