/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Matrix22;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class MouseJoint
extends Joint {
    protected Vector2 target;
    protected Vector2 anchor;
    protected double frequency;
    protected double dampingRatio;
    protected double maximumForce;
    protected Matrix22 K;
    protected Vector2 bias;
    protected double gamma;
    protected Vector2 impulse;

    public MouseJoint(Body body, Vector2 vector2, double d, double d2, double d3) {
        super(body, body, false);
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.mouse.nullAnchor"));
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidFrequency"));
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidDampingRatio"));
        }
        if (d3 < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.mouse.invalidMaximumForce"));
        }
        this.target = vector2;
        this.anchor = body.getLocalPoint(vector2);
        this.frequency = d;
        this.dampingRatio = d2;
        this.maximumForce = d3;
        this.K = new Matrix22();
        this.impulse = new Vector2();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MouseJoint[").append(super.toString()).append("|Target=").append(this.target).append("|Anchor=").append(this.anchor).append("|Frequency=").append(this.frequency).append("|DampingRatio=").append(this.dampingRatio).append("|MaximumForce=").append(this.maximumForce).append("]");
        return stringBuilder.toString();
    }

    @Override
    public void initializeConstraints() {
        Step step = this.world.getStep();
        Body body = this.body2;
        Transform transform = body.getTransform();
        Mass mass = this.body2.getMass();
        double d = mass.getMass();
        double d2 = mass.getInverseMass();
        double d3 = mass.getInverseInertia();
        if (d <= Epsilon.E) {
            d = mass.getInertia();
        }
        double d4 = Math.PI * 2 * this.frequency;
        double d5 = 2.0 * d * this.dampingRatio * d4;
        double d6 = d * d4 * d4;
        double d7 = step.getDeltaTime();
        this.gamma = d7 * (d5 + d7 * d6);
        if (this.gamma > Epsilon.E) {
            this.gamma = 1.0 / this.gamma;
        }
        Vector2 vector2 = transform.getTransformedR(body.getLocalCenter().to(this.anchor));
        this.bias = body.getWorldCenter().add(vector2).difference(this.target);
        this.bias.multiply(d7 * d6 * this.gamma);
        this.K.m00 = d2 + vector2.y * vector2.y * d3;
        this.K.m10 = this.K.m01 = -d3 * vector2.x * vector2.y;
        this.K.m11 = d2 + vector2.x * vector2.x * d3;
        this.K.m00 += this.gamma;
        this.K.m11 += this.gamma;
        this.impulse.multiply(step.getDeltaTimeRatio());
        body.getLinearVelocity().add(this.impulse.product(d2));
        body.setAngularVelocity(body.getAngularVelocity() + d3 * vector2.cross(this.impulse));
    }

    @Override
    public void solveVelocityConstraints() {
        Vector2 vector2;
        Step step = this.world.getStep();
        Body body = this.body2;
        Transform transform = body.getTransform();
        Mass mass = this.body2.getMass();
        double d = mass.getInverseMass();
        double d2 = mass.getInverseInertia();
        Vector2 vector22 = transform.getTransformedR(body.getLocalCenter().to(this.anchor));
        Vector2 vector23 = vector2 = vector22.cross(body.getAngularVelocity()).add(body.getLinearVelocity());
        vector23.add(this.bias);
        vector23.add(this.impulse.product(this.gamma));
        vector23.negate();
        Vector2 vector24 = this.K.solve(vector23);
        Vector2 vector25 = this.impulse.copy();
        this.impulse.add(vector24);
        double d3 = step.getDeltaTime() * this.maximumForce;
        if (this.impulse.getMagnitudeSquared() > d3 * d3) {
            this.impulse.normalize();
            this.impulse.multiply(d3);
        }
        vector24 = this.impulse.difference(vector25);
        body.getLinearVelocity().add(vector24.product(d));
        body.setAngularVelocity(body.getAngularVelocity() + d2 * vector22.cross(vector24));
    }

    @Override
    public boolean solvePositionConstraints() {
        return true;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.target;
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.anchor);
    }

    @Override
    public Vector2 getReactionForce(double d) {
        return this.impulse.product(d);
    }

    @Override
    public double getReactionTorque(double d) {
        return 0.0;
    }

    @Override
    public boolean isCollisionAllowed() {
        return false;
    }

    @Override
    protected void shiftCoordinates(Vector2 vector2) {
        this.target.add(vector2);
    }

    public void setTarget(Vector2 vector2) {
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.mouse.nullTarget"));
        }
        this.body2.setAsleep(false);
        this.target = vector2;
    }

    public Vector2 getTarget() {
        return this.target;
    }

    public double getMaximumForce() {
        return this.maximumForce;
    }

    public void setMaximumForce(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.mouse.invalidMaximumForce"));
        }
        this.maximumForce = d;
    }

    public double getDampingRatio() {
        return this.dampingRatio;
    }

    public void setDampingRatio(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidDampingRatio"));
        }
        this.dampingRatio = d;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidFrequency"));
        }
        this.frequency = d;
    }
}

