/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.AbstractShape;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Vertex;
import org.dyn4j.resources.Messages;

public class Circle
extends AbstractShape
implements Convex,
Shape,
Transformable {
    public Circle(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.circle.invalidRadius"));
        }
        this.center = new Vector2();
        this.radius = d;
    }

    @Override
    public double getRadius(Vector2 vector2) {
        return this.radius + vector2.distance(this.center);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Circle[").append(super.toString()).append("|UserData=").append(this.userData).append("]");
        return stringBuilder.toString();
    }

    @Override
    public boolean contains(Vector2 vector2, Transform transform) {
        Vector2 vector22 = transform.getTransformed(this.center);
        double d = this.radius * this.radius;
        vector22.subtract(vector2);
        return vector22.getMagnitudeSquared() <= d;
    }

    @Override
    public Interval project(Vector2 vector2, Transform transform) {
        Vector2 vector22 = transform.getTransformed(this.center);
        double d = vector22.dot(vector2);
        return new Interval(d - this.radius, d + this.radius);
    }

    @Override
    public Vertex getFarthestFeature(Vector2 vector2, Transform transform) {
        Vector2 vector22 = this.getFarthestPoint(vector2, transform);
        return new Vertex(vector22);
    }

    @Override
    public Vector2 getFarthestPoint(Vector2 vector2, Transform transform) {
        Vector2 vector22 = vector2.getNormalized();
        Vector2 vector23 = transform.getTransformed(this.center);
        vector23.add(this.radius * vector22.x, this.radius * vector22.y);
        return vector23;
    }

    @Override
    public Vector2[] getAxes(Vector2[] vector2Array, Transform transform) {
        return null;
    }

    @Override
    public Vector2[] getFoci(Transform transform) {
        Vector2[] vector2Array = new Vector2[]{transform.getTransformed(this.center)};
        return vector2Array;
    }

    @Override
    public Mass createMass(double d) {
        double d2 = this.radius;
        double d3 = d * Math.PI * d2 * d2;
        double d4 = d3 * d2 * d2 * 0.5;
        return new Mass(this.center, d3, d4);
    }

    @Override
    public AABB createAABB(Transform transform) {
        Vector2 vector2 = transform.getTransformed(this.center);
        return new AABB(vector2, this.radius);
    }
}

