/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dyn4j.Epsilon;
import org.dyn4j.geometry.Capsule;
import org.dyn4j.geometry.Circle;
import org.dyn4j.geometry.Ellipse;
import org.dyn4j.geometry.HalfEllipse;
import org.dyn4j.geometry.Polygon;
import org.dyn4j.geometry.Rectangle;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Slice;
import org.dyn4j.geometry.Triangle;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Wound;
import org.dyn4j.resources.Messages;

public class Geometry {
    public static final double TWO_PI = Math.PI * 2;
    private static final double INV_3 = 0.3333333333333333;
    private static final double INV_SQRT_3 = 1.0 / Math.sqrt(3.0);

    public static final double getWinding(List<Vector2> list) {
        if (list == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointList"));
        }
        int n = list.size();
        if (n < 2) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidSizePointList2"));
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            Vector2 vector2 = list.get(i);
            Vector2 vector22 = list.get(i + 1 == n ? 0 : i + 1);
            if (vector2 == null || vector22 == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointListElements"));
            }
            d += vector2.cross(vector22);
        }
        return d;
    }

    public static final double getWinding(Vector2 ... vector2Array) {
        if (vector2Array == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointArray"));
        }
        int n = vector2Array.length;
        if (n < 2) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidSizePointArray2"));
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            Vector2 vector2 = vector2Array[i];
            Vector2 vector22 = vector2Array[i + 1 == n ? 0 : i + 1];
            if (vector2 == null || vector22 == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointArrayElements"));
            }
            d += vector2.cross(vector22);
        }
        return d;
    }

    public static final void reverseWinding(Vector2 ... vector2Array) {
        if (vector2Array == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointArray"));
        }
        int n = vector2Array.length;
        if (n == 1 || n == 0) {
            return;
        }
        int n2 = 0;
        Vector2 vector2 = null;
        for (int i = n - 1; i > n2; --i, ++n2) {
            vector2 = vector2Array[i];
            vector2Array[i] = vector2Array[n2];
            vector2Array[n2] = vector2;
        }
    }

    public static final void reverseWinding(List<Vector2> list) {
        if (list == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointList"));
        }
        int n = list.size();
        if (n == 1 || n == 0) {
            return;
        }
        Collections.reverse(list);
    }

    public static final Vector2 getAverageCenter(List<Vector2> list) {
        if (list == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointList"));
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidSizePointList1"));
        }
        int n = list.size();
        if (n == 1) {
            Vector2 vector2 = list.get(0);
            if (vector2 == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointListElements"));
            }
            return vector2.copy();
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            Vector2 vector2 = list.get(i);
            if (vector2 == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointListElements"));
            }
            d += vector2.x;
            d2 += vector2.y;
        }
        return new Vector2(d / (double)n, d2 / (double)n);
    }

    public static final Vector2 getAverageCenter(Vector2 ... vector2Array) {
        if (vector2Array == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointArray"));
        }
        int n = vector2Array.length;
        if (n == 0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidSizePointArray1"));
        }
        if (n == 1) {
            Vector2 vector2 = vector2Array[0];
            if (vector2 == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointArrayElements"));
            }
            return vector2.copy();
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            Vector2 vector2 = vector2Array[i];
            if (vector2 == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointArrayElements"));
            }
            d += vector2.x;
            d2 += vector2.y;
        }
        return new Vector2(d / (double)n, d2 / (double)n);
    }

    public static final Vector2 getAreaWeightedCenter(List<Vector2> list) {
        if (list == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointList"));
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidSizePointList1"));
        }
        int n = list.size();
        if (n == 1) {
            Vector2 vector2 = list.get(0);
            if (vector2 == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointListElements"));
            }
            return vector2.copy();
        }
        Vector2 vector2 = new Vector2();
        for (int i = 0; i < n; ++i) {
            Vector2 vector22 = list.get(i);
            if (vector22 == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointListElements"));
            }
            vector2.add(vector22);
        }
        vector2.multiply(1.0 / (double)n);
        Vector2 vector23 = new Vector2();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            Vector2 vector24 = list.get(i);
            Vector2 vector25 = i + 1 < n ? list.get(i + 1) : list.get(0);
            vector24 = vector24.difference(vector2);
            vector25 = vector25.difference(vector2);
            double d2 = vector24.cross(vector25);
            double d3 = 0.5 * d2;
            d += d3;
            vector23.add(vector24.add(vector25).multiply(0.3333333333333333).multiply(d3));
        }
        if (Math.abs(d) <= Epsilon.E) {
            return list.get(0).copy();
        }
        vector23.multiply(1.0 / d);
        vector23.add(vector2);
        return vector23;
    }

    public static final Vector2 getAreaWeightedCenter(Vector2 ... vector2Array) {
        if (vector2Array == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointArray"));
        }
        int n = vector2Array.length;
        if (n == 0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidSizePointArray1"));
        }
        if (n == 1) {
            Vector2 vector2 = vector2Array[0];
            if (vector2 == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointArrayElements"));
            }
            return vector2.copy();
        }
        Vector2 vector2 = new Vector2();
        for (int i = 0; i < n; ++i) {
            Vector2 vector22 = vector2Array[i];
            if (vector22 == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointArrayElements"));
            }
            vector2.add(vector22);
        }
        vector2.multiply(1.0 / (double)n);
        Vector2 vector23 = new Vector2();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            Vector2 vector24 = vector2Array[i];
            Vector2 vector25 = i + 1 < n ? vector2Array[i + 1] : vector2Array[0];
            vector24 = vector24.difference(vector2);
            vector25 = vector25.difference(vector2);
            double d2 = vector24.cross(vector25);
            double d3 = 0.5 * d2;
            d += d3;
            vector23.add(vector24.add(vector25).multiply(0.3333333333333333).multiply(d3));
        }
        if (Math.abs(d) <= Epsilon.E) {
            return vector2Array[0].copy();
        }
        vector23.multiply(1.0 / d);
        vector23.add(vector2);
        return vector23;
    }

    public static final Circle createCircle(double d) {
        return new Circle(d);
    }

    public static final Polygon createPolygon(Vector2 ... vector2Array) {
        if (vector2Array == null) {
            throw new NullPointerException(Messages.getString("geometry.nullVerticesArray"));
        }
        int n = vector2Array.length;
        Vector2[] vector2Array2 = new Vector2[n];
        for (int i = 0; i < n; ++i) {
            Vector2 vector2 = vector2Array[i];
            if (vector2 == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPolygonPoint"));
            }
            vector2Array2[i] = vector2.copy();
        }
        return new Polygon(vector2Array2);
    }

    public static final Polygon createPolygonAtOrigin(Vector2 ... vector2Array) {
        Polygon polygon = Geometry.createPolygon(vector2Array);
        Vector2 vector2 = polygon.getCenter();
        polygon.translate(-vector2.x, -vector2.y);
        return polygon;
    }

    public static final Polygon createUnitCirclePolygon(int n, double d) {
        return Geometry.createUnitCirclePolygon(n, d, 0.0);
    }

    public static final Polygon createUnitCirclePolygon(int n, double d, double d2) {
        if (n < 3) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidVerticesSize"));
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidRadius"));
        }
        return Geometry.createPolygonalCircle(n, d, d2);
    }

    public static final Rectangle createSquare(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidSize"));
        }
        return new Rectangle(d, d);
    }

    public static final Rectangle createRectangle(double d, double d2) {
        return new Rectangle(d, d2);
    }

    public static final Triangle createTriangle(Vector2 vector2, Vector2 vector22, Vector2 vector23) {
        if (vector2 == null || vector22 == null || vector23 == null) {
            throw new NullPointerException(Messages.getString("geometry.nullTrianglePoint"));
        }
        return new Triangle(vector2.copy(), vector22.copy(), vector23.copy());
    }

    public static final Triangle createTriangleAtOrigin(Vector2 vector2, Vector2 vector22, Vector2 vector23) {
        Triangle triangle = Geometry.createTriangle(vector2, vector22, vector23);
        Vector2 vector24 = triangle.getCenter();
        triangle.translate(-vector24.x, -vector24.y);
        return triangle;
    }

    public static final Triangle createRightTriangle(double d, double d2) {
        return Geometry.createRightTriangle(d, d2, false);
    }

    public static final Triangle createRightTriangle(double d, double d2, boolean bl) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidWidth"));
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidHeight"));
        }
        Vector2 vector2 = new Vector2(0.0, d2);
        Vector2 vector22 = new Vector2(0.0, 0.0);
        Vector2 vector23 = new Vector2(bl ? -d : d, 0.0);
        Triangle triangle = bl ? new Triangle(vector2, vector23, vector22) : new Triangle(vector2, vector22, vector23);
        Vector2 vector24 = triangle.getCenter();
        triangle.translate(-vector24.x, -vector24.y);
        return triangle;
    }

    public static final Triangle createEquilateralTriangle(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidSize"));
        }
        double d2 = 2.0 * d * INV_SQRT_3;
        return Geometry.createIsoscelesTriangle(d2, d);
    }

    public static final Triangle createIsoscelesTriangle(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidWidth"));
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidHeight"));
        }
        Vector2 vector2 = new Vector2(0.0, d2);
        Vector2 vector22 = new Vector2(-d * 0.5, 0.0);
        Vector2 vector23 = new Vector2(d * 0.5, 0.0);
        Triangle triangle = new Triangle(vector2, vector22, vector23);
        Vector2 vector24 = triangle.getCenter();
        triangle.translate(-vector24.x, -vector24.y);
        return triangle;
    }

    public static final Segment createSegment(Vector2 vector2, Vector2 vector22) {
        if (vector2 == null || vector22 == null) {
            throw new NullPointerException(Messages.getString("geometry.nullSegmentPoint"));
        }
        return new Segment(vector2.copy(), vector22.copy());
    }

    public static final Segment createSegmentAtOrigin(Vector2 vector2, Vector2 vector22) {
        Segment segment = Geometry.createSegment(vector2, vector22);
        Vector2 vector23 = segment.getCenter();
        segment.translate(-vector23.x, -vector23.y);
        return segment;
    }

    public static final Segment createSegment(Vector2 vector2) {
        return Geometry.createSegment(new Vector2(), vector2);
    }

    public static final Segment createHorizontalSegment(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidLength"));
        }
        Vector2 vector2 = new Vector2(-d * 0.5, 0.0);
        Vector2 vector22 = new Vector2(d * 0.5, 0.0);
        return new Segment(vector2, vector22);
    }

    public static final Segment createVerticalSegment(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidLength"));
        }
        Vector2 vector2 = new Vector2(0.0, -d * 0.5);
        Vector2 vector22 = new Vector2(0.0, d * 0.5);
        return new Segment(vector2, vector22);
    }

    public static final Capsule createCapsule(double d, double d2) {
        return new Capsule(d, d2);
    }

    public static final Slice createSlice(double d, double d2) {
        return new Slice(d, d2);
    }

    public static final Slice createSliceAtOrigin(double d, double d2) {
        Slice slice = new Slice(d, d2);
        slice.translate(-slice.center.x, -slice.center.y);
        return slice;
    }

    public static final Ellipse createEllipse(double d, double d2) {
        return new Ellipse(d, d2);
    }

    public static final HalfEllipse createHalfEllipse(double d, double d2) {
        return new HalfEllipse(d, d2);
    }

    public static final HalfEllipse createHalfEllipseAtOrigin(double d, double d2) {
        HalfEllipse halfEllipse = new HalfEllipse(d, d2);
        Vector2 vector2 = halfEllipse.getCenter();
        halfEllipse.translate(-vector2.x, -vector2.y);
        return halfEllipse;
    }

    public static final Polygon createPolygonalCircle(int n, double d) {
        return Geometry.createPolygonalCircle(n, d, 0.0);
    }

    public static final Polygon createPolygonalCircle(int n, double d, double d2) {
        if (n < 3) {
            throw new IllegalArgumentException(Messages.getString("geometry.circleInvalidCount"));
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.circleInvalidRadius"));
        }
        double d3 = Math.PI * 2 / (double)n;
        Vector2[] vector2Array = new Vector2[n];
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        double d6 = 0.0;
        double d7 = d;
        double d8 = 0.0;
        if (d2 != 0.0) {
            d7 = d * Math.cos(d2);
            d8 = d * Math.sin(d2);
        }
        for (int i = 0; i < n; ++i) {
            vector2Array[i] = new Vector2(d7, d8);
            d6 = d7;
            d7 = d4 * d7 - d5 * d8;
            d8 = d5 * d6 + d4 * d8;
        }
        return new Polygon(vector2Array);
    }

    public static final Polygon createPolygonalSlice(int n, double d, double d2) {
        if (n < 1) {
            throw new IllegalArgumentException(Messages.getString("geometry.sliceInvalidCount"));
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.sliceInvalidRadius"));
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.sliceInvalidTheta"));
        }
        double d3 = d2 / (double)(n + 1);
        Vector2[] vector2Array = new Vector2[n + 3];
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        double d6 = 0.0;
        double d7 = d * Math.cos(-d2 * 0.5);
        double d8 = d * Math.sin(-d2 * 0.5);
        vector2Array[0] = new Vector2(d7, d8);
        vector2Array[n + 1] = new Vector2(d7, -d8);
        for (int i = 1; i < n + 1; ++i) {
            d6 = d7;
            d7 = d4 * d7 - d5 * d8;
            d8 = d5 * d6 + d4 * d8;
            vector2Array[i] = new Vector2(d7, d8);
        }
        vector2Array[n + 2] = new Vector2();
        return new Polygon(vector2Array);
    }

    public static final Polygon createPolygonalSliceAtOrigin(int n, double d, double d2) {
        Polygon polygon = Geometry.createPolygonalSlice(n, d, d2);
        Vector2 vector2 = polygon.getCenter();
        polygon.translate(-vector2.x, -vector2.y);
        return polygon;
    }

    public static final Polygon createPolygonalEllipse(int n, double d, double d2) {
        if (n < 4) {
            throw new IllegalArgumentException(Messages.getString("geometry.ellipseInvalidCount"));
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.ellipseInvalidWidth"));
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.ellipseInvalidHeight"));
        }
        double d3 = d * 0.5;
        double d4 = d2 * 0.5;
        int n2 = n / 2;
        double d5 = Math.PI / (double)n2;
        Vector2[] vector2Array = new Vector2[n2 * 2];
        int n3 = 0;
        for (int i = 0; i < n2 + 1; ++i) {
            double d6 = d5 * (double)i;
            double d7 = d3 * Math.cos(d6);
            double d8 = d4 * Math.sin(d6);
            if (i > 0) {
                vector2Array[vector2Array.length - n3] = new Vector2(d7, -d8);
            }
            vector2Array[n3++] = new Vector2(d7, d8);
        }
        return new Polygon(vector2Array);
    }

    public static final Polygon createPolygonalHalfEllipse(int n, double d, double d2) {
        if (n < 1) {
            throw new IllegalArgumentException(Messages.getString("geometry.halfEllipseInvalidCount"));
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.halfEllipseInvalidWidth"));
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.halfEllipseInvalidHeight"));
        }
        double d3 = d * 0.5;
        double d4 = d2 * 0.5;
        double d5 = Math.PI / (double)(n + 1);
        Vector2[] vector2Array = new Vector2[n + 2];
        vector2Array[0] = new Vector2(d3, 0.0);
        vector2Array[n + 1] = new Vector2(-d3, 0.0);
        for (int i = 1; i < n + 1; ++i) {
            double d6 = d5 * (double)i;
            double d7 = d3 * Math.cos(d6);
            double d8 = d4 * Math.sin(d6);
            vector2Array[i] = new Vector2(d7, d8);
        }
        return new Polygon(vector2Array);
    }

    public static final Polygon createPolygonalHalfEllipseAtOrigin(int n, double d, double d2) {
        Polygon polygon = Geometry.createPolygonalHalfEllipse(n, d, d2);
        Vector2 vector2 = polygon.getCenter();
        polygon.translate(-vector2.x, -vector2.y);
        return polygon;
    }

    public static final Polygon createPolygonalCapsule(int n, double d, double d2) {
        int n2;
        if (n < 1) {
            throw new IllegalArgumentException(Messages.getString("geometry.capsuleInvalidCount"));
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.capsuleInvalidWidth"));
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.capsuleInvalidHeight"));
        }
        if (Math.abs(d - d2) < Epsilon.E) {
            return Geometry.createPolygonalCircle(n, d);
        }
        double d3 = Math.PI / (double)(n + 1);
        Vector2[] vector2Array = new Vector2[4 + 2 * n];
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        double d6 = 0.0;
        double d7 = d;
        double d8 = d2;
        boolean bl = false;
        if (d < d2) {
            d7 = d2;
            d8 = d;
            bl = true;
        }
        double d9 = d8 * 0.5;
        double d10 = d7 * 0.5 - d9;
        double d11 = 0.0;
        double d12 = 0.0;
        if (bl) {
            d12 = d10;
        } else {
            d11 = d10;
        }
        int n3 = 0;
        double d13 = bl ? 0.0 : 1.5707963267948966;
        double d14 = d9 * Math.cos(d3 - d13);
        double d15 = d9 * Math.sin(d3 - d13);
        for (n2 = 0; n2 < n; ++n2) {
            vector2Array[n3++] = new Vector2(d14 + d11, d15 + d12);
            d6 = d14;
            d14 = d4 * d14 - d5 * d15;
            d15 = d5 * d6 + d4 * d15;
        }
        if (bl) {
            vector2Array[n3++] = new Vector2(-d9, d12);
            vector2Array[n3++] = new Vector2(-d9, -d12);
        } else {
            vector2Array[n3++] = new Vector2(d11, d9);
            vector2Array[n3++] = new Vector2(-d11, d9);
        }
        d13 = bl ? Math.PI : 1.5707963267948966;
        d14 = d9 * Math.cos(d3 + d13);
        d15 = d9 * Math.sin(d3 + d13);
        for (n2 = 0; n2 < n; ++n2) {
            vector2Array[n3++] = new Vector2(d14 - d11, d15 - d12);
            d6 = d14;
            d14 = d4 * d14 - d5 * d15;
            d15 = d5 * d6 + d4 * d15;
        }
        if (bl) {
            vector2Array[n3++] = new Vector2(d9, -d12);
            vector2Array[n3++] = new Vector2(d9, d12);
        } else {
            vector2Array[n3++] = new Vector2(-d11, -d9);
            vector2Array[n3++] = new Vector2(d11, -d9);
        }
        return new Polygon(vector2Array);
    }

    public static final List<Vector2> cleanse(List<Vector2> list) {
        if (list == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointList"));
        }
        int n = list.size();
        if (n == 0) {
            return list;
        }
        ArrayList<Vector2> arrayList = new ArrayList<Vector2>(n);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2;
            Vector2 vector2 = list.get(i);
            Vector2 vector22 = list.get(i - 1 < 0 ? n - 1 : i - 1);
            Vector2 vector23 = list.get(i + 1 == n ? 0 : i + 1);
            if (vector2 == null || vector22 == null || vector23 == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointListElements"));
            }
            Vector2 vector24 = vector2.difference(vector23);
            if (vector24.isZero()) continue;
            Vector2 vector25 = vector22.to(vector2);
            Vector2 vector26 = vector2.to(vector23);
            if (!vector25.isZero() && Math.abs(d2 = vector25.cross(vector26)) <= Epsilon.E) continue;
            d += vector2.cross(vector23);
            arrayList.add(vector2);
        }
        if (d < 0.0) {
            Geometry.reverseWinding(arrayList);
        }
        return arrayList;
    }

    public static final Vector2[] cleanse(Vector2 ... vector2Array) {
        if (vector2Array == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointArray"));
        }
        List<Vector2> list = Arrays.asList(vector2Array);
        List<Vector2> list2 = Geometry.cleanse(list);
        Vector2[] vector2Array2 = new Vector2[list2.size()];
        list2.toArray(vector2Array2);
        return vector2Array2;
    }

    public static final Polygon flipAlongTheXAxis(Polygon polygon) {
        return Geometry.flip(polygon, Vector2.X_AXIS, null);
    }

    public static final Polygon flipAlongTheYAxis(Polygon polygon) {
        return Geometry.flip(polygon, Vector2.Y_AXIS, null);
    }

    public static final Polygon flipAlongTheXAxis(Polygon polygon, Vector2 vector2) {
        return Geometry.flip(polygon, Vector2.X_AXIS, vector2);
    }

    public static final Polygon flipAlongTheYAxis(Polygon polygon, Vector2 vector2) {
        return Geometry.flip(polygon, Vector2.Y_AXIS, vector2);
    }

    public static final Polygon flip(Polygon polygon, Vector2 vector2) {
        return Geometry.flip(polygon, vector2, null);
    }

    public static final Polygon flip(Polygon polygon, Vector2 vector2, Vector2 vector22) {
        if (polygon == null) {
            throw new NullPointerException(Messages.getString("geometry.nullFlipPolygon"));
        }
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("geometry.nullFlipAxis"));
        }
        if (vector2.isZero()) {
            throw new IllegalArgumentException(Messages.getString("geometry.zeroFlipAxis"));
        }
        if (vector22 == null) {
            vector22 = polygon.getCenter();
        }
        vector2.normalize();
        Vector2[] vector2Array = polygon.getVertices();
        Vector2[] vector2Array2 = new Vector2[vector2Array.length];
        for (int i = 0; i < vector2Array.length; ++i) {
            Vector2 vector23 = vector2Array[i];
            Vector2 vector24 = vector23.difference(vector22);
            double d = vector24.dot(vector2);
            Vector2 vector25 = vector2.product(d);
            Vector2 vector26 = vector25.add(vector25.x - vector24.x, vector25.y - vector24.y);
            vector2Array2[i] = vector26.add(vector22);
        }
        if (Geometry.getWinding(vector2Array2) < 0.0) {
            Geometry.reverseWinding(vector2Array2);
        }
        return new Polygon(vector2Array2);
    }

    public static final <E extends Wound> Polygon minkowskiSum(E e, E e2) {
        Object object;
        int n;
        Object object2;
        Object object3;
        if (e == null) {
            throw new NullPointerException(Messages.getString("geometry.nullMinkowskiSumConvex"));
        }
        if (e2 == null) {
            throw new NullPointerException(Messages.getString("geometry.nullMinkowskiSumConvex"));
        }
        if (e instanceof Segment && e2 instanceof Segment && ((Vector2)(object3 = e.vertices[0].to(e.vertices[1]))).cross((Vector2)(object2 = e2.vertices[0].to(e2.vertices[1]))) <= Epsilon.E) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidMinkowskiSumSegments"));
        }
        object3 = e.vertices;
        object2 = e2.vertices;
        int n2 = ((Vector2[])object3).length;
        int n3 = ((Vector2[])object2).length;
        int n4 = 0;
        int n5 = 0;
        Vector2 vector2 = new Vector2(Double.MAX_VALUE, Double.MAX_VALUE);
        for (n = 0; n < n2; ++n) {
            object = object3[n];
            if (((Vector2)object).y < vector2.y) {
                vector2.set((Vector2)object);
                n4 = n;
                continue;
            }
            if (((Vector2)object).y != vector2.y || !(((Vector2)object).x < vector2.x)) continue;
            vector2.set((Vector2)object);
            n4 = n;
        }
        vector2.set(Double.MAX_VALUE, Double.MAX_VALUE);
        for (n = 0; n < n3; ++n) {
            object = object2[n];
            if (((Vector2)object).y < vector2.y) {
                vector2.set((Vector2)object);
                n5 = n;
                continue;
            }
            if (((Vector2)object).y != vector2.y || !(((Vector2)object).x < vector2.x)) continue;
            vector2.set((Vector2)object);
            n5 = n;
        }
        n = n2 + n4;
        int n6 = n3 + n5;
        ArrayList<Vector2> arrayList = new ArrayList<Vector2>(n2 + n3);
        while (n4 <= n && n5 <= n6) {
            Object object4 = object3[n4 % n2];
            Object object5 = object3[(n4 + 1) % n2];
            Vector2 vector22 = object2[n5 % n3];
            Vector2 vector23 = object2[(n5 + 1) % n3];
            arrayList.add(((Vector2)object4).sum(vector22));
            Vector2 vector24 = ((Vector2)object4).to((Vector2)object5);
            Vector2 vector25 = vector22.to(vector23);
            double d = Vector2.X_AXIS.getAngleBetween(vector24);
            double d2 = Vector2.X_AXIS.getAngleBetween(vector25);
            if (d < 0.0) {
                d += Math.PI * 2;
            }
            if (d2 < 0.0) {
                d2 += Math.PI * 2;
            }
            if (d < d2) {
                ++n4;
                continue;
            }
            if (d > d2) {
                ++n5;
                continue;
            }
            ++n4;
            ++n5;
        }
        return new Polygon(arrayList.toArray(new Vector2[0]));
    }

    public static final Polygon minkowskiSum(Circle circle, Polygon polygon, int n) {
        return Geometry.minkowskiSum(polygon, circle, n);
    }

    public static final Polygon minkowskiSum(Polygon polygon, Circle circle, int n) {
        if (circle == null) {
            throw new NullPointerException(Messages.getString("geometry.nullMinkowskiSumCircle"));
        }
        return Geometry.minkowskiSum(polygon, circle.radius, n);
    }

    public static final Polygon minkowskiSum(Polygon polygon, double d, int n) {
        if (polygon == null) {
            throw new NullPointerException(Messages.getString("geometry.nullMinkowskiSumPolygon"));
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidMinkowskiSumRadius"));
        }
        if (n <= 0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidMinkowskiSumCount"));
        }
        Vector2[] vector2Array = polygon.vertices;
        Vector2[] vector2Array2 = polygon.normals;
        int n2 = vector2Array.length;
        Vector2[] vector2Array3 = new Vector2[n2 * 2 + n2 * n];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Vector2 vector2;
            Vector2 vector22 = vector2Array[i];
            Vector2 vector23 = vector2Array[i + 1 == n2 ? 0 : i + 1];
            Vector2 vector24 = vector2Array2[i];
            Vector2 vector25 = vector24.product(d).add(vector22);
            Vector2 vector26 = vector24.product(d).add(vector23);
            Vector2 vector27 = null;
            if (i == 0) {
                vector2 = vector2Array2[n2 - 1];
                vector27 = vector22.to(vector2.product(d).add(vector22));
            } else {
                vector27 = vector22.to(vector2Array3[n3 - 1]);
            }
            vector2 = vector22.to(vector25);
            double d2 = vector27.getAngleBetween(vector2);
            double d3 = d2 / (double)(n + 1);
            double d4 = Math.cos(d3);
            double d5 = Math.sin(d3);
            double d6 = 0.0;
            double d7 = Vector2.X_AXIS.getAngleBetween(vector2Array2[i - 1 < 0 ? n2 - 1 : i - 1]);
            if (d7 < 0.0) {
                d7 += Math.PI * 2;
            }
            double d8 = d * Math.cos(d7);
            double d9 = d * Math.sin(d7);
            for (int j = 0; j < n; ++j) {
                d6 = d8;
                d8 = d4 * d8 - d5 * d9;
                d9 = d5 * d6 + d4 * d9;
                vector2Array3[n3++] = new Vector2(d8, d9).add(vector22);
            }
            vector2Array3[n3++] = vector25;
            vector2Array3[n3++] = vector26;
        }
        return new Polygon(vector2Array3);
    }

    public static final Circle scale(Circle circle, double d) {
        if (circle == null) {
            throw new NullPointerException(Messages.getString("geometry.nullShape"));
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidScale"));
        }
        return new Circle(circle.radius * d);
    }

    public static final Capsule scale(Capsule capsule, double d) {
        if (capsule == null) {
            throw new NullPointerException(Messages.getString("geometry.nullShape"));
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidScale"));
        }
        return new Capsule(capsule.length * d, capsule.capRadius * 2.0 * d);
    }

    public static final Ellipse scale(Ellipse ellipse, double d) {
        if (ellipse == null) {
            throw new NullPointerException(Messages.getString("geometry.nullShape"));
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidScale"));
        }
        return new Ellipse(ellipse.width * d, ellipse.height * d);
    }

    public static final HalfEllipse scale(HalfEllipse halfEllipse, double d) {
        if (halfEllipse == null) {
            throw new NullPointerException(Messages.getString("geometry.nullShape"));
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidScale"));
        }
        return new HalfEllipse(halfEllipse.width * d, halfEllipse.height * d);
    }

    public static final Slice scale(Slice slice, double d) {
        if (slice == null) {
            throw new NullPointerException(Messages.getString("geometry.nullShape"));
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidScale"));
        }
        return new Slice(slice.sliceRadius * d, slice.theta);
    }

    public static final Polygon scale(Polygon polygon, double d) {
        if (polygon == null) {
            throw new NullPointerException(Messages.getString("geometry.nullShape"));
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidScale"));
        }
        Vector2[] vector2Array = polygon.vertices;
        int n = vector2Array.length;
        Vector2[] vector2Array2 = new Vector2[n];
        Vector2 vector2 = polygon.center;
        for (int i = 0; i < n; ++i) {
            vector2Array2[i] = vector2.to(vector2Array[i]).multiply(d).add(vector2);
        }
        return new Polygon(vector2Array2);
    }

    public static final Segment scale(Segment segment, double d) {
        if (segment == null) {
            throw new NullPointerException(Messages.getString("geometry.nullShape"));
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidScale"));
        }
        double d2 = segment.getLength() * d * 0.5;
        Vector2 vector2 = segment.vertices[0].to(segment.vertices[1]);
        vector2.normalize();
        vector2.multiply(d2);
        return new Segment(segment.center.sum(vector2.x, vector2.y), segment.center.difference(vector2.x, vector2.y));
    }
}

