/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.resources.Messages;

public class Interval {
    protected double min;
    protected double max;

    public Interval(double d, double d2) {
        if (d > d2) {
            throw new IllegalArgumentException(Messages.getString("geometry.interval.invalid"));
        }
        this.min = d;
        this.max = d2;
    }

    public Interval(Interval interval) {
        this.min = interval.min;
        this.max = interval.max;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(this.min).append(", ").append(this.max).append("]");
        return stringBuilder.toString();
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMin(double d) {
        if (d > this.max) {
            throw new IllegalArgumentException(Messages.getString("geometry.interval.invalidMinimum"));
        }
        this.min = d;
    }

    public void setMax(double d) {
        if (d < this.min) {
            throw new IllegalArgumentException(Messages.getString("geometry.interval.invalidMaximum"));
        }
        this.max = d;
    }

    public boolean includesInclusive(double d) {
        return d <= this.max && d >= this.min;
    }

    public boolean includesExclusive(double d) {
        return d < this.max && d > this.min;
    }

    public boolean includesInclusiveMin(double d) {
        return d < this.max && d >= this.min;
    }

    public boolean includesInclusiveMax(double d) {
        return d <= this.max && d > this.min;
    }

    public boolean overlaps(Interval interval) {
        return !(this.min > interval.max) && !(interval.min > this.max);
    }

    public double getOverlap(Interval interval) {
        if (this.overlaps(interval)) {
            return Math.min(this.max, interval.max) - Math.max(this.min, interval.min);
        }
        return 0.0;
    }

    public double clamp(double d) {
        return Interval.clamp(d, this.min, this.max);
    }

    public static double clamp(double d, double d2, double d3) {
        if (d <= d3 && d >= d2) {
            return d;
        }
        if (d3 < d) {
            return d3;
        }
        return d2;
    }

    public boolean isDegenerate() {
        return this.min == this.max;
    }

    public boolean isDegenerate(double d) {
        return Math.abs(this.max - this.min) <= d;
    }

    public boolean contains(Interval interval) {
        return interval.min > this.min && interval.max < this.max;
    }

    public void union(Interval interval) {
        this.min = Math.min(interval.min, this.min);
        this.max = Math.max(interval.max, this.max);
    }

    public Interval getUnion(Interval interval) {
        return new Interval(Math.min(interval.min, this.min), Math.max(interval.max, this.max));
    }

    public void intersection(Interval interval) {
        if (this.overlaps(interval)) {
            this.min = Math.max(interval.min, this.min);
            this.max = Math.min(interval.max, this.max);
        } else {
            this.min = 0.0;
            this.max = 0.0;
        }
    }

    public Interval getIntersection(Interval interval) {
        if (this.overlaps(interval)) {
            return new Interval(Math.max(interval.min, this.min), Math.min(interval.max, this.max));
        }
        return new Interval(0.0, 0.0);
    }

    public double distance(Interval interval) {
        if (!this.overlaps(interval)) {
            if (this.max < interval.min) {
                return interval.min - this.max;
            }
            return this.min - interval.max;
        }
        return 0.0;
    }

    public void expand(double d) {
        double d2 = d * 0.5;
        this.min -= d2;
        this.max += d2;
        if (d < 0.0 && this.min > this.max) {
            double d3;
            this.min = d3 = (this.min + this.max) * 0.5;
            this.max = d3;
        }
    }

    public Interval getExpanded(double d) {
        double d2 = d * 0.5;
        double d3 = this.min - d2;
        double d4 = this.max + d2;
        if (d < 0.0 && d3 > d4) {
            double d5;
            d3 = d5 = (d3 + d4) * 0.5;
            d4 = d5;
        }
        return new Interval(d3, d4);
    }

    public double getLength() {
        return this.max - this.min;
    }
}

