/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.Epsilon;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Matrix22 {
    public double m00;
    public double m01;
    public double m10;
    public double m11;

    public Matrix22() {
    }

    public Matrix22(double d, double d2, double d3, double d4) {
        this.m00 = d;
        this.m01 = d2;
        this.m10 = d3;
        this.m11 = d4;
    }

    public Matrix22(double[] dArray) {
        if (dArray == null) {
            throw new NullPointerException(Messages.getString("geometry.matrix.nullArray"));
        }
        if (dArray.length != 4) {
            throw new IndexOutOfBoundsException(Messages.getString("geometry.matrix.invalidLength4"));
        }
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m10 = dArray[2];
        this.m11 = dArray[3];
    }

    public Matrix22(Matrix22 matrix22) {
        this.m00 = matrix22.m00;
        this.m01 = matrix22.m01;
        this.m10 = matrix22.m10;
        this.m11 = matrix22.m11;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.m00);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m01);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m10);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m11);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Matrix22) {
            Matrix22 matrix22 = (Matrix22)object;
            if (matrix22.m00 == this.m00 && matrix22.m01 == this.m01 && matrix22.m10 == this.m10 && matrix22.m11 == this.m11) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(this.m00).append(" ").append(this.m01).append("][").append(this.m10).append(" ").append(this.m11).append("]");
        return stringBuilder.toString();
    }

    public Matrix22 add(Matrix22 matrix22) {
        this.m00 += matrix22.m00;
        this.m01 += matrix22.m01;
        this.m10 += matrix22.m10;
        this.m11 += matrix22.m11;
        return this;
    }

    public Matrix22 sum(Matrix22 matrix22) {
        Matrix22 matrix222 = new Matrix22(this);
        matrix222.m00 += matrix22.m00;
        matrix222.m01 += matrix22.m01;
        matrix222.m10 += matrix22.m10;
        matrix222.m11 += matrix22.m11;
        return matrix222;
    }

    public Matrix22 subtract(Matrix22 matrix22) {
        this.m00 -= matrix22.m00;
        this.m01 -= matrix22.m01;
        this.m10 -= matrix22.m10;
        this.m11 -= matrix22.m11;
        return this;
    }

    public Matrix22 difference(Matrix22 matrix22) {
        Matrix22 matrix222 = new Matrix22(this);
        matrix222.m00 -= matrix22.m00;
        matrix222.m01 -= matrix22.m01;
        matrix222.m10 -= matrix22.m10;
        matrix222.m11 -= matrix22.m11;
        return matrix222;
    }

    public Matrix22 multiply(Matrix22 matrix22) {
        double d = this.m00;
        double d2 = this.m01;
        double d3 = this.m10;
        double d4 = this.m11;
        this.m00 = d * matrix22.m00 + d2 * matrix22.m10;
        this.m01 = d * matrix22.m01 + d2 * matrix22.m11;
        this.m10 = d3 * matrix22.m00 + d4 * matrix22.m10;
        this.m11 = d3 * matrix22.m01 + d4 * matrix22.m11;
        return this;
    }

    public Matrix22 product(Matrix22 matrix22) {
        Matrix22 matrix222 = new Matrix22();
        matrix222.m00 = this.m00 * matrix22.m00 + this.m01 * matrix22.m10;
        matrix222.m01 = this.m00 * matrix22.m01 + this.m01 * matrix22.m11;
        matrix222.m10 = this.m10 * matrix22.m00 + this.m11 * matrix22.m10;
        matrix222.m11 = this.m10 * matrix22.m01 + this.m11 * matrix22.m11;
        return matrix222;
    }

    public Vector2 multiply(Vector2 vector2) {
        double d = vector2.x;
        double d2 = vector2.y;
        vector2.x = this.m00 * d + this.m01 * d2;
        vector2.y = this.m10 * d + this.m11 * d2;
        return vector2;
    }

    public Vector2 product(Vector2 vector2) {
        Vector2 vector22 = new Vector2();
        vector22.x = this.m00 * vector2.x + this.m01 * vector2.y;
        vector22.y = this.m10 * vector2.x + this.m11 * vector2.y;
        return vector22;
    }

    public Vector2 multiplyT(Vector2 vector2) {
        double d = vector2.x;
        double d2 = vector2.y;
        vector2.x = this.m00 * d + this.m10 * d2;
        vector2.y = this.m01 * d + this.m11 * d2;
        return vector2;
    }

    public Vector2 productT(Vector2 vector2) {
        Vector2 vector22 = new Vector2();
        vector22.x = this.m00 * vector2.x + this.m10 * vector2.y;
        vector22.y = this.m01 * vector2.x + this.m11 * vector2.y;
        return vector22;
    }

    public Matrix22 multiply(double d) {
        this.m00 *= d;
        this.m01 *= d;
        this.m10 *= d;
        this.m11 *= d;
        return this;
    }

    public Matrix22 product(double d) {
        Matrix22 matrix22 = new Matrix22(this);
        matrix22.m00 *= d;
        matrix22.m01 *= d;
        matrix22.m10 *= d;
        matrix22.m11 *= d;
        return matrix22;
    }

    public Matrix22 identity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        return this;
    }

    public Matrix22 transpose() {
        double d = this.m01;
        this.m01 = this.m10;
        this.m10 = d;
        return this;
    }

    public Matrix22 getTranspose() {
        Matrix22 matrix22 = new Matrix22(this);
        matrix22.transpose();
        return matrix22;
    }

    public double determinant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public Matrix22 invert() {
        double d = this.determinant();
        if (Math.abs(d) > Epsilon.E) {
            d = 1.0 / d;
        }
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m10;
        double d5 = this.m11;
        this.m00 = d * d5;
        this.m01 = -d * d3;
        this.m10 = -d * d4;
        this.m11 = d * d2;
        return this;
    }

    public Matrix22 getInverse() {
        double d = this.determinant();
        if (Math.abs(d) > Epsilon.E) {
            d = 1.0 / d;
        }
        Matrix22 matrix22 = new Matrix22();
        matrix22.m00 = d * this.m11;
        matrix22.m01 = -d * this.m01;
        matrix22.m10 = -d * this.m10;
        matrix22.m11 = d * this.m00;
        return matrix22;
    }

    public Vector2 solve(Vector2 vector2) {
        double d = this.determinant();
        if (Math.abs(d) > Epsilon.E) {
            d = 1.0 / d;
        }
        Vector2 vector22 = new Vector2();
        vector22.x = d * (this.m11 * vector2.x - this.m01 * vector2.y);
        vector22.y = d * (this.m00 * vector2.y - this.m10 * vector2.x);
        return vector22;
    }
}

