/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.Epsilon;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Edge;
import org.dyn4j.geometry.Geometry;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Vertex;
import org.dyn4j.geometry.Wound;
import org.dyn4j.resources.Messages;

public class Polygon
extends Wound
implements Convex,
Shape,
Transformable {
    private static final double INV3 = 0.3333333333333333;

    protected Polygon() {
    }

    public Polygon(Vector2 ... vector2Array) {
        Vector2 vector2;
        Vector2 vector22;
        Vector2 vector23;
        int n;
        if (vector2Array == null) {
            throw new NullPointerException(Messages.getString("geometry.polygon.nullArray"));
        }
        int n2 = vector2Array.length;
        if (n2 < 3) {
            throw new IllegalArgumentException(Messages.getString("geometry.polygon.lessThan3Vertices"));
        }
        for (int i = 0; i < n2; ++i) {
            if (vector2Array[i] != null) continue;
            throw new NullPointerException(Messages.getString("geometry.polygon.nullVertices"));
        }
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < n2; ++n) {
            vector23 = n - 1 < 0 ? vector2Array[n2 - 1] : vector2Array[n - 1];
            vector22 = vector2Array[n];
            Vector2 vector24 = vector2 = n + 1 == n2 ? vector2Array[0] : vector2Array[n + 1];
            if (vector22.equals(vector2)) {
                throw new IllegalArgumentException(Messages.getString("geometry.polygon.coincidentVertices"));
            }
            double d3 = vector23.to(vector22).cross(vector22.to(vector2));
            double d4 = Math.signum(d3);
            d += d3;
            if (Math.abs(d3) > Epsilon.E && d2 != 0.0 && d4 != d2) {
                throw new IllegalArgumentException(Messages.getString("geometry.polygon.nonConvex"));
            }
            d2 = d4;
        }
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.polygon.invalidWinding"));
        }
        this.vertices = vector2Array;
        this.normals = new Vector2[n2];
        for (n = 0; n < n2; ++n) {
            vector23 = vector2Array[n];
            vector22 = n + 1 == n2 ? vector2Array[0] : vector2Array[n + 1];
            vector2 = vector23.to(vector22).left();
            vector2.normalize();
            this.normals[n] = vector2;
        }
        this.center = Geometry.getAreaWeightedCenter(this.vertices);
        double d5 = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d6 = this.center.distanceSquared(vector2Array[i]);
            d5 = Math.max(d5, d6);
        }
        this.radius = Math.sqrt(d5);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Polygon[").append(super.toString()).append("|UserData=").append(this.userData).append("]");
        return stringBuilder.toString();
    }

    @Override
    public Vector2[] getAxes(Vector2[] vector2Array, Transform transform) {
        Vector2 vector2;
        int n;
        int n2 = vector2Array != null ? vector2Array.length : 0;
        int n3 = this.vertices.length;
        Vector2[] vector2Array2 = new Vector2[n3 + n2];
        int n4 = 0;
        for (n = 0; n < n3; ++n) {
            vector2 = this.normals[n];
            vector2Array2[n4++] = transform.getTransformedR(vector2);
        }
        for (n = 0; n < n2; ++n) {
            vector2 = vector2Array[n];
            Vector2 vector22 = transform.getTransformed(this.vertices[0]);
            double d = vector2.distanceSquared(vector22);
            for (int i = 1; i < n3; ++i) {
                Vector2 vector23 = this.vertices[i];
                double d2 = vector2.distanceSquared(vector23 = transform.getTransformed(vector23));
                if (!(d2 < d)) continue;
                vector22 = vector23;
                d = d2;
            }
            Vector2 vector24 = vector2.to(vector22);
            vector24.normalize();
            vector2Array2[n4++] = vector24;
        }
        return vector2Array2;
    }

    @Override
    public Vector2[] getFoci(Transform transform) {
        return null;
    }

    @Override
    public boolean contains(Vector2 vector2, Transform transform) {
        Vector2 vector22 = transform.getInverseTransformed(vector2);
        Vector2 vector23 = this.vertices[0];
        Vector2 vector24 = this.vertices[1];
        double d = Segment.getLocation(vector22, vector23, vector24);
        int n = this.vertices.length;
        for (int i = 1; i < n; ++i) {
            vector23 = vector24;
            vector24 = this.vertices[i + 1 == n ? 0 : i + 1];
            if (vector22.equals(vector23)) {
                return true;
            }
            if (!(d * Segment.getLocation(vector22, vector23, vector24) < 0.0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        super.rotate(d, d2, d3);
        int n = this.vertices.length;
        for (int i = 0; i < n; ++i) {
            this.vertices[i].rotate(d, d2, d3);
            this.normals[i].rotate(d, d2, d3);
        }
    }

    @Override
    public void translate(double d, double d2) {
        super.translate(d, d2);
        int n = this.vertices.length;
        for (int i = 0; i < n; ++i) {
            this.vertices[i].add(d, d2);
        }
    }

    @Override
    public Interval project(Vector2 vector2, Transform transform) {
        double d;
        double d2 = 0.0;
        Vector2 vector22 = transform.getTransformed(this.vertices[0]);
        double d3 = d = vector2.dot(vector22);
        int n = this.vertices.length;
        for (int i = 1; i < n; ++i) {
            vector22 = transform.getTransformed(this.vertices[i]);
            d2 = vector2.dot(vector22);
            if (d2 < d) {
                d = d2;
                continue;
            }
            if (!(d2 > d3)) continue;
            d3 = d2;
        }
        return new Interval(d, d3);
    }

    @Override
    public Edge getFarthestFeature(Vector2 vector2, Transform transform) {
        int n;
        Vector2 vector22 = transform.getInverseTransformedR(vector2);
        Vector2 vector23 = new Vector2();
        double d = -1.7976931348623157E308;
        int n2 = 0;
        int n3 = this.vertices.length;
        for (n = 0; n < n3; ++n) {
            Vector2 vector24 = this.vertices[n];
            double d2 = vector22.dot(vector24);
            if (!(d2 > d)) continue;
            vector23.set(vector24);
            d = d2;
            n2 = n;
        }
        n = n2 + 1 == n3 ? 0 : n2 + 1;
        int n4 = n2 - 1 < 0 ? n3 - 1 : n2 - 1;
        Vector2 vector25 = this.normals[n2 == 0 ? n3 - 1 : n2 - 1];
        Vector2 vector26 = this.normals[n2];
        transform.transform(vector23);
        Vertex vertex = new Vertex(vector23, n2);
        if (vector25.dot(vector22) < vector26.dot(vector22)) {
            Vector2 vector27 = transform.getTransformed(this.vertices[n]);
            Vertex vertex2 = new Vertex(vector27, n);
            return new Edge(vertex, vertex2, vertex, vector23.to(vector27), n2 + 1);
        }
        Vector2 vector28 = transform.getTransformed(this.vertices[n4]);
        Vertex vertex3 = new Vertex(vector28, n4);
        return new Edge(vertex3, vertex, vertex, vector28.to(vector23), n2);
    }

    @Override
    public Vector2 getFarthestPoint(Vector2 vector2, Transform transform) {
        Vector2 vector22 = transform.getInverseTransformedR(vector2);
        Vector2 vector23 = new Vector2();
        vector23.set(this.vertices[0]);
        double d = vector22.dot(this.vertices[0]);
        int n = this.vertices.length;
        for (int i = 1; i < n; ++i) {
            Vector2 vector24 = this.vertices[i];
            double d2 = vector22.dot(vector24);
            if (!(d2 > d)) continue;
            vector23.set(vector24);
            d = d2;
        }
        transform.transform(vector23);
        return vector23;
    }

    @Override
    public Mass createMass(double d) {
        Vector2 vector2;
        int n;
        Vector2 vector22 = new Vector2();
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = this.vertices.length;
        Vector2 vector23 = new Vector2();
        for (n = 0; n < n2; ++n) {
            vector23.add(this.vertices[n]);
        }
        vector23.multiply(1.0 / (double)n2);
        for (n = 0; n < n2; ++n) {
            Vector2 vector24 = this.vertices[n];
            vector2 = n + 1 < n2 ? this.vertices[n + 1] : this.vertices[0];
            vector24 = vector24.difference(vector23);
            vector2 = vector2.difference(vector23);
            double d4 = vector24.cross(vector2);
            double d5 = 0.5 * d4;
            d2 += d5;
            vector22.x += (vector24.x + vector2.x) * 0.3333333333333333 * d5;
            vector22.y += (vector24.y + vector2.y) * 0.3333333333333333 * d5;
            d3 += d5 * (vector2.dot(vector2) + vector2.dot(vector24) + vector24.dot(vector24));
        }
        double d6 = d * d2;
        vector22.multiply(1.0 / d2);
        vector2 = vector22.sum(vector23);
        d3 *= d / 6.0;
        return new Mass(vector2, d6, d3 -= d6 * vector22.getMagnitudeSquared());
    }

    @Override
    public AABB createAABB(Transform transform) {
        double d;
        double d2;
        double d3 = 0.0;
        double d4 = 0.0;
        Vector2 vector2 = transform.getTransformed(this.vertices[0]);
        double d5 = d2 = Vector2.X_AXIS.dot(vector2);
        double d6 = d = Vector2.Y_AXIS.dot(vector2);
        int n = this.vertices.length;
        for (int i = 1; i < n; ++i) {
            vector2 = transform.getTransformed(this.vertices[i]);
            d3 = Vector2.X_AXIS.dot(vector2);
            d4 = Vector2.Y_AXIS.dot(vector2);
            d2 = Math.min(d2, d3);
            d5 = Math.max(d5, d3);
            d = Math.min(d, d4);
            d6 = Math.max(d6, d4);
        }
        return new AABB(d2, d, d5, d6);
    }
}

