/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.AbstractShape;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Feature;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Vertex;
import org.dyn4j.resources.Messages;

public class Slice
extends AbstractShape
implements Convex,
Shape,
Transformable {
    protected double theta;
    protected double alpha;
    protected double sliceRadius;
    protected Vector2[] vertices;
    protected Vector2[] normals;
    protected Vector2 localXAxis;

    public Slice(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.slice.invalidRadius"));
        }
        if (d2 <= 0.0 || d2 > Math.PI) {
            throw new IllegalArgumentException(Messages.getString("geometry.slice.invalidTheta"));
        }
        this.sliceRadius = d;
        this.theta = d2;
        this.alpha = d2 * 0.5;
        double d3 = 2.0 * d * Math.sin(this.alpha) / (3.0 * this.alpha);
        this.center = new Vector2(d3, 0.0);
        double d4 = d * Math.cos(this.alpha);
        double d5 = d * Math.sin(this.alpha);
        this.vertices = new Vector2[]{new Vector2(), new Vector2(d4, d5), new Vector2(d4, -d5)};
        Vector2 vector2 = this.vertices[1].to(this.vertices[0]);
        Vector2 vector22 = this.vertices[0].to(this.vertices[2]);
        vector2.left().normalize();
        vector22.left().normalize();
        this.normals = new Vector2[]{vector2, vector22};
        double d6 = this.center.getMagnitudeSquared();
        double d7 = this.center.distanceSquared(this.vertices[1]);
        this.radius = Math.sqrt(Math.max(d6, d7));
        this.localXAxis = new Vector2(1.0, 0.0);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Slice[").append(super.toString()).append("|Radius=").append(this.sliceRadius).append("|Theta=").append(this.theta).append("|UserData=").append(this.userData).append("]");
        return stringBuilder.toString();
    }

    @Override
    public Vector2[] getAxes(Vector2[] vector2Array, Transform transform) {
        int n = vector2Array != null ? vector2Array.length : 0;
        int n2 = this.vertices.length;
        Vector2[] vector2Array2 = new Vector2[2 + n];
        int n3 = 0;
        vector2Array2[n3++] = transform.getTransformedR(this.normals[0]);
        vector2Array2[n3++] = transform.getTransformedR(this.normals[1]);
        Vector2 vector2 = transform.getTransformed(this.vertices[0]);
        for (int i = 0; i < n; ++i) {
            Vector2 vector22 = vector2Array[i];
            Vector2 vector23 = vector2;
            double d = vector22.distanceSquared(vector23);
            for (int j = 1; j < n2; ++j) {
                Vector2 vector24 = this.vertices[j];
                double d2 = vector22.distanceSquared(vector24 = transform.getTransformed(vector24));
                if (!(d2 < d)) continue;
                vector23 = vector24;
                d = d2;
            }
            Vector2 vector25 = vector22.to(vector23);
            vector25.normalize();
            vector2Array2[n3++] = vector25;
        }
        return vector2Array2;
    }

    @Override
    public Vector2[] getFoci(Transform transform) {
        return new Vector2[]{transform.getTransformed(this.vertices[0])};
    }

    @Override
    public Vector2 getFarthestPoint(Vector2 vector2, Transform transform) {
        Vector2 vector22 = transform.getInverseTransformedR(vector2);
        if (Math.abs(vector22.getAngleBetween(this.localXAxis)) > this.alpha) {
            Vector2 vector23 = new Vector2();
            vector23.set(this.vertices[0]);
            double d = vector22.dot(this.vertices[0]);
            int n = this.vertices.length;
            for (int i = 1; i < n; ++i) {
                Vector2 vector24 = this.vertices[i];
                double d2 = vector22.dot(vector24);
                if (!(d2 > d)) continue;
                vector23.set(vector24);
                d = d2;
            }
            transform.transform(vector23);
            return vector23;
        }
        vector22.normalize();
        vector22.multiply(this.sliceRadius).add(this.vertices[0]);
        transform.transform(vector22);
        return vector22;
    }

    @Override
    public Feature getFarthestFeature(Vector2 vector2, Transform transform) {
        Vector2 vector22 = transform.getInverseTransformedR(vector2);
        if (Math.abs(vector22.getAngleBetween(this.localXAxis)) <= this.alpha) {
            Vector2 vector23 = this.getFarthestPoint(vector2, transform);
            return new Vertex(vector23);
        }
        if (Math.PI - this.theta <= 1.0E-6) {
            return Segment.getFarthestFeature(this.vertices[1], this.vertices[2], vector2, transform);
        }
        if (vector22.y > 0.0) {
            return Segment.getFarthestFeature(this.vertices[0], this.vertices[1], vector2, transform);
        }
        if (vector22.y < 0.0) {
            return Segment.getFarthestFeature(this.vertices[0], this.vertices[2], vector2, transform);
        }
        return new Vertex(transform.getTransformed(this.vertices[0]));
    }

    @Override
    public Interval project(Vector2 vector2, Transform transform) {
        Vector2 vector22 = this.getFarthestPoint(vector2, transform);
        Vector2 vector23 = this.getFarthestPoint(vector2.getNegative(), transform);
        double d = vector22.dot(vector2);
        double d2 = vector23.dot(vector2);
        return new Interval(d2, d);
    }

    @Override
    public AABB createAABB(Transform transform) {
        Interval interval = this.project(Vector2.X_AXIS, transform);
        Interval interval2 = this.project(Vector2.Y_AXIS, transform);
        return new AABB(interval.getMin(), interval2.getMin(), interval.getMax(), interval2.getMax());
    }

    @Override
    public Mass createMass(double d) {
        double d2 = this.sliceRadius * this.sliceRadius;
        double d3 = d * d2 * this.alpha;
        double d4 = Math.sin(this.alpha);
        double d5 = 0.05555555555555555 * d2 * d2 * (9.0 * this.alpha * this.alpha - 8.0 * d4 * d4) / this.alpha;
        return new Mass(this.center, d3, d5);
    }

    @Override
    public double getRadius(Vector2 vector2) {
        return this.radius + vector2.distance(this.center);
    }

    @Override
    public boolean contains(Vector2 vector2, Transform transform) {
        Vector2 vector22 = transform.getInverseTransformed(vector2);
        double d = this.sliceRadius * this.sliceRadius;
        Vector2 vector23 = this.vertices[0].to(vector22);
        return vector23.getMagnitudeSquared() <= d && Segment.getLocation(vector22, this.vertices[0], this.vertices[1]) <= 0.0 && Segment.getLocation(vector22, this.vertices[0], this.vertices[2]) >= 0.0;
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        int n;
        super.rotate(d, d2, d3);
        for (n = 0; n < this.vertices.length; ++n) {
            this.vertices[n].rotate(d, d2, d3);
        }
        for (n = 0; n < this.normals.length; ++n) {
            this.normals[n].rotate(d);
        }
        this.localXAxis.rotate(d);
    }

    @Override
    public void translate(double d, double d2) {
        super.translate(d, d2);
        for (int i = 0; i < this.vertices.length; ++i) {
            this.vertices[i].add(d, d2);
        }
    }

    public double getRotation() {
        return Vector2.X_AXIS.getAngleBetween(this.localXAxis);
    }

    public double getTheta() {
        return this.theta;
    }

    public double getSliceRadius() {
        return this.sliceRadius;
    }

    public Vector2 getCircleCenter() {
        return this.vertices[0];
    }
}

