/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Transform
implements Transformable {
    private static final double TWO_PI = Math.PI * 2;
    public static final Transform IDENTITY = new Transform(){

        @Override
        public void identity() {
        }

        @Override
        public void rotate(double d) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public void rotate(double d, double d2, double d3) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public void rotate(double d, Vector2 vector2) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public void translate(double d, double d2) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public void translate(Vector2 vector2) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public void set(Transform transform) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public void setTranslation(double d, double d2) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public void setTranslationX(double d) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public void setTranslationY(double d) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public void setTranslation(Vector2 vector2) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public double setRotation(double d) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public void lerp(Transform transform, double d) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }
    };
    protected double m00 = 1.0;
    protected double m01 = 0.0;
    protected double m10 = 0.0;
    protected double m11 = 1.0;
    protected double x = 0.0;
    protected double y = 0.0;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(this.m00).append(" ").append(this.m01).append(" | ").append(this.x).append("]").append("[").append(this.m10).append(" ").append(this.m11).append(" | ").append(this.y).append("]");
        return stringBuilder.toString();
    }

    @Override
    public void rotate(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = d2 * this.m00 - d3 * this.m10;
        double d5 = d2 * this.m01 - d3 * this.m11;
        double d6 = d3 * this.m00 + d2 * this.m10;
        double d7 = d3 * this.m01 + d2 * this.m11;
        double d8 = d2 * this.x - d3 * this.y;
        double d9 = d3 * this.x + d2 * this.y;
        this.m00 = d4;
        this.m01 = d5;
        this.m10 = d6;
        this.m11 = d7;
        this.x = d8;
        this.y = d9;
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        double d4 = this.m00;
        double d5 = this.m01;
        double d6 = this.x;
        double d7 = this.m10;
        double d8 = this.m11;
        double d9 = this.y;
        double d10 = Math.cos(d);
        double d11 = Math.sin(d);
        double d12 = d2 - d10 * d2 + d11 * d3;
        double d13 = d3 - d11 * d2 - d10 * d3;
        this.m00 = d10 * d4 - d11 * d7;
        this.m01 = d10 * d5 - d11 * d8;
        this.x = d10 * d6 - d11 * d9 + d12;
        this.m10 = d11 * d4 + d10 * d7;
        this.m11 = d11 * d5 + d10 * d8;
        this.y = d11 * d6 + d10 * d9 + d13;
    }

    @Override
    public void rotate(double d, Vector2 vector2) {
        this.rotate(d, vector2.x, vector2.y);
    }

    @Override
    public void translate(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    @Override
    public void translate(Vector2 vector2) {
        this.translate(vector2.x, vector2.y);
    }

    public Transform copy() {
        Transform transform = new Transform();
        transform.m00 = this.m00;
        transform.m01 = this.m01;
        transform.x = this.x;
        transform.m10 = this.m10;
        transform.m11 = this.m11;
        transform.y = this.y;
        return transform;
    }

    public void set(Transform transform) {
        this.m00 = transform.m00;
        this.m01 = transform.m01;
        this.m10 = transform.m10;
        this.m11 = transform.m11;
        this.x = transform.x;
        this.y = transform.y;
    }

    public void identity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.x = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.y = 0.0;
    }

    public Vector2 getTransformed(Vector2 vector2) {
        Vector2 vector22 = new Vector2();
        double d = vector2.x;
        double d2 = vector2.y;
        vector22.x = this.m00 * d + this.m01 * d2 + this.x;
        vector22.y = this.m10 * d + this.m11 * d2 + this.y;
        return vector22;
    }

    public void getTransformed(Vector2 vector2, Vector2 vector22) {
        double d = vector2.x;
        double d2 = vector2.y;
        vector22.x = this.m00 * d + this.m01 * d2 + this.x;
        vector22.y = this.m10 * d + this.m11 * d2 + this.y;
    }

    public void transform(Vector2 vector2) {
        double d = vector2.x;
        double d2 = vector2.y;
        vector2.x = this.m00 * d + this.m01 * d2 + this.x;
        vector2.y = this.m10 * d + this.m11 * d2 + this.y;
    }

    public Vector2 getInverseTransformed(Vector2 vector2) {
        Vector2 vector22 = new Vector2();
        double d = vector2.x - this.x;
        double d2 = vector2.y - this.y;
        vector22.x = this.m00 * d + this.m10 * d2;
        vector22.y = this.m01 * d + this.m11 * d2;
        return vector22;
    }

    public void getInverseTransformed(Vector2 vector2, Vector2 vector22) {
        double d = vector2.x - this.x;
        double d2 = vector2.y - this.y;
        vector22.x = this.m00 * d + this.m10 * d2;
        vector22.y = this.m01 * d + this.m11 * d2;
    }

    public void inverseTransform(Vector2 vector2) {
        double d = vector2.x - this.x;
        double d2 = vector2.y - this.y;
        vector2.x = this.m00 * d + this.m10 * d2;
        vector2.y = this.m01 * d + this.m11 * d2;
    }

    public Vector2 getTransformedR(Vector2 vector2) {
        Vector2 vector22 = new Vector2();
        double d = vector2.x;
        double d2 = vector2.y;
        vector22.x = this.m00 * d + this.m01 * d2;
        vector22.y = this.m10 * d + this.m11 * d2;
        return vector22;
    }

    @Deprecated
    public void transformR(Vector2 vector2, Vector2 vector22) {
        this.getTransformedR(vector2, vector22);
    }

    public void getTransformedR(Vector2 vector2, Vector2 vector22) {
        double d = vector2.x;
        double d2 = vector2.y;
        vector22.x = this.m00 * d + this.m01 * d2;
        vector22.y = this.m10 * d + this.m11 * d2;
    }

    public void transformR(Vector2 vector2) {
        double d = vector2.x;
        double d2 = vector2.y;
        vector2.x = this.m00 * d + this.m01 * d2;
        vector2.y = this.m10 * d + this.m11 * d2;
    }

    public Vector2 getInverseTransformedR(Vector2 vector2) {
        Vector2 vector22 = new Vector2();
        double d = vector2.x;
        double d2 = vector2.y;
        vector22.x = this.m00 * d + this.m10 * d2;
        vector22.y = this.m01 * d + this.m11 * d2;
        return vector22;
    }

    @Deprecated
    public void inverseTransformR(Vector2 vector2, Vector2 vector22) {
        this.getInverseTransformedR(vector2, vector22);
    }

    public void getInverseTransformedR(Vector2 vector2, Vector2 vector22) {
        double d = vector2.x;
        double d2 = vector2.y;
        vector22.x = this.m00 * d + this.m10 * d2;
        vector22.y = this.m01 * d + this.m11 * d2;
    }

    public void inverseTransformR(Vector2 vector2) {
        double d = vector2.x;
        double d2 = vector2.y;
        vector2.x = this.m00 * d + this.m10 * d2;
        vector2.y = this.m01 * d + this.m11 * d2;
    }

    public double getTranslationX() {
        return this.x;
    }

    public void setTranslationX(double d) {
        this.x = d;
    }

    public double getTranslationY() {
        return this.y;
    }

    public void setTranslationY(double d) {
        this.y = d;
    }

    public Vector2 getTranslation() {
        return new Vector2(this.x, this.y);
    }

    public void setTranslation(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void setTranslation(Vector2 vector2) {
        this.setTranslation(vector2.x, vector2.y);
    }

    public Transform getTranslationTransform() {
        Transform transform = new Transform();
        transform.translate(this.x, this.y);
        return transform;
    }

    public double getRotation() {
        return Math.atan2(this.m10, this.m00);
    }

    public double setRotation(double d) {
        double d2 = this.getRotation();
        this.rotate(-d2, this.x, this.y);
        this.rotate(d, this.x, this.y);
        return d2;
    }

    public Transform getRotationTransform() {
        Transform transform = new Transform();
        transform.rotate(this.getRotation());
        return transform;
    }

    public double[] getValues() {
        return new double[]{this.m00, this.m01, this.x, this.m10, this.m11, this.y};
    }

    public void lerp(Transform transform, double d) {
        double d2 = (1.0 - d) * this.x + d * transform.x;
        double d3 = (1.0 - d) * this.y + d * transform.y;
        double d4 = this.getRotation();
        double d5 = transform.getRotation();
        double d6 = d5 - d4;
        if (d6 < -Math.PI) {
            d6 += Math.PI * 2;
        }
        if (d6 > Math.PI) {
            d6 -= Math.PI * 2;
        }
        double d7 = d6 * d + d4;
        this.identity();
        this.rotate(d7);
        this.translate(d2, d3);
    }

    public void lerp(Transform transform, double d, Transform transform2) {
        double d2 = (1.0 - d) * this.x + d * transform.x;
        double d3 = (1.0 - d) * this.y + d * transform.y;
        double d4 = this.getRotation();
        double d5 = transform.getRotation();
        double d6 = d5 - d4;
        if (d6 < -Math.PI) {
            d6 += Math.PI * 2;
        }
        if (d6 > Math.PI) {
            d6 -= Math.PI * 2;
        }
        double d7 = d6 * d + d4;
        transform2.identity();
        transform2.rotate(d7);
        transform2.translate(d2, d3);
    }

    public void lerp(Vector2 vector2, double d, double d2, Transform transform) {
        transform.set(this);
        transform.translate(vector2.x * d2, vector2.y * d2);
        transform.rotate(d * d2, transform.getTranslationX(), transform.getTranslationY());
    }

    public void lerp(Vector2 vector2, double d, double d2) {
        this.translate(vector2.x * d2, vector2.y * d2);
        this.rotate(d * d2, this.getTranslationX(), this.getTranslationY());
    }

    public Transform lerped(Vector2 vector2, double d, double d2) {
        Transform transform = new Transform();
        transform.set(this);
        transform.translate(vector2.x * d2, vector2.y * d2);
        transform.rotate(d * d2, transform.getTranslationX(), transform.getTranslationY());
        return transform;
    }

    public Transform lerped(Transform transform, double d) {
        double d2 = (1.0 - d) * this.x + d * transform.x;
        double d3 = (1.0 - d) * this.y + d * transform.y;
        double d4 = this.getRotation();
        double d5 = transform.getRotation();
        double d6 = d5 - d4;
        if (d6 < -Math.PI) {
            d6 += Math.PI * 2;
        }
        if (d6 > Math.PI) {
            d6 -= Math.PI * 2;
        }
        double d7 = d6 * d + d4;
        Transform transform2 = new Transform();
        transform2.rotate(d7);
        transform2.translate(d2, d3);
        return transform2;
    }
}

