/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.decompose;

import java.util.List;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Geometry;
import org.dyn4j.geometry.Triangle;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.decompose.Decomposer;
import org.dyn4j.geometry.decompose.DoublyConnectedEdgeList;
import org.dyn4j.geometry.decompose.Triangulator;
import org.dyn4j.resources.Messages;

public class EarClipping
implements Decomposer,
Triangulator {
    @Override
    public List<Convex> decompose(Vector2 ... vector2Array) {
        DoublyConnectedEdgeList doublyConnectedEdgeList = this.createTriangulation(vector2Array);
        doublyConnectedEdgeList.hertelMehlhorn();
        return doublyConnectedEdgeList.getConvexDecomposition();
    }

    @Override
    public List<Triangle> triangulate(Vector2 ... vector2Array) {
        DoublyConnectedEdgeList doublyConnectedEdgeList = this.createTriangulation(vector2Array);
        return doublyConnectedEdgeList.getTriangulation();
    }

    protected DoublyConnectedEdgeList createTriangulation(Vector2 ... vector2Array) {
        int n;
        Object object;
        Object object2;
        Vertex vertex;
        if (vector2Array == null) {
            throw new NullPointerException(Messages.getString("geometry.decompose.nullArray"));
        }
        int n2 = vector2Array.length;
        if (n2 < 4) {
            throw new IllegalArgumentException(Messages.getString("geometry.decompose.invalidSize"));
        }
        double d = Geometry.getWinding(vector2Array);
        if (d < 0.0) {
            Geometry.reverseWinding(vector2Array);
        }
        DoublyConnectedEdgeList doublyConnectedEdgeList = new DoublyConnectedEdgeList(vector2Array);
        Vertex vertex2 = vertex = new Vertex();
        Vertex vertex3 = null;
        for (int i = 0; i < n2; ++i) {
            Vector2 vector2 = vector2Array[i];
            object2 = vector2Array[i == 0 ? n2 - 1 : i - 1];
            object = vector2Array[i + 1 == n2 ? 0 : i + 1];
            Vector2 vector22 = vector2.to((Vector2)object2);
            Vector2 vector23 = vector2.to((Vector2)object);
            if (vector23.isZero()) {
                throw new IllegalArgumentException(Messages.getString("geometry.decompose.coincident"));
            }
            vertex2.reflex = vector22.cross(vector23) > 0.0;
            vertex2.point = vector2;
            vertex2.prev = vertex3;
            if (vertex3 != null) {
                vertex3.next = vertex2;
            }
            vertex2.reference = doublyConnectedEdgeList.vertices.get(i);
            vertex3 = vertex2;
            vertex2 = new Vertex();
        }
        vertex.prev = vertex3;
        vertex3.next = vertex;
        Vertex vertex4 = vertex;
        for (n = 0; n < n2; ++n) {
            vertex4.ear = this.isEar(vertex4, n2);
            vertex4 = vertex4.next;
        }
        vertex4 = vertex;
        n = n2;
        while (n > 3) {
            if (vertex4.ear) {
                doublyConnectedEdgeList.addHalfEdges(vertex4.next.reference, vertex4.prev.reference);
                object2 = vertex4.prev;
                object = vertex4.next;
                ((Vertex)object2).next = vertex4.next;
                ((Vertex)object).prev = vertex4.prev;
                if (((Vertex)object2).reflex) {
                    ((Vertex)object2).reflex = this.isReflex((Vertex)object2);
                }
                if (((Vertex)object).reflex) {
                    ((Vertex)object).reflex = this.isReflex((Vertex)object);
                }
                if (!((Vertex)object2).reflex) {
                    ((Vertex)object2).ear = this.isEar((Vertex)object2, n);
                }
                if (!((Vertex)object).reflex) {
                    ((Vertex)object).ear = this.isEar((Vertex)object, n);
                }
                --n;
            }
            vertex4 = vertex4.next;
        }
        return doublyConnectedEdgeList;
    }

    protected boolean isReflex(Vertex vertex) {
        Vector2 vector2;
        Vector2 vector22 = vertex.point;
        Vector2 vector23 = vertex.prev.point;
        Vector2 vector24 = vertex.next.point;
        Vector2 vector25 = vector22.to(vector23);
        return !(vector25.cross(vector2 = vector22.to(vector24)) < 0.0);
    }

    protected boolean isEar(Vertex vertex, int n) {
        if (vertex.reflex) {
            return false;
        }
        boolean bl = true;
        Vector2 vector2 = vertex.point;
        Vector2 vector22 = vertex.next.point;
        Vector2 vector23 = vertex.prev.point;
        Vertex vertex2 = vertex.next.next;
        for (int i = 0; i < n - 3; ++i) {
            if (vertex2.reflex && this.contains(vector2, vector22, vector23, vertex2.point)) {
                bl = false;
                break;
            }
            vertex2 = vertex2.next;
        }
        return bl;
    }

    protected boolean contains(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24) {
        Vector2 vector25 = vector2.to(vector22);
        Vector2 vector26 = vector2.to(vector23);
        Vector2 vector27 = vector2.to(vector24);
        double d = vector26.dot(vector26);
        double d2 = vector26.dot(vector25);
        double d3 = vector26.dot(vector27);
        double d4 = vector25.dot(vector25);
        double d5 = vector25.dot(vector27);
        double d6 = d * d4 - d2 * d2;
        double d7 = (d4 * d3 - d2 * d5) / d6;
        double d8 = (d * d5 - d2 * d3) / d6;
        return d7 > 0.0 && d8 > 0.0 && d7 + d8 <= 1.0;
    }

    public class Vertex {
        protected Vector2 point;
        protected Vertex prev;
        protected Vertex next;
        protected boolean ear;
        protected boolean reflex;
        protected DoublyConnectedEdgeList.Vertex reference;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("EarClipping.Vertex[Point=").append(this.point).append("|Reflex=").append(this.reflex).append("|IsEar=").append(this.ear).append("]");
            return stringBuilder.toString();
        }
    }
}

