/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.decompose;

import java.util.List;
import org.dyn4j.geometry.decompose.MonotoneVertex;

public class MonotonePolygon<E> {
    protected Type type;
    protected List<MonotoneVertex<E>> vertices;

    public MonotonePolygon(Type type, List<MonotoneVertex<E>> list) {
        this.type = type;
        this.vertices = list;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MonotonePolygon[Type=").append((Object)this.type);
        stringBuilder.append("|Vertices={");
        int n = this.vertices.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.vertices.get(i));
        }
        stringBuilder.append("}]");
        return stringBuilder.toString();
    }

    public MonotoneVertex<E> getMaximum() {
        return this.vertices.get(0);
    }

    public MonotoneVertex<E> getMinimum() {
        return this.vertices.get(this.vertices.size() - 1);
    }

    public Type getType() {
        return this.type;
    }

    public List<MonotoneVertex<E>> getVertices() {
        return this.vertices;
    }

    public void setVertices(List<MonotoneVertex<E>> list) {
        this.vertices = list;
    }

    public static enum Type {
        Y,
        X;

    }
}

