/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.hull;

import java.util.Arrays;
import java.util.Comparator;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.hull.HullGenerator;
import org.dyn4j.resources.Messages;

public class DivideAndConquer
implements HullGenerator {
    @Override
    public Vector2[] generate(Vector2 ... vector2Array) {
        if (vector2Array == null) {
            throw new NullPointerException(Messages.getString("geometry.hull.nullArray"));
        }
        int n = vector2Array.length;
        if (n == 1 || n == 2) {
            return vector2Array;
        }
        try {
            Arrays.sort(vector2Array, new PointComparator());
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException(Messages.getString("geometry.hull.nullPoints"));
        }
        Hull hull = this.divide(vector2Array, 0, n - 1);
        Vector2[] vector2Array2 = new Vector2[hull.size];
        Vertex vertex = hull.root;
        for (int i = 0; i < hull.size; ++i) {
            vector2Array2[i] = vertex.point;
            vertex = vertex.next;
        }
        return vector2Array2;
    }

    private Hull divide(Vector2[] vector2Array, int n, int n2) {
        int n3 = n2 - n;
        if (n3 == 0) {
            Vertex vertex = new Vertex();
            vertex.point = vector2Array[n];
            vertex.next = null;
            vertex.prev = null;
            Hull hull = new Hull();
            hull.root = vertex;
            hull.leftMost = vertex;
            hull.rightMost = vertex;
            hull.size = 1;
            return hull;
        }
        int n4 = (n + n2) / 2;
        Hull hull = this.divide(vector2Array, n, n4);
        Hull hull2 = this.divide(vector2Array, n4 + 1, n2);
        return this.merge(hull, hull2);
    }

    private Hull merge(Hull hull, Hull hull2) {
        Object object;
        Vector2 vector2;
        Object object2;
        if (hull.size == 1 && hull2.size == 1) {
            Vertex vertex;
            Vertex vertex2 = hull.root;
            vertex2.next = vertex = hull2.root;
            vertex2.prev = vertex;
            vertex.next = vertex2;
            vertex.prev = vertex2;
            Hull hull3 = new Hull();
            hull3.root = vertex2;
            hull3.leftMost = vertex2;
            hull3.rightMost = vertex;
            hull3.size = 2;
            return hull3;
        }
        if (hull.size == 1 && hull2.size == 2) {
            Hull hull4 = new Hull();
            hull4.leftMost = hull.root;
            hull4.rightMost = hull2.rightMost;
            hull4.size = 3;
            this.mergeTriangle(hull, hull2, hull4);
            return hull4;
        }
        if (hull.size == 2 && hull2.size == 1) {
            Hull hull5 = new Hull();
            hull5.leftMost = hull.leftMost;
            hull5.rightMost = hull2.root;
            hull5.size = 3;
            this.mergeTriangle(hull2, hull, hull5);
            return hull5;
        }
        Hull hull6 = new Hull();
        hull6.leftMost = hull.leftMost;
        hull6.rightMost = hull2.rightMost;
        Vertex vertex = hull.rightMost;
        Vertex vertex3 = hull2.leftMost;
        Vector2 vector22 = vertex.point.to(vertex3.point);
        for (int i = 0; i < hull.size * hull2.size; ++i) {
            object2 = vertex.point.to(vertex.next.point);
            vector2 = vertex3.point.to(vertex3.prev.point);
            double d = vector2.cross(vector22);
            double d2 = vector22.getNegative().cross((Vector2)object2);
            if (d > 0.0 && d2 > 0.0) break;
            if (d <= 0.0) {
                vertex3 = vertex3.prev;
            }
            if (d2 <= 0.0) {
                vertex = vertex.next;
            }
            vector22 = vertex.point.to(vertex3.point);
        }
        Vertex vertex4 = hull.rightMost;
        object2 = hull2.leftMost;
        vector2 = vertex4.point.to(((Vertex)object2).point);
        for (int i = 0; i < hull.size * hull2.size; ++i) {
            object = vertex4.point.to(vertex4.prev.point);
            Vector2 vector23 = ((Vertex)object2).point.to(((Vertex)object2).next.point);
            double d = vector2.cross(vector23);
            double d3 = ((Vector2)object).cross(vector2.getNegative());
            if (d > 0.0 && d3 > 0.0) break;
            if (d <= 0.0) {
                object2 = ((Vertex)object2).next;
            }
            if (d3 <= 0.0) {
                vertex4 = vertex4.prev;
            }
            vector2 = vertex4.point.to(((Vertex)object2).point);
        }
        vertex.prev = vertex3;
        vertex3.next = vertex;
        vertex4.next = object2;
        ((Vertex)object2).prev = vertex4;
        Vertex vertex5 = hull6.root = vertex;
        object = vertex5;
        int n = 0;
        do {
            ++n;
        } while ((object = ((Vertex)object).next) != vertex5);
        hull6.size = n;
        return hull6;
    }

    private void mergeTriangle(Hull hull, Hull hull2, Hull hull3) {
        Vector2 vector2;
        Vector2 vector22 = hull2.root.point;
        Vector2 vector23 = hull2.root.next.point;
        Vector2 vector24 = hull.root.point;
        Vector2 vector25 = vector24.to(vector22);
        double d = vector25.cross(vector2 = vector22.to(vector23));
        hull3.root = d < 0.0 ? this.insert(hull.root, hull2.root, hull2.root.next) : this.prepend(hull.root, hull2.root, hull2.root.next);
    }

    private Vertex prepend(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        vertex.next = vertex2;
        vertex.prev = vertex3;
        vertex2.prev = vertex;
        vertex3.next = vertex;
        return vertex;
    }

    private Vertex insert(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        vertex.prev = vertex2;
        vertex.next = vertex3;
        vertex2.next = vertex;
        vertex3.prev = vertex;
        return vertex;
    }

    private class PointComparator
    implements Comparator<Vector2> {
        private PointComparator() {
        }

        @Override
        public int compare(Vector2 vector2, Vector2 vector22) {
            return (int)Math.signum(vector2.x - vector22.x);
        }
    }

    private class Hull {
        public Vertex root;
        public Vertex leftMost;
        public Vertex rightMost;
        public int size;

        private Hull() {
        }
    }

    private class Vertex {
        public Vector2 point;
        public Vertex next;
        public Vertex prev;

        private Vertex() {
        }
    }
}

