/*
 * Decompiled with CFR 0.152.
 */
package br.com.abby.animation;

import br.com.abby.animation.KeyFrame;
import br.com.abby.animation.skeletal.Bone;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Animation {
    private List<Bone> bones = new ArrayList<Bone>();
    private Map<Bone, List<KeyFrame>> frames = new HashMap<Bone, List<KeyFrame>>();
    private int frame = 0;
    private int maxFrame = 4;

    public Animation() {
        this(4);
    }

    public Animation(int n) {
        this.maxFrame = n;
    }

    public void addBone(Bone bone) {
        this.bones.add(bone);
        ArrayList<KeyFrame> arrayList = new ArrayList<KeyFrame>();
        for (int i = 0; i < this.maxFrame; ++i) {
            arrayList.add(new KeyFrame(bone.getAngleX(), bone.getAngleY(), bone.getAngleZ()));
        }
        this.frames.put(bone, arrayList);
    }

    public List<Bone> getBones() {
        return this.bones;
    }

    public void setBones(List<Bone> list) {
        this.bones = list;
    }

    public KeyFrame getCurrentBoneFrame(Bone bone) {
        return this.frames.get(bone).get(this.frame);
    }

    private KeyFrame getFirstBoneFrame(Bone bone) {
        return this.frames.get(bone).get(0);
    }

    public KeyFrame getBoneFrame(Bone bone, int n) {
        return this.frames.get(bone).get(n);
    }

    public void nextFrame() {
        this.resetBones();
        ++this.frame;
        if (this.frame == this.maxFrame) {
            this.frame = 1;
        }
        int n = this.frame;
        this.updateBones(n);
    }

    public void previusFrame() {
        this.resetBones();
        --this.frame;
        if (this.frame < 0) {
            this.frame = this.maxFrame - 1;
        }
        int n = this.frame;
        this.updateBones(n);
    }

    public void refreshFrame() {
        this.resetBones();
        this.updateBones(this.frame);
    }

    private void updateBones(int n) {
        for (Bone bone : this.bones) {
            List<KeyFrame> list = this.frames.get(bone);
            bone.rotateX(list.get(n).getX() - list.get(0).getX());
            bone.rotateY(list.get(n).getY() - list.get(0).getY());
            bone.rotateZ(list.get(n).getZ() - list.get(0).getZ());
        }
    }

    public void resetBones() {
        ArrayList<Bone> arrayList = new ArrayList<Bone>();
        arrayList.addAll(this.bones);
        Collections.reverse(arrayList);
        for (Bone bone : arrayList) {
            KeyFrame keyFrame = this.getCurrentBoneFrame(bone);
            KeyFrame keyFrame2 = this.getFirstBoneFrame(bone);
            double d = keyFrame.getZ() - keyFrame2.getZ();
            bone.rotateZ(-d);
            double d2 = keyFrame.getY() - keyFrame2.getY();
            bone.rotateY(-d2);
            double d3 = keyFrame.getX() - keyFrame2.getX();
            bone.rotateX(-d3);
        }
    }

    public void saveFrame() {
        System.out.println("Save Frame");
        for (Bone bone : this.bones) {
            KeyFrame keyFrame = this.getCurrentBoneFrame(bone);
            KeyFrame keyFrame2 = this.getFirstBoneFrame(bone);
            if (keyFrame.getX() != keyFrame2.getX()) {
                System.out.println(bone.getName() + ".setX(" + keyFrame.getX() + ");");
            }
            if (keyFrame.getY() != keyFrame2.getY()) {
                System.out.println(bone.getName() + ".setY(" + keyFrame.getY() + ");");
            }
            if (keyFrame.getZ() == keyFrame2.getZ()) continue;
            System.out.println(bone.getName() + ".setZ(" + keyFrame.getZ() + ");");
        }
    }

    public void exportAnimation() {
        System.out.println("Export Animation to .anim");
        for (int i = 0; i < this.maxFrame; ++i) {
            for (Bone bone : this.bones) {
                this.getBoneFrame(bone, i);
            }
        }
    }

    public int getMaxFrame() {
        return this.maxFrame;
    }

    public void setMaxFrame(int n) {
        this.maxFrame = n;
    }

    public int getFrame() {
        return this.frame;
    }
}

