/*
 * Decompiled with CFR 0.152.
 */
package br.com.abby.animation.skeletal;

import br.com.abby.GLDrawable;
import br.com.abby.animation.skeletal.Bone;
import br.com.abby.linear.Point3D;
import java.util.ArrayList;
import java.util.List;
import org.jgl.GLAUX;

public class Joint
extends Point3D
implements GLDrawable {
    private List<Bone> bones = new ArrayList<Bone>();

    public Joint(double d, double d2, double d3) {
        super(d, d2, d3);
    }

    public void addBone(Bone bone) {
        this.bones.add(bone);
        bone.setOrign(this);
    }

    public void translate(double d, double d2, double d3) {
        this.x += d;
        this.y += d2;
        this.z += d3;
        for (Bone bone : this.bones) {
            bone.translate(d, d2, d3);
        }
    }

    public void rotateXOver(double d, double d2, double d3, double d4) {
        for (Bone bone : this.bones) {
            bone.rotateX(d, d2, d3, d4);
        }
    }

    public void rotateYOver(double d, double d2, double d3, double d4) {
        for (Bone bone : this.bones) {
            bone.rotateY(d, d2, d3, d4);
        }
    }

    public void rotateZOver(double d, double d2, double d3, double d4) {
        for (Bone bone : this.bones) {
            bone.rotateZ(d, d2, d3, d4);
        }
    }

    @Override
    public void draw(GLAUX gLAUX) {
        gLAUX.glColor3i(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        gLAUX.glTranslated(this.x, this.y, this.z);
        gLAUX.auxWireSphere(0.02);
        gLAUX.glTranslated(-this.x, -this.y, -this.z);
        for (Bone bone : this.bones) {
            bone.draw(gLAUX);
        }
    }
}

