/*
 * Decompiled with CFR 0.152.
 */
package org.jgl.context;

import java.util.Stack;
import java.util.Vector;
import org.jgl.context.GL_Feedback;
import org.jgl.context.GL_Image;
import org.jgl.context.GL_List;
import org.jgl.context.GL_List_Item;
import org.jgl.context.GL_Object;
import org.jgl.context.GL_Pointer;
import org.jgl.context.GL_Select;
import org.jgl.context.GL_Util;
import org.jgl.context.attrib.GL_ColorBuffer;
import org.jgl.context.attrib.GL_Current;
import org.jgl.context.attrib.GL_DepthBuffer;
import org.jgl.context.attrib.GL_Eval;
import org.jgl.context.attrib.GL_Lighting;
import org.jgl.context.attrib.GL_Pixel;
import org.jgl.context.attrib.GL_Raster;
import org.jgl.context.attrib.GL_StencilBuffer;
import org.jgl.context.attrib.GL_Texture;
import org.jgl.context.attrib.GL_Transform;
import org.jgl.context.attrib.GL_Viewport;
import org.jgl.context.attrib.texture.GL_Texture_Obj;

public class GL_Context
extends GL_Object {
    public static final int MAX_LIGHTS = 8;
    public static final int MAX_CLIP_PLANES = 6;
    public static final int MAX_TEXTURE_LEVELS = 10;
    public static final int MAX_TEXTURE_SIZE = 512;
    public static final int MAX_3D_TEXTURE_LEVELS = 8;
    public static final int MAX_3D_TEXTURE_SIZE = 128;
    public static final int MAX_EVAL_ORDER = 30;
    public static final int MAX_NAME_STACK_DEPTH = 64;
    public static final float MIN_POINT_SIZE = 1.0f;
    public static final float MAX_POINT_SIZE = 10.0f;
    public static final float POINT_SIZE_GRANULARITY = 0.1f;
    public static final float MIN_LINE_SIZE = 1.0f;
    public static final float MAX_LINE_SIZE = 10.0f;
    public static final float LINE_WIDTH_GRANULARITY = 0.1f;
    public float[] ModelViewMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    public float[] ModelViewInv = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    public boolean ModelViewInvValid = true;
    public Stack<float[]> ModelViewStack = new Stack();
    public float[] ProjectionMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    public Stack<float[]> ProjectionStack = new Stack();
    public float[] TextureMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    public boolean IdentityTexMat = true;
    public Stack<float[]> TextureStack = new Stack();
    public GL_Current Current = new GL_Current();
    public GL_Transform Transform = new GL_Transform();
    private GL_Viewport Viewport = new GL_Viewport();
    public GL_Lighting Lighting = new GL_Lighting();
    public GL_Raster Raster = new GL_Raster();
    public GL_Texture Texture = new GL_Texture();
    public GL_ColorBuffer ColorBuffer = new GL_ColorBuffer(this);
    public GL_DepthBuffer DepthBuffer = new GL_DepthBuffer(this);
    public GL_StencilBuffer StencilBuffer = new GL_StencilBuffer(this);
    public GL_Pixel Pixel = new GL_Pixel();
    public GL_Select Select = new GL_Select();
    public GL_Feedback Feedback = new GL_Feedback();
    public Stack<GL_List_Item> AttribStack = new Stack();
    public GL_Pointer CR = new GL_Pointer(this);
    public float[] EyeCoord;
    public float[] EyeNormal;
    public int ListBase = 0;
    public int ListIndex = 0;
    public int ListMode = 0;
    public Vector<GL_List> ListGroup = new Vector();
    public Vector<GL_Texture_Obj> TexList = new Vector();

    public GL_Context() {
        this.RenderMode = 7168;
        this.Eval = new GL_Eval();
    }

    public float[] ModelViewTransformation(float[] fArray) {
        return GL_Util.mulMatrix41(this.ModelViewMatrix, fArray);
    }

    public float[] NormalTransformation(float[] fArray) {
        float[] fArray2 = GL_Util.mulMatrix31(this.ModelViewMatrix, fArray);
        if (this.Transform.Normalize) {
            GL_Util.normalize(fArray2);
        }
        return fArray2;
    }

    public float[] VertexTransformation(float[] fArray) {
        return GL_Util.mulMatrix41(this.ProjectionMatrix, fArray);
    }

    public float[] TextureTransformation(float[] fArray) {
        return GL_Util.mulMatrix41(this.TextureMatrix, fArray);
    }

    public float[] PerspectiveDivision(float[] fArray) {
        if (fArray[3] != 1.0f && fArray[3] != 0.0f) {
            fArray[0] = fArray[0] / fArray[3];
            fArray[1] = fArray[1] / fArray[3];
            fArray[2] = fArray[2] / fArray[3];
        } else if (fArray[3] == 0.0f) {
            fArray[2] = 0.0f;
            fArray[1] = 0.0f;
            fArray[0] = 0.0f;
        }
        return this.Viewport.Transformation(fArray);
    }

    public int ColorTransformation() {
        if (this.Lighting.Enable) {
            this.EyeNormal = this.NormalTransformation(this.Current.Normal);
            return this.Lighting.color_vertex(this.EyeCoord, this.EyeNormal);
        }
        return this.Current.IntColor;
    }

    public void gl_initialize_context() {
        this.ProjectionMatrix[0] = 1.0f / this.Viewport.Sx;
        this.ProjectionMatrix[5] = 1.0f / this.Viewport.Sy;
        this.ProjectionMatrix[10] = 1.0f;
        this.ProjectionMatrix[12] = -1.0f;
        this.ProjectionMatrix[13] = -1.0f;
        this.ProjectionMatrix[15] = 1.0f;
    }

    public void gl_initialize_context(int n, int n2) {
        this.gl_viewport(0, 0, n, n2);
        this.gl_initialize_context();
    }

    @Override
    public void gl_clear_color(float f, float f2, float f3, float f4) {
        this.ColorBuffer.set_clear_color(f, f2, f3, f4);
    }

    @Override
    public void gl_clear_depth_buffer() {
        if (this.RenderMode != 7168) {
            return;
        }
        this.DepthBuffer.clear_buffer(this.Viewport.Size);
    }

    @Override
    public void gl_clear_color_buffer() {
        if (this.RenderMode != 7168) {
            return;
        }
        this.ColorBuffer.clear_buffer(this.Viewport.Size);
    }

    @Override
    public void gl_clear_stencil_buffer() {
        if (this.RenderMode != 7168) {
            return;
        }
        this.StencilBuffer.clear_buffer(this.Viewport.Size);
    }

    @Override
    public void gl_color_mask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.ColorBuffer.set_color_mask(bl, bl2, bl3, bl4);
    }

    @Override
    public void gl_blend_func(int n, int n2) {
        this.ColorBuffer.BlendSrc = n;
        this.ColorBuffer.BlendDst = n2;
    }

    @Override
    public void gl_cull_face(int n) {
        this.Raster.CullFaceMode = n;
    }

    @Override
    public void gl_front_face(int n) {
        this.Raster.FrontFace = n;
    }

    @Override
    public void gl_point_size(float f) {
        this.Raster.PointSize = f;
        if (f != 1.0f) {
            this.CR.gl_point_size(true);
        } else {
            this.CR.gl_point_size(false);
        }
    }

    @Override
    public void gl_line_width(float f) {
        this.Raster.LineWidth = f;
    }

    @Override
    public void gl_line_stipple(int n, short s) {
        this.Raster.LineStippleRepeat = n;
        this.Raster.LineStipplePattern = s;
    }

    @Override
    public void gl_polygon_mode(int n, int n2) {
        this.Raster.set_polygon_mode(n, n2);
    }

    @Override
    public void gl_polygon_stipple(byte[] byArray) {
        this.Raster.set_polygon_stipple(byArray);
    }

    @Override
    public void gl_clip_plane(int n, float[] fArray) {
        if (!this.ModelViewInvValid) {
            this.ModelViewInv = GL_Util.inverseMatrix44(this.ModelViewMatrix);
            this.ModelViewInvValid = true;
        }
        this.Transform.ClipPlane[n] = GL_Util.mulMatrix41(this.ModelViewInv, fArray);
    }

    @Override
    public float[] gl_get_clip_plane(int n) {
        return this.Transform.ClipPlane[n];
    }

    @Override
    public void gl_enable(int n, boolean bl) {
        switch (n) {
            case 3008: {
                this.ColorBuffer.AlphaEnable = bl;
                break;
            }
            case 3456: {
                this.Eval.AutoNormal = bl;
                break;
            }
            case 3042: {
                this.ColorBuffer.BlendEnable = bl;
                this.CR.gl_blending(bl);
                break;
            }
            case 12288: 
            case 12289: 
            case 12290: 
            case 12291: 
            case 12292: 
            case 12293: {
                this.CR.gl_clipping(this.Transform.clip_enable(n - 12288, bl));
                break;
            }
            case 2903: {
                this.Lighting.ColorMaterial = bl;
                break;
            }
            case 2884: {
                this.Raster.CullFace = bl;
                break;
            }
            case 2929: {
                this.DepthBuffer.Enable = bl;
                this.CR.gl_depth(bl);
                break;
            }
            case 3024: {
                this.ColorBuffer.DitherEnable = bl;
                break;
            }
            case 2912: {
                break;
            }
            case 16384: 
            case 16385: 
            case 16386: 
            case 16387: 
            case 16388: 
            case 16389: 
            case 16390: 
            case 16391: {
                this.Lighting.Light[n - 16384].Enable = bl;
                break;
            }
            case 2896: {
                this.Lighting.Enable = bl;
                this.CR.gl_lighting(bl);
                break;
            }
            case 2848: {
                this.Raster.LineSmooth = bl;
                break;
            }
            case 2852: {
                this.Raster.LineStipple = bl;
                this.CR.gl_stipple_line(bl);
                break;
            }
            case 3057: {
                this.ColorBuffer.LogicOPEnable = bl;
                break;
            }
            case 3472: {
                this.Eval.Map1Color4Enable = bl;
                break;
            }
            case 3473: {
                this.Eval.Map1IndexEnable = bl;
                break;
            }
            case 3474: {
                this.Eval.Map1NormalEnable = bl;
                break;
            }
            case 3475: {
                this.Eval.Map1TexCoord1Enable = bl;
                break;
            }
            case 3476: {
                this.Eval.Map1TexCoord2Enable = bl;
                break;
            }
            case 3477: {
                this.Eval.Map1TexCoord3Enable = bl;
                break;
            }
            case 3478: {
                this.Eval.Map1TexCoord4Enable = bl;
                break;
            }
            case 3479: {
                this.Eval.Map1Vertex3Enable = bl;
                break;
            }
            case 3480: {
                this.Eval.Map1Vertex3Enable = bl;
                break;
            }
            case 3504: {
                this.Eval.Map2Color4Enable = bl;
                break;
            }
            case 3505: {
                this.Eval.Map2IndexEnable = bl;
                break;
            }
            case 3506: {
                this.Eval.Map2NormalEnable = bl;
                break;
            }
            case 3507: {
                this.Eval.Map2TexCoord1Enable = bl;
                break;
            }
            case 3508: {
                this.Eval.Map2TexCoord2Enable = bl;
                break;
            }
            case 3509: {
                this.Eval.Map2TexCoord3Enable = bl;
                break;
            }
            case 3510: {
                this.Eval.Map2TexCoord4Enable = bl;
                break;
            }
            case 3511: {
                this.Eval.Map2Vertex3Enable = bl;
                break;
            }
            case 3512: {
                this.Eval.Map2Vertex4Enable = bl;
                break;
            }
            case 2977: {
                this.Transform.Normalize = bl;
                break;
            }
            case 2832: {
                this.Raster.PointSmooth = bl;
                break;
            }
            case 2881: {
                this.Raster.PolygonSmooth = bl;
                break;
            }
            case 2882: {
                this.Raster.PolygonStipple = bl;
                this.CR.gl_stipple_poly(bl);
                break;
            }
            case 3089: 
            case 32823: {
                break;
            }
            case 2960: {
                this.StencilBuffer.Enable = bl;
                break;
            }
            case 3552: 
            case 3553: 
            case 32879: {
                this.CR.gl_texture(this.Texture.tex_enable(n, bl));
                break;
            }
            case 3168: 
            case 3169: 
            case 3170: 
            case 3171: {
                this.Texture.tex_gen_enable(n, bl);
                break;
            }
        }
    }

    @Override
    public boolean gl_is_enabled(int n) {
        switch (n) {
            case 3008: {
                break;
            }
            case 3456: {
                return this.Eval.AutoNormal;
            }
            case 3042: {
                return this.ColorBuffer.BlendEnable;
            }
            case 12288: 
            case 12289: 
            case 12290: 
            case 12291: 
            case 12292: 
            case 12293: {
                return this.Transform.ClipEnable[n - 12288];
            }
            case 2903: {
                return this.Lighting.ColorMaterial;
            }
            case 2884: {
                return this.Raster.CullFace;
            }
            case 2929: {
                return this.DepthBuffer.Enable;
            }
            case 2912: 
            case 3024: {
                break;
            }
            case 16384: 
            case 16385: 
            case 16386: 
            case 16387: 
            case 16388: 
            case 16389: 
            case 16390: 
            case 16391: {
                return this.Lighting.Light[n - 16384].Enable;
            }
            case 2896: {
                return this.Lighting.Enable;
            }
            case 2848: {
                return this.Raster.LineSmooth;
            }
            case 2852: {
                return this.Raster.LineStipple;
            }
            case 3057: {
                break;
            }
            case 3472: {
                return this.Eval.Map1Color4Enable;
            }
            case 3473: {
                return this.Eval.Map1IndexEnable;
            }
            case 3474: {
                return this.Eval.Map1NormalEnable;
            }
            case 3475: {
                return this.Eval.Map1TexCoord1Enable;
            }
            case 3476: {
                return this.Eval.Map1TexCoord2Enable;
            }
            case 3477: {
                return this.Eval.Map1TexCoord3Enable;
            }
            case 3478: {
                return this.Eval.Map1TexCoord4Enable;
            }
            case 3479: {
                return this.Eval.Map1Vertex3Enable;
            }
            case 3480: {
                return this.Eval.Map1Vertex4Enable;
            }
            case 3504: {
                return this.Eval.Map2Color4Enable;
            }
            case 3505: {
                return this.Eval.Map2IndexEnable;
            }
            case 3506: {
                return this.Eval.Map2NormalEnable;
            }
            case 3507: {
                return this.Eval.Map2TexCoord1Enable;
            }
            case 3508: {
                return this.Eval.Map2TexCoord2Enable;
            }
            case 3509: {
                return this.Eval.Map2TexCoord3Enable;
            }
            case 3510: {
                return this.Eval.Map2TexCoord4Enable;
            }
            case 3511: {
                return this.Eval.Map2Vertex3Enable;
            }
            case 3512: {
                return this.Eval.Map2Vertex4Enable;
            }
            case 2977: {
                return this.Transform.Normalize;
            }
            case 2832: {
                return this.Raster.PointSmooth;
            }
            case 2881: {
                return this.Raster.PolygonSmooth;
            }
            case 2882: {
                return this.Raster.PolygonStipple;
            }
            case 2960: 
            case 3089: 
            case 32823: {
                break;
            }
            case 3552: 
            case 3553: 
            case 32879: {
                return this.Texture.is_tex_enabled(n);
            }
            case 3168: 
            case 3169: 
            case 3170: 
            case 3171: {
                return this.Texture.is_tex_gen_enabled(n);
            }
        }
        return false;
    }

    private void gl_enable_push_attrib(GL_List_Item gL_List_Item) {
        int n;
        gL_List_Item.BoolPtr = new boolean[51];
        gL_List_Item.IntPtr = new int[2];
        gL_List_Item.BoolPtr[0] = false;
        gL_List_Item.BoolPtr[1] = this.Eval.AutoNormal;
        gL_List_Item.BoolPtr[2] = this.ColorBuffer.BlendEnable;
        for (n = 0; n < 6; ++n) {
            gL_List_Item.BoolPtr[n + 3] = this.Transform.ClipEnable[n];
        }
        gL_List_Item.BoolPtr[9] = this.Lighting.ColorMaterial;
        gL_List_Item.BoolPtr[10] = this.Raster.CullFace;
        gL_List_Item.BoolPtr[11] = this.DepthBuffer.Enable;
        gL_List_Item.BoolPtr[12] = false;
        gL_List_Item.BoolPtr[13] = false;
        for (n = 0; n < 8; ++n) {
            gL_List_Item.BoolPtr[n + 14] = this.Lighting.Light[n].Enable;
        }
        gL_List_Item.BoolPtr[22] = this.Lighting.Enable;
        gL_List_Item.BoolPtr[23] = this.Raster.LineSmooth;
        gL_List_Item.BoolPtr[24] = this.Raster.LineStipple;
        gL_List_Item.BoolPtr[25] = false;
        gL_List_Item.BoolPtr[26] = this.Eval.Map1Vertex3Enable;
        gL_List_Item.BoolPtr[27] = this.Eval.Map1Vertex4Enable;
        gL_List_Item.BoolPtr[28] = this.Eval.Map1IndexEnable;
        gL_List_Item.BoolPtr[29] = this.Eval.Map1Color4Enable;
        gL_List_Item.BoolPtr[30] = this.Eval.Map1NormalEnable;
        gL_List_Item.BoolPtr[31] = this.Eval.Map1TexCoord1Enable;
        gL_List_Item.BoolPtr[32] = this.Eval.Map1TexCoord2Enable;
        gL_List_Item.BoolPtr[33] = this.Eval.Map1TexCoord3Enable;
        gL_List_Item.BoolPtr[34] = this.Eval.Map1TexCoord4Enable;
        gL_List_Item.BoolPtr[35] = this.Eval.Map2Vertex3Enable;
        gL_List_Item.BoolPtr[36] = this.Eval.Map2Vertex4Enable;
        gL_List_Item.BoolPtr[37] = this.Eval.Map2IndexEnable;
        gL_List_Item.BoolPtr[38] = this.Eval.Map2Color4Enable;
        gL_List_Item.BoolPtr[39] = this.Eval.Map2NormalEnable;
        gL_List_Item.BoolPtr[40] = this.Eval.Map2TexCoord1Enable;
        gL_List_Item.BoolPtr[41] = this.Eval.Map2TexCoord2Enable;
        gL_List_Item.BoolPtr[42] = this.Eval.Map2TexCoord3Enable;
        gL_List_Item.BoolPtr[43] = this.Eval.Map2TexCoord4Enable;
        gL_List_Item.BoolPtr[44] = this.Transform.Normalize;
        gL_List_Item.BoolPtr[45] = this.Raster.PointSmooth;
        gL_List_Item.BoolPtr[46] = this.Raster.PolygonSmooth;
        gL_List_Item.BoolPtr[47] = this.Raster.PolygonStipple;
        gL_List_Item.BoolPtr[48] = false;
        gL_List_Item.BoolPtr[49] = false;
        gL_List_Item.BoolPtr[50] = this.StencilBuffer.Enable;
        gL_List_Item.IntPtr[0] = this.Texture.is_tex_enabled();
        gL_List_Item.IntPtr[1] = this.Texture.is_tex_gen_enabled();
    }

    private void gl_enable_pop_attrib(GL_List_Item gL_List_Item) {
        int n;
        this.Eval.AutoNormal = gL_List_Item.BoolPtr[1];
        for (n = 0; n < 6; ++n) {
            this.Transform.ClipEnable[n] = gL_List_Item.BoolPtr[n + 3];
        }
        this.CR.gl_clipping(this.Transform.check_clip());
        this.Lighting.ColorMaterial = gL_List_Item.BoolPtr[9];
        this.Raster.CullFace = gL_List_Item.BoolPtr[10];
        this.DepthBuffer.Enable = gL_List_Item.BoolPtr[11];
        this.CR.gl_depth(this.DepthBuffer.Enable);
        for (n = 0; n < 8; ++n) {
            this.Lighting.Light[n].Enable = gL_List_Item.BoolPtr[n + 14];
        }
        this.Lighting.Enable = gL_List_Item.BoolPtr[22];
        this.CR.gl_lighting(this.Lighting.Enable);
        this.Raster.LineSmooth = gL_List_Item.BoolPtr[23];
        this.Raster.LineStipple = gL_List_Item.BoolPtr[24];
        this.CR.gl_stipple_line(this.Raster.LineStipple);
        this.Eval.Map1Vertex3Enable = gL_List_Item.BoolPtr[26];
        this.Eval.Map1Vertex4Enable = gL_List_Item.BoolPtr[27];
        this.Eval.Map1IndexEnable = gL_List_Item.BoolPtr[28];
        this.Eval.Map1Color4Enable = gL_List_Item.BoolPtr[29];
        this.Eval.Map1NormalEnable = gL_List_Item.BoolPtr[30];
        this.Eval.Map1TexCoord1Enable = gL_List_Item.BoolPtr[31];
        this.Eval.Map1TexCoord2Enable = gL_List_Item.BoolPtr[32];
        this.Eval.Map1TexCoord3Enable = gL_List_Item.BoolPtr[33];
        this.Eval.Map1TexCoord4Enable = gL_List_Item.BoolPtr[34];
        this.Eval.Map2Vertex3Enable = gL_List_Item.BoolPtr[35];
        this.Eval.Map2Vertex4Enable = gL_List_Item.BoolPtr[36];
        this.Eval.Map2IndexEnable = gL_List_Item.BoolPtr[37];
        this.Eval.Map2Color4Enable = gL_List_Item.BoolPtr[38];
        this.Eval.Map2NormalEnable = gL_List_Item.BoolPtr[39];
        this.Eval.Map2TexCoord1Enable = gL_List_Item.BoolPtr[40];
        this.Eval.Map2TexCoord2Enable = gL_List_Item.BoolPtr[41];
        this.Eval.Map2TexCoord3Enable = gL_List_Item.BoolPtr[42];
        this.Eval.Map2TexCoord4Enable = gL_List_Item.BoolPtr[43];
        this.Transform.Normalize = gL_List_Item.BoolPtr[44];
        this.Raster.PointSmooth = gL_List_Item.BoolPtr[45];
        this.Raster.PolygonSmooth = gL_List_Item.BoolPtr[46];
        this.Raster.PolygonStipple = gL_List_Item.BoolPtr[47];
        this.CR.gl_stipple_poly(this.Raster.PolygonStipple);
        this.StencilBuffer.Enable = gL_List_Item.BoolPtr[50];
        this.CR.gl_texture(this.Texture.tex_enable(gL_List_Item.IntPtr[0]));
        this.Texture.tex_gen_enable(gL_List_Item.IntPtr[1]);
    }

    public void gl_push_attrib(int n) {
        GL_List_Item gL_List_Item;
        int n2 = 0;
        if ((n & 0x200) != 0) {
            // empty if block
        }
        if ((n & 0x4000) != 0) {
            gL_List_Item = new GL_List_Item(16384);
            gL_List_Item.ObjPtr = this.ColorBuffer;
            this.ColorBuffer = new GL_ColorBuffer(this.ColorBuffer);
            this.AttribStack.push(gL_List_Item);
            ++n2;
        }
        if ((n & 1) > 0) {
            gL_List_Item = new GL_List_Item(1);
            gL_List_Item.ObjPtr = this.Current;
            this.Current = new GL_Current(this.Current);
            this.AttribStack.push(gL_List_Item);
            ++n2;
        }
        if ((n & 0x100) != 0) {
            gL_List_Item = new GL_List_Item(256);
            gL_List_Item.ObjPtr = this.DepthBuffer;
            this.DepthBuffer = new GL_DepthBuffer(this.DepthBuffer);
            this.AttribStack.push(gL_List_Item);
            ++n2;
        }
        if ((n & 0x2000) != 0) {
            gL_List_Item = new GL_List_Item(8192);
            this.gl_enable_push_attrib(gL_List_Item);
            this.AttribStack.push(gL_List_Item);
            ++n2;
        }
        if ((n & 0x10000) != 0) {
            gL_List_Item = new GL_List_Item(65536);
            gL_List_Item.ObjPtr = this.Eval;
            this.Eval = new GL_Eval(this.Eval);
            this.AttribStack.push(gL_List_Item);
            ++n2;
        }
        if ((n & 0x80) != 0) {
            // empty if block
        }
        if ((n & 0x8000) != 0) {
            // empty if block
        }
        if ((n & 0x40) != 0) {
            gL_List_Item = new GL_List_Item(64);
            gL_List_Item.ObjPtr = this.Lighting;
            this.Lighting = new GL_Lighting(this.Lighting);
            this.AttribStack.push(gL_List_Item);
            ++n2;
        }
        if ((n & 4) != 0) {
            gL_List_Item = new GL_List_Item(4);
            this.Raster.push_line_attrib(gL_List_Item);
            this.AttribStack.push(gL_List_Item);
            ++n2;
        }
        if ((n & 0x20000) != 0) {
            gL_List_Item = new GL_List_Item(131072);
            gL_List_Item.IntPtr = new int[1];
            gL_List_Item.IntPtr[0] = this.ListBase;
            this.AttribStack.push(gL_List_Item);
            ++n2;
        }
        if ((n & 0x20) != 0) {
            gL_List_Item = new GL_List_Item(32);
            this.AttribStack.push(gL_List_Item);
            ++n2;
        }
        if ((n & 2) != 0) {
            gL_List_Item = new GL_List_Item(2);
            this.Raster.push_point_attrib(gL_List_Item);
            this.AttribStack.push(gL_List_Item);
            ++n2;
        }
        if ((n & 8) != 0) {
            gL_List_Item = new GL_List_Item(8);
            this.Raster.push_polygon_attrib(gL_List_Item);
            this.AttribStack.push(gL_List_Item);
            ++n2;
        }
        if ((n & 0x10) != 0) {
            gL_List_Item = new GL_List_Item(16);
            this.Raster.push_polygon_stipple_attrib(gL_List_Item);
            this.AttribStack.push(gL_List_Item);
            ++n2;
        }
        if ((n & 0x80000) != 0) {
            // empty if block
        }
        if ((n & 0x400) != 0) {
            gL_List_Item = new GL_List_Item(1024);
            gL_List_Item.ObjPtr = this.StencilBuffer;
            this.StencilBuffer = new GL_StencilBuffer(this.StencilBuffer);
            this.AttribStack.push(gL_List_Item);
            ++n2;
        }
        if ((n & 0x40000) != 0) {
            gL_List_Item = new GL_List_Item(262144);
            this.AttribStack.push(gL_List_Item);
            ++n2;
        }
        if ((n & 0x1000) != 0) {
            gL_List_Item = new GL_List_Item(4096);
            gL_List_Item.ObjPtr = this.Transform;
            this.Transform = new GL_Transform(this.Transform);
            this.AttribStack.push(gL_List_Item);
            ++n2;
        }
        if ((n & 0x800) != 0) {
            gL_List_Item = new GL_List_Item(2048);
            gL_List_Item.ObjPtr = this.Viewport;
            this.Viewport = new GL_Viewport(this.Viewport);
            this.AttribStack.push(gL_List_Item);
            ++n2;
        }
        gL_List_Item = new GL_List_Item(n2);
        this.AttribStack.push(gL_List_Item);
    }

    public void gl_pop_attrib() {
        GL_List_Item gL_List_Item = this.AttribStack.pop();
        int n = gL_List_Item.NodeKind;
        block21: for (int i = 0; i < n; ++i) {
            gL_List_Item = this.AttribStack.pop();
            switch (gL_List_Item.NodeKind) {
                case 512: {
                    continue block21;
                }
                case 16384: {
                    this.ColorBuffer = (GL_ColorBuffer)gL_List_Item.ObjPtr;
                    continue block21;
                }
                case 1: {
                    this.Current = (GL_Current)gL_List_Item.ObjPtr;
                    continue block21;
                }
                case 256: {
                    this.DepthBuffer = (GL_DepthBuffer)gL_List_Item.ObjPtr;
                    this.CR.gl_depth(this.DepthBuffer.Enable);
                    continue block21;
                }
                case 8192: {
                    this.gl_enable_pop_attrib(gL_List_Item);
                    continue block21;
                }
                case 65536: {
                    this.Eval = (GL_Eval)gL_List_Item.ObjPtr;
                    continue block21;
                }
                case 128: 
                case 32768: {
                    continue block21;
                }
                case 64: {
                    this.Lighting = (GL_Lighting)gL_List_Item.ObjPtr;
                    this.CR.gl_smooth(this.Lighting.ShadeModel == 7425);
                    continue block21;
                }
                case 4: {
                    this.Raster.pop_line_attrib(gL_List_Item);
                    this.CR.gl_stipple_line(this.Raster.LineStipple);
                    continue block21;
                }
                case 131072: {
                    this.ListBase = gL_List_Item.IntPtr[0];
                    continue block21;
                }
                case 32: {
                    continue block21;
                }
                case 2: {
                    this.Raster.pop_point_attrib(gL_List_Item);
                    continue block21;
                }
                case 8: {
                    this.Raster.pop_polygon_attrib(gL_List_Item);
                    this.CR.gl_stipple_poly(this.Raster.PolygonStipple);
                    continue block21;
                }
                case 16: {
                    this.Raster.pop_polygon_stipple_attrib(gL_List_Item);
                    continue block21;
                }
                case 524288: {
                    continue block21;
                }
                case 1024: {
                    this.StencilBuffer = (GL_StencilBuffer)gL_List_Item.ObjPtr;
                    continue block21;
                }
                case 262144: {
                    continue block21;
                }
                case 4096: {
                    this.Transform = (GL_Transform)gL_List_Item.ObjPtr;
                    this.CR.gl_clipping(this.Transform.ClippingEnable);
                    continue block21;
                }
                case 2048: {
                    this.Viewport = (GL_Viewport)gL_List_Item.ObjPtr;
                }
            }
        }
    }

    @Override
    public int gl_render_mode(int n) {
        int n2 = 0;
        switch (this.RenderMode) {
            case 7168: {
                n2 = 0;
                break;
            }
            case 7170: {
                if (this.Select.BufferSize == 0) {
                    this.gl_error(1282, "glRenderMode");
                    return -1;
                }
                if (this.Select.HitFlag) {
                    this.Select.write_hit_record();
                }
                n2 = this.Select.BufferCount > this.Select.BufferSize ? -1 : this.Select.Hits;
                this.Select.BufferCount = 0;
                this.Select.Hits = 0;
                this.Select.NameStackDepth = 0;
                break;
            }
            case 7169: {
                if (this.Feedback.BufferSize == 0) {
                    this.gl_error(1282, "glRenderMode");
                    return -1;
                }
                n2 = this.Feedback.BufferCount > this.Feedback.BufferSize ? -1 : this.Feedback.BufferCount;
                this.Feedback.BufferCount = 0;
            }
        }
        this.RenderMode = n;
        this.CR.gl_select(n == 7170);
        return n2;
    }

    @Override
    public void gl_clear_depth(float f) {
        this.DepthBuffer.Clear = f;
    }

    @Override
    public void gl_depth_func(int n) {
        this.DepthBuffer.Func = n;
    }

    @Override
    public void gl_depth_mask(boolean bl) {
        this.DepthBuffer.Mask = bl;
    }

    @Override
    public void gl_depth_range(float f, float f2) {
        this.Viewport.set_depth_range(f, f2);
    }

    @Override
    public void gl_matrix_mode(int n) {
        this.Transform.MatrixMode = n;
    }

    @Override
    public void gl_mult_matrix(float[] fArray) {
        switch (this.Transform.MatrixMode) {
            case 5888: {
                this.ModelViewMatrix = GL_Util.mulMatrix44(this.ModelViewMatrix, fArray);
                this.ModelViewInvValid = false;
                break;
            }
            case 5889: {
                this.ProjectionMatrix = GL_Util.mulMatrix44(this.ProjectionMatrix, fArray);
                break;
            }
            case 5890: {
                this.TextureMatrix = GL_Util.mulMatrix44(this.TextureMatrix, fArray);
            }
        }
    }

    @Override
    public void gl_viewport(int n, int n2, int n3, int n4) {
        this.Viewport.set_viewport(n, n2, n3, n4);
        this.ColorBuffer.set_buffer(this.Viewport.Size);
        this.DepthBuffer.set_buffer(this.Viewport.Size);
        this.StencilBuffer.set_buffer(this.Viewport.Size);
        this.DepthBuffer.clear_buffer(this.Viewport.Size);
    }

    @Override
    public void gl_push_matrix() {
        float[] fArray = new float[16];
        switch (this.Transform.MatrixMode) {
            case 5888: {
                System.arraycopy(this.ModelViewMatrix, 0, fArray, 0, 16);
                this.ModelViewStack.push(fArray);
                break;
            }
            case 5889: {
                System.arraycopy(this.ProjectionMatrix, 0, fArray, 0, 16);
                this.ProjectionStack.push(fArray);
                break;
            }
            case 5890: {
                System.arraycopy(this.TextureMatrix, 0, fArray, 0, 16);
                this.TextureStack.push(fArray);
            }
        }
    }

    @Override
    public void gl_pop_matrix() {
        switch (this.Transform.MatrixMode) {
            case 5888: {
                this.ModelViewMatrix = this.ModelViewStack.pop();
                this.ModelViewInvValid = false;
                break;
            }
            case 5889: {
                this.ProjectionMatrix = this.ProjectionStack.pop();
                break;
            }
            case 5890: {
                this.TextureMatrix = this.TextureStack.pop();
            }
        }
    }

    @Override
    public void gl_load_identity_matrix() {
        switch (this.Transform.MatrixMode) {
            case 5888: {
                GL_Util.loadMatrix44(this.ModelViewMatrix, IDENTITY);
                GL_Util.loadMatrix44(this.ModelViewInv, IDENTITY);
                this.ModelViewInvValid = true;
                break;
            }
            case 5889: {
                GL_Util.loadMatrix44(this.ProjectionMatrix, IDENTITY);
                break;
            }
            case 5890: {
                GL_Util.loadMatrix44(this.TextureMatrix, IDENTITY);
            }
        }
    }

    @Override
    public void gl_load_matrix(float[] fArray) {
        switch (this.Transform.MatrixMode) {
            case 5888: {
                GL_Util.loadMatrix44(this.ModelViewMatrix, fArray);
                this.ModelViewInvValid = false;
                break;
            }
            case 5889: {
                GL_Util.loadMatrix44(this.ProjectionMatrix, fArray);
                break;
            }
            case 5890: {
                GL_Util.loadMatrix44(this.TextureMatrix, fArray);
            }
        }
    }

    @Override
    public void gl_rotate(float f, float f2, float f3, float f4) {
        float[] fArray = this.get_rotate(f, f2, f3, f4);
        if (fArray != null) {
            this.gl_mult_matrix(fArray);
        }
    }

    @Override
    public void gl_scale(float f, float f2, float f3) {
        this.gl_mult_matrix(this.get_scale(f, f2, f3));
    }

    @Override
    public void gl_translate(float f, float f2, float f3) {
        this.gl_mult_matrix(this.get_translate(f, f2, f3));
    }

    public boolean gl_is_list(int n) {
        if (this.ListGroup.size() <= n) {
            return false;
        }
        GL_List gL_List = this.ListGroup.elementAt(n);
        return gL_List != null;
    }

    public void gl_delete_lists(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.ListGroup.setElementAt(null, n + i);
        }
    }

    public int gl_gen_lists(int n) {
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        while (n2 < this.ListGroup.size() && n3 < n) {
            GL_List gL_List = this.ListGroup.elementAt(n2);
            if (gL_List == null) {
                if (n3 == 0) {
                    n4 = n2;
                }
                ++n2;
                ++n3;
                continue;
            }
            ++n2;
            n3 = 0;
        }
        if (n3 == n) {
            return n4;
        }
        return n2;
    }

    public void gl_new_list(int n) {
        this.ListIndex = n;
    }

    public void gl_end_list(GL_List gL_List) {
        if (this.ListGroup.size() < this.ListIndex + 1) {
            this.ListGroup.setSize(this.ListIndex + 1);
        }
        this.ListGroup.setElementAt(gL_List, this.ListIndex);
        this.ListIndex = 0;
    }

    @Override
    public void gl_call_list(int n) {
        this.ListGroup.elementAt(n).gl_exec_list(this);
    }

    @Override
    public void gl_call_offset(int n) {
        this.ListGroup.elementAt(this.ListBase + n).gl_exec_list(this);
    }

    @Override
    public void gl_list_base(int n) {
        this.ListBase = n;
    }

    @Override
    public void gl_begin(int n) {
        this.Mode = n;
        this.CR.geometry.gl_begin();
    }

    @Override
    public void gl_end() {
        this.CR.geometry.gl_end();
        this.Mode = 0;
    }

    @Override
    public void gl_vertex(float f, float f2, float f3, float f4) {
        this.Current.Vertex[0] = f;
        this.Current.Vertex[1] = f2;
        this.Current.Vertex[2] = f3;
        this.Current.Vertex[3] = f4;
        this.CR.geometry.gl_vertex();
    }

    @Override
    public void gl_normal(float f, float f2, float f3) {
        this.Current.Normal[0] = f;
        this.Current.Normal[1] = f2;
        this.Current.Normal[2] = f3;
    }

    @Override
    public void gl_index(int n) {
        this.Current.Index = n;
    }

    @Override
    public void gl_color(float f, float f2, float f3, float f4) {
        this.Current.set_color(f, f2, f3, f4);
        this.Lighting.set_color(f, f2, f3, f4);
    }

    @Override
    public void gl_tex_coord(float f, float f2, float f3, float f4) {
        this.Current.TexCoord[0] = f;
        this.Current.TexCoord[1] = f2;
        this.Current.TexCoord[2] = f3;
        this.Current.TexCoord[3] = f4;
    }

    @Override
    public void gl_raster_pos(float f, float f2, float f3, float f4) {
    }

    @Override
    public void gl_shade_model(int n) {
        this.Lighting.ShadeModel = n;
        this.CR.gl_smooth(this.Lighting.ShadeModel == 7425);
    }

    @Override
    public void gl_light(int n, int n2, float[] fArray) {
        if (n2 == 4611) {
            this.Lighting.set_light(n, n2, GL_Util.mulMatrix41(this.ModelViewMatrix, fArray));
            return;
        }
        if (n2 == 4612) {
            if (!this.ModelViewInvValid) {
                this.ModelViewInv = GL_Util.inverseMatrix44(this.ModelViewMatrix);
            }
            this.Lighting.set_light(n, n2, GL_Util.mulMatrix41(this.ModelViewInv, fArray));
            return;
        }
        this.Lighting.set_light(n, n2, fArray);
    }

    @Override
    public float[] gl_get_light(int n, int n2) {
        return this.Lighting.get_light(n, n2);
    }

    @Override
    public void gl_light_model(int n, float[] fArray) {
        this.Lighting.set_light_model(n, fArray);
    }

    @Override
    public void gl_material(int n, int n2, float[] fArray) {
        this.Lighting.set_material(n, n2, fArray);
    }

    @Override
    public float[] gl_get_material(int n, int n2) {
        return this.Lighting.get_material(n, n2);
    }

    @Override
    public void gl_color_material(int n, int n2) {
        this.Lighting.set_color_material(n, n2);
    }

    @Override
    public void gl_pixel_store(int n, int n2) {
        this.Pixel.pack_store(n, n2);
    }

    @Override
    public void gl_pixel_transfer(int n, float f) {
        this.Pixel.pixel_transfer(n, f);
    }

    @Override
    public void gl_read_index_pixels(int n, int n2, int n3, int n4, int n5, Object object) {
    }

    @Override
    public void gl_read_color_pixels(int n, int n2, int n3, int n4, int n5, int n6, Object object) {
        this.ColorBuffer.read_pixels(n, n2, n3, n4, n5, n6, object);
    }

    @Override
    public void gl_read_stencil_pixels(int n, int n2, int n3, int n4, int n5, Object object) {
        this.StencilBuffer.read_pixels(n, n2, n3, n4, n5, object);
    }

    @Override
    public void gl_read_depth_pixels(int n, int n2, int n3, int n4, int n5, Object object) {
        this.DepthBuffer.read_pixels(n, n2, n3, n4, n5, object);
    }

    @Override
    public void gl_draw_index_pixels(int n, int n2, int n3, Object object) {
    }

    @Override
    public void gl_draw_color_pixels(int n, int n2, int n3, int n4, Object object) {
        this.ColorBuffer.draw_pixels(n, n2, n3, n4, object);
    }

    @Override
    public void gl_draw_stencil_pixels(int n, int n2, int n3, Object object) {
        this.StencilBuffer.draw_pixels(n, n2, n3, object);
    }

    @Override
    public void gl_draw_depth_pixels(int n, int n2, int n3, Object object) {
        this.DepthBuffer.draw_pixels(n, n2, n3, object);
    }

    @Override
    public void gl_copy_color_pixels(int n, int n2, int n3, int n4) {
        this.ColorBuffer.copy_pixels(n, n2, n3, n4);
    }

    @Override
    public void gl_copy_stencil_pixels(int n, int n2, int n3, int n4) {
        this.StencilBuffer.copy_pixels(n, n2, n3, n4);
    }

    @Override
    public void gl_copy_depth_pixels(int n, int n2, int n3, int n4) {
        this.DepthBuffer.copy_pixels(n, n2, n3, n4);
    }

    @Override
    public void gl_stencil_func(int n, int n2, int n3) {
        this.StencilBuffer.Func = n;
        this.StencilBuffer.Ref = n2;
        this.StencilBuffer.ValueMask = n3;
    }

    @Override
    public void gl_stencil_mask(int n) {
        this.StencilBuffer.Mask = n;
    }

    @Override
    public void gl_stencil_op(int n, int n2, int n3) {
        this.StencilBuffer.Fail = n;
        this.StencilBuffer.ZFail = n2;
        this.StencilBuffer.ZPass = n3;
    }

    @Override
    public void gl_clear_stencil(int n) {
        this.StencilBuffer.Clear = n;
    }

    @Override
    public void gl_tex_gen_i(int n, int n2) {
        this.Texture.set_tex_gen_i(n, n2);
    }

    @Override
    public void gl_tex_gen_f(int n, int n2, float[] fArray) {
        this.Texture.set_tex_gen_f(n, n2, fArray);
    }

    @Override
    public void gl_tex_env_i(int n) {
        this.Texture.EnvMode = n;
    }

    @Override
    public void gl_tex_env_f(float[] fArray) {
        System.arraycopy(fArray, 0, this.Texture.EnvColor, 0, 4);
    }

    @Override
    public void gl_tex_parameter(int n, int n2, float[] fArray) {
        this.Texture.set_tex(n, n2, fArray);
    }

    @Override
    public void gl_tex_image_1d(int n, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
        this.Texture.set_tex_image(n, n2, n5, new GL_Image(n4, n3, n6, n7, this.Pixel.Unpack, object));
    }

    @Override
    public void gl_tex_image_2d(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Object object) {
        this.Texture.set_tex_image(n, n2, n6, new GL_Image(n4, n5, n3, n7, n8, this.Pixel.Unpack, object));
    }

    @Override
    public void gl_tex_image_3d(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Object object) {
        this.Texture.set_tex_image(n, n2, n7, new GL_Image(n4, n5, n6, n3, n8, n9, this.Pixel.Unpack, object));
    }

    public void gl_get_tex_image(int n, int n2, int n3, int n4, Object object) {
        this.Texture.get_tex_image(n, n2).get_image(n3, n4, object);
    }

    public void gl_gen_textures(int n, int[] nArray) {
        int n2 = 0;
        for (int i = 0; i < this.TexList.size(); ++i) {
            if (this.TexList.elementAt(i) != null) continue;
            this.TexList.setElementAt(new GL_Texture_Obj(), i);
            nArray[n2++] = i;
        }
        while (n2 < n) {
            nArray[n2] = this.TexList.size();
            this.TexList.addElement(new GL_Texture_Obj());
            ++n2;
        }
    }

    public void gl_delete_textures(int n, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] >= this.TexList.size()) continue;
            this.TexList.setElementAt(null, nArray[i]);
        }
    }

    @Override
    public void gl_bind_texture(int n, int n2) {
        if (n2 >= this.TexList.size()) {
            return;
        }
        GL_Texture_Obj gL_Texture_Obj = this.TexList.elementAt(n2);
        if (gL_Texture_Obj == null) {
            return;
        }
        this.Texture.bind_texture(n, gL_Texture_Obj);
    }

    public boolean gl_is_texture(int n) {
        if (n >= this.TexList.size()) {
            return false;
        }
        return this.TexList.elementAt(n) != null;
    }

    @Override
    public void gl_tex_sub_image_1d(int n, int n2, int n3, int n4, int n5, int n6, Object object) {
        this.Texture.get_tex_image(n, n2).set_sub_image(n3, n4, n5, n6, this.Pixel.Unpack, object);
    }

    @Override
    public void gl_tex_sub_image_2d(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Object object) {
        this.Texture.get_tex_image(n, n2).set_sub_image(n3, n4, n5, n6, n7, n8, this.Pixel.Unpack, object);
    }

    @Override
    public void gl_tex_sub_image_3d(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Object object) {
        this.Texture.get_tex_image(n, n2).set_sub_image(n3, n4, n5, n6, n7, n8, n9, n10, this.Pixel.Unpack, object);
    }

    public int gl_map_1(int n, float f, float f2, int n2, int n3, float[][] fArray) {
        return this.Eval.set_map_1(n, f, f2, n2, n3, fArray);
    }

    public int gl_map_2(int n, float f, float f2, int n2, int n3, float f3, float f4, int n4, int n5, float[][][] fArray) {
        return this.Eval.set_map_2(n, f, f2, n2, n3, f3, f4, n4, n5, fArray);
    }

    public void gl_map_grid_1(int n, float f, float f2) {
        this.Eval.MapGrid1un = n;
        this.Eval.MapGrid1u1 = f;
        this.Eval.MapGrid1u2 = f2;
    }

    public void gl_map_grid_2(int n, float f, float f2, int n2, float f3, float f4) {
        this.Eval.MapGrid2un = n;
        this.Eval.MapGrid2u1 = f;
        this.Eval.MapGrid2u2 = f2;
        this.Eval.MapGrid2vn = n2;
        this.Eval.MapGrid2v1 = f3;
        this.Eval.MapGrid2v2 = f4;
    }

    public void gl_eval_point_1(int n) {
        this.gl_eval_coord_1(GL_Util.interpolate(n, this.Eval.MapGrid1un, this.Eval.MapGrid1u1, this.Eval.MapGrid1u2));
    }

    public void gl_eval_point_2(int n, int n2) {
        this.gl_eval_coord_2(GL_Util.interpolate(n, this.Eval.MapGrid2un, this.Eval.MapGrid2u1, this.Eval.MapGrid2u2), GL_Util.interpolate(n2, this.Eval.MapGrid2vn, this.Eval.MapGrid2v1, this.Eval.MapGrid2v2));
    }

    @Override
    public void gl_feedback_buffer(int n, int n2, float[] fArray) {
        switch (n2) {
            case 1536: {
                this.Feedback.Mask = 0;
                this.Feedback.Type = n2;
                break;
            }
            case 1537: {
                this.Feedback.Mask = 1;
                this.Feedback.Type = n2;
                break;
            }
            case 1538: {
                this.Feedback.Mask = 9;
                this.Feedback.Type = n2;
                break;
            }
            case 1539: {
                this.Feedback.Mask = 25;
                this.Feedback.Type = n2;
                break;
            }
            case 1540: {
                this.Feedback.Mask = 27;
                this.Feedback.Type = n2;
                break;
            }
            default: {
                this.Feedback.Mask = 0;
            }
        }
        this.Feedback.BufferSize = n;
        this.Feedback.Buffer = fArray;
        this.Feedback.BufferCount = 0;
    }

    @Override
    public void gl_pass_through(float f) {
        if (this.RenderMode == 7169) {
            this.Feedback.write_feedback_token(1792.0f);
            this.Feedback.write_feedback_token(f);
        }
    }

    @Override
    public void gl_select_buffer(int n, int[] nArray) {
        this.Select.set_buffer(n, nArray);
    }

    @Override
    public void gl_init_names() {
        this.Select.init_name();
    }

    @Override
    public void gl_load_name(int n) {
        if (!this.Select.load_name(n)) {
            this.gl_error(1282, "glLoadName");
        }
    }

    @Override
    public void gl_push_name(int n) {
        if (!this.Select.push_name(n)) {
            this.gl_error(1283, "glPushName");
        }
    }

    @Override
    public void gl_pop_name() {
        if (!this.Select.pop_name()) {
            this.gl_error(1284, "glPopName");
        }
    }

    public GL_Viewport getViewport() {
        return this.Viewport;
    }

    public void setViewport(GL_Viewport gL_Viewport) {
        this.Viewport = gL_Viewport;
    }
}

