/*
 * Decompiled with CFR 0.152.
 */
package org.jgl.context.attrib;

import org.jgl.context.GL_Context;

public class GL_ColorBuffer {
    private GL_Context CC;
    public int DrawBuffer;
    public int IndexMask = -1;
    public int ColorMask = -1;
    public float[] ClearColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    public int IntClearColor = -16777216;
    public int ClearIndex = 0;
    public boolean AlphaEnable = false;
    public int AlphaFunc = 519;
    public int AlphaRef = 0;
    public boolean BlendEnable = false;
    public int BlendSrc = 1;
    public int BlendDst = 0;
    public boolean LogicOPEnable = false;
    public int LogicOPMode = 5379;
    public boolean DitherEnable = true;
    public int[] Buffer;

    public void set_clear_color(float f, float f2, float f3, float f4) {
        this.ClearColor[0] = f;
        this.ClearColor[1] = f2;
        this.ClearColor[2] = f3;
        this.ClearColor[3] = f4;
        this.IntClearColor = 0xFF000000 | (int)(f * 255.0f) << 16 | (int)(f2 * 255.0f) << 8 | (int)(f3 * 255.0f);
    }

    public void set_color_mask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.ColorMask = bl ? (this.ColorMask |= 0xFF0000) : (this.ColorMask &= 0xFF00FFFF);
        this.ColorMask = bl2 ? (this.ColorMask |= 0xFF00) : (this.ColorMask &= 0xFFFF00FF);
        this.ColorMask = bl3 ? (this.ColorMask |= 0xFF) : (this.ColorMask &= 0xFFFFFF00);
        this.ColorMask = bl4 ? (this.ColorMask |= 0xFF000000) : (this.ColorMask &= 0xFFFFFF);
    }

    public void set_buffer(int n) {
        this.Buffer = new int[n];
    }

    public void clear_buffer(int n) {
        for (int i = 0; i < n; ++i) {
            this.Buffer[i] = this.IntClearColor;
        }
    }

    private void set_pixel(int n, int n2, int n3, byte[][][] byArray, byte by) {
        byArray[n][n2][n3] = by;
    }

    private void set_pixel(int n, int n2, int n3, short[][][] sArray, byte by) {
        sArray[n][n2][n3] = (short)(by & 0xFF);
    }

    private void set_pixel(int n, int n2, int n3, int[][][] nArray, byte by) {
        nArray[n][n2][n3] = by & 0xFF;
    }

    private void set_pixel(int n, int n2, int n3, float[][][] fArray, byte by) {
        fArray[n][n2][n3] = (float)by / 255.0f;
    }

    private void set_pixel(int n, int n2, int n3, int n4, Object object, byte by) {
        if (n4 == 8) {
            this.set_pixel(n, n2, n3, (byte[][][])object, by);
        }
        if (n4 == 16) {
            this.set_pixel(n, n2, n3, (short[][][])object, by);
        }
        if (n4 == 32) {
            this.set_pixel(n, n2, n3, (int[][][])object, by);
        }
        if (n4 == 64) {
            this.set_pixel(n, n2, n3, (float[][][])object, by);
        }
    }

    private byte get_pixel(int n, int n2, int n3, byte[][][] byArray) {
        return byArray[n][n2][n3];
    }

    private byte get_pixel(int n, int n2, int n3, short[][][] sArray) {
        return (byte)sArray[n][n2][n3];
    }

    private byte get_pixel(int n, int n2, int n3, int[][][] nArray) {
        return (byte)nArray[n][n2][n3];
    }

    private byte get_pixel(int n, int n2, int n3, float[][][] fArray) {
        return (byte)(fArray[n][n2][n3] * 255.0f);
    }

    private byte get_pixel(int n, int n2, int n3, int n4, Object object) {
        if (n4 == 8) {
            return this.get_pixel(n, n2, n3, (byte[][][])object);
        }
        if (n4 == 16) {
            return this.get_pixel(n, n2, n3, (short[][][])object);
        }
        if (n4 == 32) {
            return this.get_pixel(n, n2, n3, (int[][][])object);
        }
        if (n4 == 64) {
            return this.get_pixel(n, n2, n3, (float[][][])object);
        }
        return 0;
    }

    private byte cal_lum(byte by, byte by2, byte by3) {
        return (byte)((by + by2 + by3) / 3);
    }

    public void read_pixels(int n, int n2, int n3, int n4, int n5, int n6, Object object) {
        int n7 = n + this.CC.getViewport().Width * n2;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = -1;
        int n8 = this.CC.Pixel.Pack.SkipRows;
        for (int i = 0; i < n4; ++i) {
            int n9 = this.CC.Pixel.Pack.SkipPixels;
            n7 += this.CC.getViewport().Width - n3;
            for (int j = 0; j < n3; ++j) {
                by = (byte)((this.Buffer[n7] & 0xFF0000) >> 16);
                by2 = (byte)((this.Buffer[n7] & 0xFF00) >> 8);
                by3 = (byte)(this.Buffer[n7] & 0xFF);
                by4 = (byte)((this.Buffer[n7] & 0xFF000000) >> 24);
                switch (n5) {
                    case 6407: {
                        this.set_pixel(n8, n9, 0, n6, object, by);
                        this.set_pixel(n8, n9, 1, n6, object, by2);
                        this.set_pixel(n8, n9, 2, n6, object, by3);
                        break;
                    }
                    case 6408: {
                        this.set_pixel(n8, n9, 0, n6, object, by);
                        this.set_pixel(n8, n9, 1, n6, object, by2);
                        this.set_pixel(n8, n9, 2, n6, object, by3);
                        this.set_pixel(n8, n9, 3, n6, object, by4);
                        break;
                    }
                    case 6403: {
                        this.set_pixel(n8, n9, 0, n6, object, by);
                        break;
                    }
                    case 6404: {
                        this.set_pixel(n8, n9, 0, n6, object, by2);
                        break;
                    }
                    case 6405: {
                        this.set_pixel(n8, n9, 0, n6, object, by3);
                        break;
                    }
                    case 6406: {
                        this.set_pixel(n8, n9, 0, n6, object, by4);
                        break;
                    }
                    case 6409: {
                        this.set_pixel(n8, n9, 0, n6, object, this.cal_lum(by, by2, by3));
                        break;
                    }
                    case 6410: {
                        this.set_pixel(n8, n9, 0, n6, object, this.cal_lum(by, by2, by3));
                        this.set_pixel(n8, n9, 1, n6, object, by4);
                    }
                }
                ++n7;
                ++n9;
            }
            ++n8;
        }
    }

    public void draw_pixels(int n, int n2, int n3, int n4, Object object) {
        int n5 = 0;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        int n6 = -1;
        int n7 = this.CC.Pixel.Pack.SkipRows;
        for (int i = 0; i < n2; ++i) {
            int n8 = this.CC.Pixel.Pack.SkipPixels;
            n5 += this.CC.getViewport().Width - n;
            for (int j = 0; j < n; ++j) {
                switch (n3) {
                    case 6407: {
                        by = this.get_pixel(n7, n8, 0, n4, object);
                        by2 = this.get_pixel(n7, n8, 1, n4, object);
                        by3 = this.get_pixel(n7, n8, 2, n4, object);
                        break;
                    }
                    case 6408: {
                        by = this.get_pixel(n7, n8, 0, n4, object);
                        by2 = this.get_pixel(n7, n8, 1, n4, object);
                        by3 = this.get_pixel(n7, n8, 2, n4, object);
                        n6 = this.get_pixel(n7, n8, 3, n4, object);
                        break;
                    }
                    case 6403: {
                        by = this.get_pixel(n7, n8, 0, n4, object);
                        break;
                    }
                    case 6404: {
                        by2 = this.get_pixel(n7, n8, 0, n4, object);
                        break;
                    }
                    case 6405: {
                        by3 = this.get_pixel(n7, n8, 0, n4, object);
                        break;
                    }
                    case 6406: {
                        n6 = this.get_pixel(n7, n8, 0, n4, object);
                        break;
                    }
                    case 6409: {
                        by2 = by = this.get_pixel(n7, n8, 0, n4, object);
                        by3 = by;
                        break;
                    }
                    case 6410: {
                        by2 = by = this.get_pixel(n7, n8, 0, n4, object);
                        by3 = by;
                        n6 = this.get_pixel(n7, n8, 1, n4, object);
                    }
                }
                this.Buffer[n5++] = n6 << 24 | by << 16 | by2 << 8 | by3;
                ++n8;
            }
            ++n7;
        }
    }

    public void copy_pixels(int n, int n2, int n3, int n4) {
        int n5 = n + this.CC.getViewport().Width * n2;
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            n5 += this.CC.getViewport().Width - n3;
            n6 += this.CC.getViewport().Width - n3;
            for (int j = 0; j < n3; ++j) {
                this.Buffer[n6++] = this.Buffer[n5++];
            }
        }
    }

    public GL_ColorBuffer(GL_ColorBuffer gL_ColorBuffer) {
        this.CC = gL_ColorBuffer.CC;
        this.DrawBuffer = gL_ColorBuffer.DrawBuffer;
        this.ClearIndex = gL_ColorBuffer.ClearIndex;
        System.arraycopy(gL_ColorBuffer.ClearColor, 0, this.ClearColor, 0, 4);
        this.IndexMask = gL_ColorBuffer.IndexMask;
        this.ColorMask = gL_ColorBuffer.ColorMask;
        this.AlphaEnable = gL_ColorBuffer.AlphaEnable;
        this.AlphaFunc = gL_ColorBuffer.AlphaFunc;
        this.AlphaRef = gL_ColorBuffer.AlphaRef;
        this.BlendEnable = gL_ColorBuffer.BlendEnable;
        this.BlendSrc = gL_ColorBuffer.BlendSrc;
        this.BlendDst = gL_ColorBuffer.BlendDst;
        this.LogicOPEnable = gL_ColorBuffer.LogicOPEnable;
        this.LogicOPMode = gL_ColorBuffer.LogicOPMode;
        this.DitherEnable = gL_ColorBuffer.DitherEnable;
    }

    public GL_ColorBuffer(GL_Context gL_Context) {
        this.CC = gL_Context;
        this.Buffer = new int[gL_Context.getViewport().Width * gL_Context.getViewport().Height];
    }
}

