/*
 * Decompiled with CFR 0.152.
 */
package org.jgl.context.attrib;

import org.jgl.context.GL_Context;

public class GL_DepthBuffer {
    private GL_Context CC;
    public boolean Enable = false;
    public int Func = 513;
    public boolean Mask = true;
    public float Clear = 1.0f;
    public float[] Buffer;

    public boolean Test(float f, int n) {
        switch (this.Func) {
            case 512: {
                return false;
            }
            case 513: {
                return f < this.Buffer[n];
            }
            case 518: {
                return f >= this.Buffer[n];
            }
            case 515: {
                return f <= this.Buffer[n];
            }
            case 516: {
                return f > this.Buffer[n];
            }
            case 517: {
                return f != this.Buffer[n];
            }
            case 514: {
                return f == this.Buffer[n];
            }
            case 519: {
                return true;
            }
        }
        return true;
    }

    public void set_buffer(int n) {
        this.Buffer = new float[n];
    }

    public void clear_buffer(int n) {
        for (int i = 0; i < n; ++i) {
            this.Buffer[i] = this.Clear;
        }
    }

    private void set_pixel(int n, int n2, byte[][] byArray, float f) {
        byArray[n][n2] = (byte)(f * 127.0f);
    }

    private void set_pixel(int n, int n2, short[][] sArray, float f) {
        sArray[n][n2] = (short)(f * 32767.0f);
    }

    private void set_pixel(int n, int n2, int[][] nArray, float f) {
        nArray[n][n2] = (int)(f * 2.1474836E9f);
    }

    private void set_pixel(int n, int n2, float[][] fArray, float f) {
        fArray[n][n2] = f;
    }

    private float get_pixel(int n, int n2, byte[][] byArray) {
        return (float)byArray[n][n2] / 127.0f;
    }

    private float get_pixel(int n, int n2, short[][] sArray) {
        return (float)sArray[n][n2] / 32767.0f;
    }

    private float get_pixel(int n, int n2, int[][] nArray) {
        return (float)nArray[n][n2] / 2.1474836E9f;
    }

    private float get_pixel(int n, int n2, float[][] fArray) {
        return fArray[n][n2];
    }

    public void read_pixels(int n, int n2, int n3, int n4, int n5, Object object) {
        int n6 = n + this.CC.getViewport().Width * n2;
        int n7 = this.CC.Pixel.Pack.SkipRows;
        for (int i = 0; i < n4; ++i) {
            int n8 = this.CC.Pixel.Pack.SkipPixels;
            n6 += this.CC.getViewport().Width - n3;
            for (int j = 0; j < n3; ++j) {
                float f = this.Buffer[n6++];
                if (n5 == 8) {
                    this.set_pixel(n7, n8, (byte[][])object, f);
                }
                if (n5 == 16) {
                    this.set_pixel(n7, n8, (short[][])object, f);
                }
                if (n5 == 32) {
                    this.set_pixel(n7, n8, (int[][])object, f);
                }
                if (n5 == 64) {
                    this.set_pixel(n7, n8, (float[][])object, f);
                }
                ++n8;
            }
            ++n7;
        }
    }

    public void draw_pixels(int n, int n2, int n3, Object object) {
        int n4 = 0;
        float f = 0.0f;
        int n5 = this.CC.Pixel.Pack.SkipRows;
        for (int i = 0; i < n2; ++i) {
            int n6 = this.CC.Pixel.Pack.SkipPixels;
            n4 += this.CC.getViewport().Width - n;
            for (int j = 0; j < n; ++j) {
                if (n3 == 8) {
                    f = this.get_pixel(n5, n6, (byte[][])object);
                }
                if (n3 == 16) {
                    f = this.get_pixel(n5, n6, (short[][])object);
                }
                if (n3 == 32) {
                    f = this.get_pixel(n5, n6, (int[][])object);
                }
                if (n3 == 64) {
                    f = this.get_pixel(n5, n6, (float[][])object);
                }
                this.Buffer[n4++] = f;
                ++n6;
            }
            ++n5;
        }
    }

    public void copy_pixels(int n, int n2, int n3, int n4) {
        int n5 = n + this.CC.getViewport().Width * n2;
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            n5 += this.CC.getViewport().Width - n3;
            n6 += this.CC.getViewport().Width - n3;
            for (int j = 0; j < n3; ++j) {
                this.Buffer[n6++] = this.Buffer[n5++];
            }
        }
    }

    public GL_DepthBuffer(GL_DepthBuffer gL_DepthBuffer) {
        this.CC = gL_DepthBuffer.CC;
        this.Enable = gL_DepthBuffer.Enable;
        this.Func = gL_DepthBuffer.Func;
        this.Mask = gL_DepthBuffer.Mask;
        this.Clear = gL_DepthBuffer.Clear;
    }

    public GL_DepthBuffer(GL_Context gL_Context) {
        this.CC = gL_Context;
    }
}

