/*
 * Decompiled with CFR 0.152.
 */
package org.jgl.glu;

import org.jgl.GLU;
import org.jgl.glu.NURBS_Ct_Curves;
import org.jgl.glu.NURBS_Ct_Surfs;
import org.jgl.glu.NURBS_Curves;
import org.jgl.glu.NURBS_Knot;
import org.jgl.glu.NURBS_Surfaces;
import org.jgl.has.HasGLU;

public class GLUnurbsObj
extends HasGLU {
    public static final int GLU_NURBS_CURVE = 0;
    public static final int GLU_NURBS_SURFACE = 1;
    public static final int GLU_NURBS_TRIM = 2;
    public static final int GLU_NURBS_NO_TRIM = 3;
    public static final int GLU_NURBS_TRIM_DONE = 4;
    public static final int GLU_NURBS_NONE = 5;
    public static final int GLU_TRIM_NURBS = 0;
    public static final int GLU_TRIM_PWL = 1;
    public float sampling_tolerance = 50.0f;
    public int display_mode = 100012;
    public boolean culling = false;
    public boolean auto_load_matrix = true;
    public int error = 0;
    public int type = 5;
    public float[] sampling_model = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    public float[] sampling_proj = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    public int[] sampling_viewport = new int[4];
    public NURBS_Surfaces surface = new NURBS_Surfaces();
    public NURBS_Curves curve = new NURBS_Curves();

    private void set_new_t_min_t_max(NURBS_Knot nURBS_Knot, NURBS_Knot nURBS_Knot2, NURBS_Knot nURBS_Knot3, NURBS_Knot nURBS_Knot4, float f, float f2) {
        if (nURBS_Knot.unified_nknots != 0) {
            nURBS_Knot.set_new_min_max(f, f2);
        } else if (nURBS_Knot.nknots != 0) {
            nURBS_Knot.set_knot_min_max(f, f2);
        }
        if (nURBS_Knot2.unified_nknots != 0) {
            nURBS_Knot2.set_new_min_max(f, f2);
        }
        if (nURBS_Knot3.unified_nknots != 0) {
            nURBS_Knot3.set_new_min_max(f, f2);
        }
        if (nURBS_Knot4.unified_nknots != 0) {
            nURBS_Knot4.set_new_min_max(f, f2);
        }
    }

    private void select_knot_working_range(NURBS_Knot nURBS_Knot, NURBS_Knot nURBS_Knot2, NURBS_Knot nURBS_Knot3, NURBS_Knot nURBS_Knot4) {
        int n = nURBS_Knot.nknots;
        if (nURBS_Knot2.unified_nknots != 0) {
            n += nURBS_Knot2.nknots;
        }
        if (nURBS_Knot3.unified_nknots != 0) {
            n += nURBS_Knot3.nknots;
        }
        if (nURBS_Knot4.unified_nknots != 0) {
            n += nURBS_Knot4.nknots;
        }
        float f = nURBS_Knot.knot[nURBS_Knot.t_min];
        float f2 = nURBS_Knot.knot[nURBS_Knot.t_max];
        if (n != nURBS_Knot.nknots) {
            nURBS_Knot.unified_knot = new float[n];
            nURBS_Knot.unified_nknots = nURBS_Knot.nknots;
            System.arraycopy(nURBS_Knot.knot, 0, nURBS_Knot.unified_knot, 0, nURBS_Knot.nknots);
            if (nURBS_Knot2.unified_nknots != 0) {
                if (nURBS_Knot2.knot[nURBS_Knot2.t_min] > f) {
                    f = nURBS_Knot2.knot[nURBS_Knot2.t_min];
                }
                if (nURBS_Knot2.knot[nURBS_Knot2.t_max] < f2) {
                    f2 = nURBS_Knot2.knot[nURBS_Knot2.t_max];
                }
                nURBS_Knot2.unified_knot = new float[n];
                nURBS_Knot2.unified_nknots = nURBS_Knot2.nknots;
                System.arraycopy(nURBS_Knot2.knot, 0, nURBS_Knot2.unified_knot, 0, nURBS_Knot2.nknots);
            }
            if (nURBS_Knot3.unified_nknots != 0) {
                if (nURBS_Knot3.knot[nURBS_Knot3.t_min] > f) {
                    f = nURBS_Knot3.knot[nURBS_Knot3.t_min];
                }
                if (nURBS_Knot3.knot[nURBS_Knot3.t_max] < f2) {
                    f2 = nURBS_Knot3.knot[nURBS_Knot3.t_max];
                }
                nURBS_Knot3.unified_knot = new float[n];
                nURBS_Knot3.unified_nknots = nURBS_Knot3.nknots;
                System.arraycopy(nURBS_Knot3.knot, 0, nURBS_Knot3.unified_knot, 0, nURBS_Knot3.nknots);
            }
            if (nURBS_Knot4.unified_nknots != 0) {
                if (nURBS_Knot4.knot[nURBS_Knot4.t_min] > f) {
                    f = nURBS_Knot4.knot[nURBS_Knot4.t_min];
                }
                if (nURBS_Knot4.knot[nURBS_Knot4.t_max] < f2) {
                    f2 = nURBS_Knot4.knot[nURBS_Knot4.t_max];
                }
                nURBS_Knot4.unified_knot = new float[n];
                nURBS_Knot4.unified_nknots = nURBS_Knot4.nknots;
                System.arraycopy(nURBS_Knot4.knot, 0, nURBS_Knot4.unified_knot, 0, nURBS_Knot4.nknots);
            }
            if (f2 < f) {
                nURBS_Knot.unified_nknots = 0;
                nURBS_Knot2.unified_nknots = 0;
                nURBS_Knot3.unified_nknots = 0;
                nURBS_Knot4.unified_nknots = 0;
            } else {
                if (nURBS_Knot2.unified_nknots != 0) {
                    nURBS_Knot.collect(nURBS_Knot2, f, f2);
                }
                if (nURBS_Knot3.unified_nknots != 0) {
                    nURBS_Knot.collect(nURBS_Knot3, f, f2);
                }
                if (nURBS_Knot4.unified_nknots != 0) {
                    nURBS_Knot.collect(nURBS_Knot4, f, f2);
                }
                if (nURBS_Knot2.unified_nknots != 0) {
                    nURBS_Knot2.collect(nURBS_Knot, f, f2);
                }
                if (nURBS_Knot3.unified_nknots != 0) {
                    nURBS_Knot3.collect(nURBS_Knot, f, f2);
                }
                if (nURBS_Knot4.unified_nknots != 0) {
                    nURBS_Knot4.collect(nURBS_Knot, f, f2);
                }
                this.set_new_t_min_t_max(nURBS_Knot, nURBS_Knot2, nURBS_Knot3, nURBS_Knot4, f, f2);
            }
        } else {
            nURBS_Knot.unified_nknots = 0;
        }
    }

    private int convert_curves(NURBS_Ct_Curves nURBS_Ct_Curves) {
        NURBS_Knot nURBS_Knot = new NURBS_Knot();
        NURBS_Knot nURBS_Knot2 = new NURBS_Knot();
        NURBS_Knot nURBS_Knot3 = new NURBS_Knot();
        NURBS_Knot nURBS_Knot4 = new NURBS_Knot();
        int n = this.curve.fill_knot(nURBS_Knot, nURBS_Knot2, nURBS_Knot3, nURBS_Knot4);
        if (n != 0) {
            this.glu_error(n);
            return 100103;
        }
        this.select_knot_working_range(nURBS_Knot, nURBS_Knot2, nURBS_Knot3, nURBS_Knot4);
        nURBS_Ct_Curves.convert(nURBS_Knot, nURBS_Knot2, nURBS_Knot3, nURBS_Knot4, this.curve);
        return 0;
    }

    private int convert_surfaces(NURBS_Ct_Surfs nURBS_Ct_Surfs) {
        NURBS_Knot nURBS_Knot = new NURBS_Knot();
        NURBS_Knot nURBS_Knot2 = new NURBS_Knot();
        NURBS_Knot nURBS_Knot3 = new NURBS_Knot();
        NURBS_Knot nURBS_Knot4 = new NURBS_Knot();
        NURBS_Knot nURBS_Knot5 = new NURBS_Knot();
        NURBS_Knot nURBS_Knot6 = new NURBS_Knot();
        NURBS_Knot nURBS_Knot7 = new NURBS_Knot();
        NURBS_Knot nURBS_Knot8 = new NURBS_Knot();
        int n = this.surface.fill_knot(nURBS_Knot, nURBS_Knot2, nURBS_Knot3, nURBS_Knot4, nURBS_Knot5, nURBS_Knot6, nURBS_Knot7, nURBS_Knot8);
        if (n != 0) {
            this.glu_error(n);
            return 100103;
        }
        this.select_knot_working_range(nURBS_Knot, nURBS_Knot3, nURBS_Knot5, nURBS_Knot7);
        this.select_knot_working_range(nURBS_Knot2, nURBS_Knot4, nURBS_Knot6, nURBS_Knot8);
        nURBS_Ct_Surfs.convert(nURBS_Knot, nURBS_Knot2, nURBS_Knot3, nURBS_Knot4, nURBS_Knot5, nURBS_Knot6, nURBS_Knot7, nURBS_Knot8, this.surface);
        return 0;
    }

    private int calc_factor(float[][] fArray, int n, int n2, int n3) {
        double d;
        double d2;
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        int[] nArray = new int[4];
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        double[] dArray5 = new double[1];
        double[] dArray6 = new double[1];
        double[] dArray7 = new double[1];
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        this.gl.glGetDoublev(2982, dArray);
        this.gl.glGetDoublev(2983, dArray2);
        this.gl.glGetIntegerv(2978, nArray);
        if (n3 == 4) {
            d2 = fArray[n2][3];
            d = (double)fArray[n2][0] / d2;
            d3 = (double)fArray[n2][1] / d2;
            d4 = (double)fArray[n2][2] / d2;
        } else {
            d = fArray[n2][0];
            d3 = fArray[n2][1];
            d4 = fArray[n2][2];
        }
        this.glu.gluProject(d, d3, d4, dArray, dArray2, nArray, dArray3, dArray4, dArray7);
        for (int i = 1; i < n; ++i) {
            if (n3 == 4) {
                d2 = fArray[n2 + i][3];
                d = (double)fArray[n2 + i][0] / d2;
                d3 = (double)fArray[n2 + i][1] / d2;
                d4 = (double)fArray[n2 + i][2] / d2;
            } else {
                d = fArray[n2 + i][0];
                d3 = fArray[n2 + i][1];
                d4 = fArray[n2 + i][2];
            }
            if (this.glu.gluProject(d, d3, d4, dArray, dArray2, nArray, dArray5, dArray6, dArray7)) {
                double d6 = dArray5[0] - dArray3[0];
                double d7 = dArray6[0] - dArray4[0];
                d5 += Math.sqrt(d6 * d6 + d7 * d7);
            }
            dArray3[0] = dArray5[0];
            dArray4[0] = dArray6[0];
        }
        return (int)((d5 /= (double)this.sampling_tolerance) + 1.0);
    }

    private void sampling_2d(NURBS_Ct_Curves nURBS_Ct_Curves, int[] nArray) {
        this.glu_set_sampling_matrices();
        float[][] fArray = nURBS_Ct_Curves.geom.ctrl;
        for (int i = 0; i < nURBS_Ct_Curves.bezier_cnt; ++i) {
            int n = this.calc_factor(nURBS_Ct_Curves.geom.ctrl, this.curve.geom.c.order, i * this.curve.geom.c.order, this.curve.geom.dim);
            nArray[i] = n == 0 ? 1 : n;
        }
        this.glu_revert_sampling_matrices();
    }

    private void sampling_3d(NURBS_Ct_Surfs nURBS_Ct_Surfs, int[][] nArray, int[][] nArray2) {
        int n;
        int n2;
        int n3;
        int n4;
        this.glu_set_sampling_matrices();
        float[][][] fArray = nURBS_Ct_Surfs.geom.ctrl;
        for (n4 = 0; n4 < nURBS_Ct_Surfs.t_bezier_cnt; ++n4) {
            nArray2[n4][1] = n3 = this.calc_factor(fArray[0], this.surface.geom.t.order, n4 * this.surface.geom.t.order, this.surface.geom.dim);
            for (n2 = 1; n2 < nURBS_Ct_Surfs.s_bezier_cnt; ++n2) {
                n = this.calc_factor(fArray[n2 * this.surface.geom.s.order], this.surface.geom.t.order, n4 * this.surface.geom.t.order, this.surface.geom.dim);
                if (n <= n3) continue;
                n3 = n;
            }
            nArray2[n4][2] = n = this.calc_factor(fArray[n2 * this.surface.geom.s.order - 1], this.surface.geom.t.order, n4 * this.surface.geom.t.order, this.surface.geom.dim);
            nArray2[n4][0] = n > n3 ? n : n3;
        }
        fArray = new float[nURBS_Ct_Surfs.geom.t_pt_cnt][nURBS_Ct_Surfs.geom.s_pt_cnt][this.surface.geom.dim];
        for (n2 = 0; n2 < nURBS_Ct_Surfs.geom.s_pt_cnt; ++n2) {
            for (n4 = 0; n4 < nURBS_Ct_Surfs.geom.t_pt_cnt; ++n4) {
                fArray[n4][n2] = nURBS_Ct_Surfs.geom.ctrl[n2][n4];
            }
        }
        for (n4 = 0; n4 < nURBS_Ct_Surfs.t_bezier_cnt; ++n4) {
            nArray[n4][1] = n3 = this.calc_factor(fArray[0], this.surface.geom.s.order, n4 * this.surface.geom.s.order, this.surface.geom.dim);
            for (n2 = 1; n2 < nURBS_Ct_Surfs.s_bezier_cnt; ++n2) {
                n = this.calc_factor(fArray[n2 * this.surface.geom.t.order], this.surface.geom.s.order, n4 * this.surface.geom.s.order, this.surface.geom.dim);
                if (n <= n3) continue;
                n3 = n;
            }
            nArray[n4][2] = n = this.calc_factor(fArray[n2 * this.surface.geom.t.order - 1], this.surface.geom.s.order, n4 * this.surface.geom.s.order, this.surface.geom.dim);
            nArray[n4][0] = n > n3 ? n : n3;
        }
        this.glu_revert_sampling_matrices();
    }

    private boolean point_in_viewport(float[] fArray, int n) {
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        int[] nArray = new int[4];
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        double[] dArray5 = new double[1];
        this.gl.glGetDoublev(2982, dArray);
        this.gl.glGetDoublev(2983, dArray2);
        this.gl.glGetIntegerv(2978, nArray);
        if (n == 3) {
            double d = fArray[0];
            double d2 = fArray[1];
            double d3 = fArray[2];
            this.glu.gluProject(d, d2, d3, dArray, dArray2, nArray, dArray3, dArray4, dArray5);
        } else {
            double d = fArray[3];
            double d4 = (double)fArray[0] / d;
            double d5 = (double)fArray[1] / d;
            double d6 = (double)fArray[2] / d;
            this.glu.gluProject(d4, d5, d6, dArray, dArray2, nArray, dArray3, dArray4, dArray5);
        }
        return dArray3[0] >= (double)nArray[0] && dArray3[0] < (double)nArray[2] && dArray4[0] >= (double)nArray[1] && dArray4[0] < (double)nArray[3];
    }

    public boolean culling_test_2d(float[][] fArray, int n, int n2, int n3) {
        if (!this.culling) {
            return false;
        }
        this.glu_set_sampling_matrices();
        for (int i = 0; i < n; ++i) {
            if (!this.point_in_viewport(fArray[i], n3)) continue;
            return false;
        }
        this.glu_revert_sampling_matrices();
        return true;
    }

    public boolean culling_test_3d(float[][][] fArray, int n, int n2, int n3, int n4, int n5) {
        if (!this.culling) {
            return false;
        }
        this.glu_set_sampling_matrices();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (!this.point_in_viewport(fArray[i][j], n5)) continue;
                return false;
            }
        }
        this.glu_revert_sampling_matrices();
        return true;
    }

    private void do_curve() {
        NURBS_Ct_Curves nURBS_Ct_Curves = new NURBS_Ct_Curves(this.gl);
        int n = this.curve.test();
        if (n != 0) {
            this.glu_error(n);
            return;
        }
        if (this.convert_curves(nURBS_Ct_Curves) != 0) {
            return;
        }
        nURBS_Ct_Curves.augment(this.curve);
        int[] nArray = new int[nURBS_Ct_Curves.bezier_cnt];
        this.sampling_2d(nURBS_Ct_Curves, nArray);
        nURBS_Ct_Curves.draw(this, this.curve, nArray);
    }

    private void do_surface() {
        NURBS_Ct_Surfs nURBS_Ct_Surfs = new NURBS_Ct_Surfs(this.gl);
        int n = this.surface.test();
        if (n != 0) {
            this.glu_error(n);
            return;
        }
        if (this.convert_surfaces(nURBS_Ct_Surfs) != 0) {
            return;
        }
        nURBS_Ct_Surfs.augment(this.surface);
        int[][] nArray = new int[nURBS_Ct_Surfs.s_bezier_cnt][3];
        int[][] nArray2 = new int[nURBS_Ct_Surfs.t_bezier_cnt][3];
        this.sampling_3d(nURBS_Ct_Surfs, nArray, nArray2);
        nURBS_Ct_Surfs.draw(this, this.display_mode, this.surface, nArray, nArray2);
    }

    public void glu_error(int n) {
        this.error = n;
        System.out.print("NURBS error " + n + " ");
        this.glu.gluErrorString(n);
    }

    public void glu_load_sampling_matrices(float[] fArray, float[] fArray2, int[] nArray) {
        System.arraycopy(fArray, 0, this.sampling_model, 0, 16);
        System.arraycopy(fArray2, 0, this.sampling_proj, 0, 16);
        System.arraycopy(nArray, 0, this.sampling_viewport, 0, 4);
    }

    public void glu_set_sampling_matrices() {
        if (!this.auto_load_matrix) {
            this.gl.glPushAttrib(6144);
            this.gl.glViewport(this.sampling_viewport[0], this.sampling_viewport[1], this.sampling_viewport[2], this.sampling_viewport[3]);
            this.gl.glMatrixMode(5889);
            this.gl.glPushMatrix();
            this.gl.glLoadMatrixf(this.sampling_proj);
            this.gl.glMatrixMode(5888);
            this.gl.glPushMatrix();
            this.gl.glLoadMatrixf(this.sampling_model);
        }
    }

    public void glu_revert_sampling_matrices() {
        if (!this.auto_load_matrix) {
            this.gl.glMatrixMode(5888);
            this.gl.glPopMatrix();
            this.gl.glMatrixMode(5889);
            this.gl.glPopMatrix();
            this.gl.glPopAttrib();
        }
    }

    public void glu_set_sampling_tolerance(float f) {
        if (f <= 0.0f) {
            this.glu_error(100901);
            return;
        }
        this.sampling_tolerance = f;
    }

    public void glu_set_display_mode(int n) {
        if (n != 100012 && n != 100240 && n != 100241) {
            this.glu_error(100900);
            return;
        }
        if (this.type == 0) {
            this.glu_error(100276);
            return;
        }
        this.display_mode = n;
    }

    public void glu_set_culling(boolean bl) {
        this.culling = bl;
    }

    public void glu_set_auto_load_matrix(boolean bl) {
        this.auto_load_matrix = bl;
    }

    public void glu_begin_curve() {
        switch (this.type) {
            case 5: {
                this.type = 0;
                this.curve.geom.type = 100900;
                this.curve.color.type = 100900;
                this.curve.normal.type = 100900;
                this.curve.texture.type = 100900;
                break;
            }
            case 0: {
                this.glu_error(100256);
            }
        }
    }

    public void glu_end_curve() {
        switch (this.type) {
            case 5: {
                this.glu_error(100257);
                break;
            }
            default: {
                this.gl.glPushAttrib(73728);
                this.gl.glDisable(3479);
                this.gl.glDisable(3480);
                this.gl.glDisable(3473);
                this.gl.glDisable(3472);
                this.gl.glDisable(3474);
                this.gl.glDisable(3475);
                this.gl.glDisable(3476);
                this.gl.glDisable(3477);
                this.gl.glDisable(3478);
                this.do_curve();
                this.gl.glPopAttrib();
                this.type = 5;
            }
        }
    }

    public void glu_nurbs_curve(int n, float[] fArray, int n2, float[][] fArray2, int n3, int n4) {
        if (this.type == 3 || this.type == 2 || this.type == 4) {
            if (n4 == 3479 || n4 == 3480) {
                this.glu_error(100258);
                return;
            }
        } else if (this.type != 0) {
            this.glu_error(100261);
            return;
        }
        switch (n4) {
            case 3479: 
            case 3480: {
                this.curve.geom.fill(n, fArray, n2, fArray2, n3, n4);
                this.type = 3;
                break;
            }
            case 3472: 
            case 3473: {
                this.curve.color.fill(n, fArray, n2, fArray2, n3, n4);
                break;
            }
            case 3474: {
                this.curve.normal.fill(n, fArray, n2, fArray2, n3, n4);
                break;
            }
            case 3475: 
            case 3476: 
            case 3477: 
            case 3478: {
                this.curve.texture.fill(n, fArray, n2, fArray2, n3, n4);
                break;
            }
            default: {
                this.glu_error(100900);
                return;
            }
        }
    }

    public void glu_begin_surface() {
        switch (this.type) {
            case 5: {
                this.type = 1;
                this.surface.geom.type = 100900;
                this.surface.color.type = 100900;
                this.surface.normal.type = 100900;
                this.surface.texture.type = 100900;
                break;
            }
            case 2: {
                this.glu_error(100266);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.glu_error(100277);
                break;
            }
            case 0: {
                this.glu_error(100256);
            }
        }
    }

    public void glu_end_surface() {
        switch (this.type) {
            case 5: {
                this.glu_error(100263);
                break;
            }
            case 2: {
                this.glu_error(100262);
                break;
            }
            case 3: 
            case 4: {
                this.gl.glPushAttrib(73728);
                this.gl.glDisable(3511);
                this.gl.glDisable(3512);
                this.gl.glDisable(3505);
                this.gl.glDisable(3504);
                this.gl.glDisable(3506);
                this.gl.glDisable(3507);
                this.gl.glDisable(3508);
                this.gl.glDisable(3509);
                this.gl.glDisable(3510);
                this.do_surface();
                this.gl.glPopAttrib();
                break;
            }
            default: {
                this.glu_error(100258);
            }
        }
        this.type = 5;
    }

    public void glu_nurbs_surface(int n, float[] fArray, int n2, float[] fArray2, int n3, int n4, float[][][] fArray3, int n5, int n6, int n7) {
        if (this.type == 3 || this.type == 2 || this.type == 4) {
            if (n7 == 3511 || n7 == 3512) {
                this.glu_error(100258);
                return;
            }
        } else if (this.type != 1) {
            this.glu_error(100261);
            return;
        }
        switch (n7) {
            case 3511: 
            case 3512: {
                this.surface.geom.fill(n, fArray, n2, fArray2, n3, n4, fArray3, n5, n6, n7);
                this.type = 3;
                break;
            }
            case 3504: 
            case 3505: {
                this.surface.color.fill(n, fArray, n2, fArray2, n3, n4, fArray3, n5, n6, n7);
                break;
            }
            case 3506: {
                this.surface.normal.fill(n, fArray, n2, fArray2, n3, n4, fArray3, n5, n6, n7);
                break;
            }
            case 3507: 
            case 3508: 
            case 3509: 
            case 3510: {
                this.surface.texture.fill(n, fArray, n2, fArray2, n3, n4, fArray3, n5, n6, n7);
                break;
            }
            default: {
                this.glu_error(100900);
                return;
            }
        }
    }

    public GLUnurbsObj(GLU gLU) {
        super(gLU);
    }
}

