/*
 * Decompiled with CFR 0.152.
 */
package org.jgl.glu;

import org.jgl.GL;
import org.jgl.glu.GLUnurbsObj;
import org.jgl.glu.NURBS_Bz_Surface;
import org.jgl.glu.NURBS_Ct_Surf;
import org.jgl.glu.NURBS_Knot;
import org.jgl.glu.NURBS_Surfaces;
import org.jgl.has.HasGL;

public class NURBS_Ct_Surfs
extends HasGL {
    public NURBS_Ct_Surf geom;
    public NURBS_Ct_Surf color;
    public NURBS_Ct_Surf normal;
    public NURBS_Ct_Surf texture;
    public int s_bezier_cnt;
    public int t_bezier_cnt;

    public NURBS_Ct_Surfs(GL gL) {
        super(gL);
        this.geom = new NURBS_Ct_Surf(this.gl);
        this.color = new NURBS_Ct_Surf(this.gl);
        this.normal = new NURBS_Ct_Surf(this.gl);
        this.texture = new NURBS_Ct_Surf(this.gl);
        this.s_bezier_cnt = 0;
        this.t_bezier_cnt = 0;
    }

    public void draw(GLUnurbsObj gLUnurbsObj, int n, NURBS_Surfaces nURBS_Surfaces, int[][] nArray, int[][] nArray2) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        NURBS_Bz_Surface nURBS_Bz_Surface = new NURBS_Bz_Surface(this.gl);
        nURBS_Bz_Surface.set_property(n, nArray, nArray2, this.s_bezier_cnt, this.t_bezier_cnt);
        this.gl.glEnable(nURBS_Surfaces.geom.type);
        if (this.color.ctrl != null) {
            this.gl.glEnable(nURBS_Surfaces.color.type);
            bl3 = true;
        } else {
            bl3 = false;
        }
        if (this.normal.ctrl != null) {
            this.gl.glEnable(nURBS_Surfaces.normal.type);
            bl2 = true;
        } else {
            bl2 = false;
        }
        if (this.texture.ctrl != null) {
            this.gl.glEnable(nURBS_Surfaces.texture.type);
            bl = true;
        } else {
            bl = false;
        }
        for (int i = 0; i < this.s_bezier_cnt; ++i) {
            for (int j = 0; j < this.t_bezier_cnt; ++j) {
                if (gLUnurbsObj.culling_test_3d(this.geom.offsets[i][j], nURBS_Surfaces.geom.s.order, nURBS_Surfaces.geom.t.order, this.geom.s_stride, this.geom.t_stride, nURBS_Surfaces.geom.dim)) continue;
                this.geom.draw(nURBS_Surfaces.geom, i, j);
                if (bl3) {
                    this.color.draw(nURBS_Surfaces.color, i, j);
                }
                if (bl2) {
                    this.normal.draw(nURBS_Surfaces.normal, i, j);
                }
                if (bl) {
                    this.texture.draw(nURBS_Surfaces.texture, i, j);
                }
                nURBS_Bz_Surface.map(i, j);
            }
        }
    }

    public void augment(NURBS_Surfaces nURBS_Surfaces) {
        this.s_bezier_cnt = this.geom.s_pt_cnt / nURBS_Surfaces.geom.s.order;
        this.t_bezier_cnt = this.geom.t_pt_cnt / nURBS_Surfaces.geom.t.order;
        this.geom.augment(this.s_bezier_cnt, this.t_bezier_cnt, nURBS_Surfaces.geom);
        if (this.color.ctrl != null) {
            this.color.augment(this.s_bezier_cnt, this.t_bezier_cnt, nURBS_Surfaces.color);
        }
        if (this.normal.ctrl != null) {
            this.normal.augment(this.s_bezier_cnt, this.t_bezier_cnt, nURBS_Surfaces.normal);
        }
        if (this.texture.ctrl != null) {
            this.texture.augment(this.s_bezier_cnt, this.t_bezier_cnt, nURBS_Surfaces.texture);
        }
    }

    public void convert(NURBS_Knot nURBS_Knot, NURBS_Knot nURBS_Knot2, NURBS_Knot nURBS_Knot3, NURBS_Knot nURBS_Knot4, NURBS_Knot nURBS_Knot5, NURBS_Knot nURBS_Knot6, NURBS_Knot nURBS_Knot7, NURBS_Knot nURBS_Knot8, NURBS_Surfaces nURBS_Surfaces) {
        this.geom.convert(nURBS_Knot, nURBS_Knot2, nURBS_Surfaces.geom);
        if (nURBS_Knot3.unified_nknots != 0) {
            this.color.convert(nURBS_Knot3, nURBS_Knot4, nURBS_Surfaces.color);
        }
        if (nURBS_Knot5.unified_nknots != 0) {
            this.normal.convert(nURBS_Knot5, nURBS_Knot6, nURBS_Surfaces.normal);
        }
        if (nURBS_Knot7.unified_nknots != 0) {
            this.texture.convert(nURBS_Knot7, nURBS_Knot8, nURBS_Surfaces.texture);
        }
    }
}

