/*
 * Decompiled with CFR 0.152.
 */
package org.jgl.glu;

import org.jgl.glu.NURBS_Object;

public class NURBS_Knot {
    public float[] knot;
    public int nknots = 0;
    public float[] unified_knot;
    public int unified_nknots = 0;
    public int order;
    public int t_min;
    public int t_max;
    public int delta_nknots = 0;
    public float[] new_knot;
    public float[][] alpha;

    private void swap(float[] fArray, int n, int n2) {
        float f = fArray[n];
        fArray[n] = fArray[n2];
        fArray[n2] = f;
    }

    private void quicksort(float[] fArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            float f = fArray[(n + n2) / 2];
            while (n3 <= n4) {
                while (n3 < n2 && fArray[n3] < f) {
                    ++n3;
                }
                while (n4 > n && fArray[n4] > f) {
                    --n4;
                }
                if (n3 > n4) continue;
                this.swap(fArray, n3, n4);
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.quicksort(fArray, n, n4);
            }
            if (n3 < n2) {
                this.quicksort(fArray, n3, n2);
            }
        }
    }

    public int calc_new_ctrl_pts(float[][] fArray, int n, int n2, float[][][] fArray2, int n3) {
        int n4 = this.nknots - this.order;
        int n5 = this.t_max + 1 - this.t_min - this.order;
        int n6 = this.t_min;
        fArray2[n3] = new float[n5][n2];
        for (int i = 0; i < n5; ++i) {
            int n7;
            for (n7 = 0; n7 < n2; ++n7) {
                fArray2[n3][i][n7] = 0.0f;
            }
            for (int j = 0; j < n4; ++j) {
                for (n7 = 0; n7 < n2; ++n7) {
                    float[] fArray3 = fArray2[n3][i];
                    int n8 = n7;
                    fArray3[n8] = fArray3[n8] + this.alpha[i + n6][j] * fArray[j][n7];
                }
            }
        }
        return n5;
    }

    public void calc_alphas() {
        int n;
        int n2;
        int n3 = this.nknots - this.order;
        int n4 = n3 + this.delta_nknots;
        this.alpha = new float[n4][n3];
        float[][] fArray = new float[n4][n3];
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                this.alpha[n2][n] = this.knot[n] <= this.new_knot[n2] && this.new_knot[n2] < this.knot[n + 1] ? 1.0f : 0.0f;
            }
        }
        for (int i = 1; i < this.order; ++i) {
            for (n2 = 0; n2 < n4; ++n2) {
                for (n = 0; n < n3; ++n) {
                    float f = this.knot[n + i] - this.knot[n];
                    float f2 = f == 0.0f ? 0.0f : (this.new_knot[n2 + i] - this.knot[n]) / f * this.alpha[n2][n];
                    f = this.knot[n + i + 1] - this.knot[n + 1];
                    if (f != 0.0f) {
                        f2 += (this.knot[n + i + 1] - this.new_knot[n2 + i]) / f * this.alpha[n2][n + 1];
                    }
                    fArray[n2][n] = f2;
                }
            }
            float[][] fArray2 = fArray;
            fArray = this.alpha;
            this.alpha = fArray2;
        }
    }

    public void explode() {
        float f;
        int n;
        int n2;
        int n3;
        float[] fArray;
        int n4 = 0;
        if (this.unified_nknots != 0) {
            fArray = this.unified_knot;
            n3 = this.unified_nknots;
        } else {
            fArray = this.knot;
            n3 = this.nknots;
        }
        for (n = this.t_min; n <= this.t_max; n += n2) {
            f = fArray[n];
            for (n2 = 1; n2 < this.order && n + n2 <= this.t_max && f == fArray[n + n2]; ++n2) {
            }
            n4 += this.order - n2;
        }
        this.new_knot = new float[n3 + n4];
        System.arraycopy(fArray, 0, this.new_knot, 0, this.t_min);
        int n5 = this.t_min;
        for (n = this.t_min; n <= this.t_max; ++n) {
            f = fArray[n];
            for (n2 = 0; n2 < this.order; ++n2) {
                this.new_knot[n5++] = fArray[n];
                if (n == this.t_max || f != fArray[n + 1]) continue;
                ++n;
            }
        }
        System.arraycopy(fArray, this.t_max + 1, this.new_knot, n5, n3 - this.t_max - 1);
        this.delta_nknots += n4;
        this.t_max += n4;
    }

    private void set_min_max(float[] fArray, int n, float f, float f2) {
        int n2;
        int n3 = n - 1;
        for (n2 = 0; n2 < n && fArray[n2] != f; ++n2) {
        }
        while (n3 > 0 && fArray[n3] != f2) {
            --n3;
        }
        this.t_min = n2;
        this.t_max = n3;
    }

    public void set_knot_min_max(float f, float f2) {
        this.set_min_max(this.knot, this.nknots, f, f2);
    }

    public void set_new_min_max(float f, float f2) {
        this.set_min_max(this.unified_knot, this.unified_nknots, f, f2);
    }

    public void collect(NURBS_Knot nURBS_Knot, float f, float f2) {
        int n = this.unified_nknots;
        int n2 = this.t_max;
        for (int i = nURBS_Knot.t_min; i <= nURBS_Knot.t_max; ++i) {
            int n3;
            if (!(nURBS_Knot.unified_knot[i] > f) || !(nURBS_Knot.unified_knot[i] < f2)) continue;
            for (n3 = this.t_min; n3 <= n2 && this.unified_knot[n3] != nURBS_Knot.unified_knot[i]; ++n3) {
            }
            if (n3 <= n2) continue;
            this.unified_knot[n++] = nURBS_Knot.unified_knot[i];
            ++this.t_max;
            ++this.delta_nknots;
        }
        this.unified_nknots = n;
        this.quicksort(this.unified_knot, 0, n);
    }

    public int fill(NURBS_Object nURBS_Object) {
        this.unified_nknots = 1;
        this.knot = nURBS_Object.knot;
        this.nknots = nURBS_Object.knot_count;
        this.order = nURBS_Object.order;
        this.t_min = this.order - 1;
        this.t_max = this.nknots - this.order;
        if (this.knot[this.t_min] == this.knot[this.t_max]) {
            return 100253;
        }
        return 0;
    }
}

