/*
 * Decompiled with CFR 0.152.
 */
package br.com.abby.animation.skeletal;

import br.com.abby.GLDrawable;
import br.com.abby.animation.skeletal.Joint;
import br.com.abby.linear.AimPoint;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jgl.GLAUX;
import org.lwjgl.util.vector.Vector3f;

public class Bone
implements GLDrawable {
    private String name;
    protected Color color = Color.WHITE;
    private double size;
    private double angleX = 0.0;
    private double angleY = 0.0;
    private double angleZ = 0.0;
    private List<Vector3f> vectors = new ArrayList<Vector3f>();
    private Joint orign = null;
    protected Joint end = null;

    public Bone(String string) {
    }

    public Bone(double d) {
        this.setSize(d);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOrign(Joint joint) {
        this.orign = joint;
        this.end.translate(joint.getX(), joint.getY(), joint.getZ());
    }

    public void translate(double d, double d2, double d3) {
        if (this.vectors != null) {
            for (Vector3f vector3f : this.vectors) {
                double d4 = vector3f.getX();
                double d5 = vector3f.getY();
                double d6 = vector3f.getZ();
                double d7 = d4 + d;
                double d8 = d5 + d2;
                double d9 = d6 + d3;
                vector3f.setX((float)d7);
                vector3f.setY((float)d8);
                vector3f.setZ((float)d9);
            }
        }
        if (this.end != null) {
            this.end.translate(d, d2, d3);
        }
    }

    public void rotateX(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.orign != null) {
            d2 = this.orign.getX();
            d3 = this.orign.getY();
            d4 = this.orign.getZ();
        }
        this.rotateX(d, d2, d3, d4);
    }

    public void rotateY(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.orign != null) {
            d2 = this.orign.getX();
            d3 = this.orign.getY();
            d4 = this.orign.getZ();
        }
        this.rotateY(d, d2, d3, d4);
    }

    public void rotateZ(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.orign != null) {
            d2 = this.orign.getX();
            d3 = this.orign.getY();
            d4 = this.orign.getZ();
        }
        this.rotateZ(d, d2, d3, d4);
    }

    public void rotateX(double d, double d2, double d3, double d4) {
        this.angleX += d;
        this.rotateOver(d, d2, d3, d4, AimPoint.rotationMatrixX(d, d2, d3, d4));
        this.end.rotateXOver(d, d2, d3, d4);
    }

    public void rotateY(double d, double d2, double d3, double d4) {
        this.angleY += d;
        this.rotateOver(d, d2, d3, d4, AimPoint.rotationMatrixY(d, d2, d3, d4));
        this.end.rotateYOver(d, d2, d3, d4);
    }

    public void rotateZ(double d, double d2, double d3, double d4) {
        this.angleZ += d;
        this.rotateOver(d, d2, d3, d4, AimPoint.rotationMatrixZ(d, d2, d3, d4));
        this.end.rotateZOver(d, d2, d3, d4);
    }

    private void rotateOver(double d, double d2, double d3, double d4, double[][] dArray) {
        if (this.vectors != null) {
            for (Vector3f vector3f : this.vectors) {
                double d5 = vector3f.getX();
                double d6 = vector3f.getY();
                double d7 = vector3f.getZ();
                double d8 = d5 * dArray[0][0] + d6 * dArray[0][1] + d7 * dArray[0][2] + dArray[0][3];
                double d9 = d5 * dArray[1][0] + d6 * dArray[1][1] + d7 * dArray[1][2] + dArray[1][3];
                double d10 = d5 * dArray[2][0] + d6 * dArray[2][1] + d7 * dArray[2][2] + dArray[2][3];
                vector3f.setX((float)d8);
                vector3f.setY((float)d9);
                vector3f.setZ((float)d10);
            }
        }
        this.rotateEndJoint(d, d2, d3, d4, dArray);
    }

    private void rotateEndJoint(double d, double d2, double d3, double d4, double[][] dArray) {
        if (this.end == null) {
            return;
        }
        double d5 = this.end.getX();
        double d6 = this.end.getY();
        double d7 = this.end.getZ();
        double d8 = d5 * dArray[0][0] + d6 * dArray[0][1] + d7 * dArray[0][2] + 1.0 * dArray[0][3];
        double d9 = d5 * dArray[1][0] + d6 * dArray[1][1] + d7 * dArray[1][2] + 1.0 * dArray[1][3];
        double d10 = d5 * dArray[2][0] + d6 * dArray[2][1] + d7 * dArray[2][2] + 1.0 * dArray[2][3];
        this.end.setX(d8);
        this.end.setY(d9);
        this.end.setZ(d10);
    }

    public List<Vector3f> getVectors() {
        return this.vectors;
    }

    public void addVectors(List<Vector3f> list) {
        this.vectors.addAll(list);
    }

    @Override
    public void draw(GLAUX gLAUX) {
        gLAUX.glColor3i(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        gLAUX.glBegin(2);
        gLAUX.glVertex3d(this.orign.getX(), this.orign.getY(), this.orign.getZ());
        gLAUX.glVertex3d(this.end.getX(), this.end.getY(), this.end.getZ());
        gLAUX.glEnd();
        this.end.draw(gLAUX);
    }

    public void drawVertexes(GLAUX gLAUX) {
        double d = 0.005;
        for (Vector3f vector3f : this.vectors) {
            gLAUX.glPushMatrix();
            gLAUX.glTranslated(vector3f.getX(), vector3f.getY(), vector3f.getZ());
            gLAUX.auxSolidCube(d);
            gLAUX.glPopMatrix();
        }
    }

    public Joint getEnd() {
        return this.end;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public double getAngleX() {
        return this.angleX;
    }

    public double getAngleY() {
        return this.angleY;
    }

    public void setAngleZ(double d) {
        this.angleZ = d;
    }

    public double getAngleZ() {
        return this.angleZ;
    }

    public void setSize(double d) {
        this.size = d;
        this.end = new Joint(d, 0.0, 0.0);
    }

    public double getSize() {
        return this.size;
    }

    public void append(Bone bone) {
        this.end.addBone(bone);
    }
}

