/*
 * Decompiled with CFR 0.152.
 */
package br.com.abby.linear;

import br.com.abby.GLDrawable;
import br.com.abby.linear.AimPoint;
import br.com.abby.loader.MeshLoader;
import br.com.abby.material.Texture;
import br.com.abby.vbo.Face;
import br.com.abby.vbo.Group;
import br.com.abby.vbo.VBO;
import br.com.etyllica.core.loader.image.ImageLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgl.GL;
import org.jgl.GLAUX;
import org.lwjgl.util.vector.Vector3f;

public class Model3D
extends AimPoint
implements GLDrawable {
    private VBO vbo;
    private double scale = 1.0;
    private Set<Integer> vertexSelection = new HashSet<Integer>();
    private boolean drawTexture = true;
    private boolean drawFaces = true;
    private boolean drawVertices = true;
    public Integer specialVertex = 0;
    private Map<String, Texture> textureMap = new HashMap<String, Texture>();

    public Model3D(String string) {
        super(0.0, 0.0, 0.0);
        this.vbo = MeshLoader.getInstance().loadModel(string);
    }

    @Override
    public void draw(GLAUX gLAUX) {
        gLAUX.glPushMatrix();
        gLAUX.glColor3i(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        if (this.scale != 1.0) {
            gLAUX.glScaled(2.0, 2.0, 2.0);
        }
        gLAUX.glRotated(this.angleY, 0.0, 1.0, 0.0);
        gLAUX.glRotated(this.angleZ, 0.0, 0.0, 1.0);
        this.drawFaces(gLAUX);
        gLAUX.glPopMatrix();
    }

    private void drawFaces(GLAUX gLAUX) {
        if (!this.drawFaces) {
            return;
        }
        for (Group group : this.vbo.getGroups()) {
            String string = group.getMaterial().getMapD();
            if (!string.isEmpty()) {
                Texture texture = this.getTexture(string);
                if (this.drawTexture) {
                    this.setTexture(gLAUX, texture);
                    gLAUX.glEnable(2929);
                    gLAUX.glEnable(3553);
                    gLAUX.glEnable(2884);
                }
                float f = 1.0f;
                float f2 = -3.0f;
                float f3 = 1.0f;
            }
            for (Face face : group.getFaces()) {
                if (face.vertexIndex.length == 3) {
                    gLAUX.glBegin(5);
                } else {
                    gLAUX.glBegin(8);
                }
                for (int i = 0; i < face.vertexIndex.length; ++i) {
                    if (this.drawTexture) {
                        gLAUX.glNormal3d(face.normal[i].getX(), face.normal[i].getY(), face.normal[i].getZ());
                        gLAUX.glTexCoord2d(face.texture[i].getX(), face.texture[i].getY());
                    }
                    int n = face.vertexIndex[i];
                    Vector3f vector3f = this.vbo.getVertices().get(n);
                    gLAUX.glVertex3d(vector3f.getX(), vector3f.getY(), vector3f.getZ());
                }
                gLAUX.glEnd();
            }
        }
    }

    private Texture getTexture(String string) {
        Texture texture = this.textureMap.get(string);
        if (texture == null) {
            System.out.println("Trying to load: " + string);
            texture = new Texture(ImageLoader.getInstance().getImage(string, true));
            this.textureMap.put(string, texture);
        }
        return texture;
    }

    public void drawVertexes(GLAUX gLAUX) {
        double d = 0.015;
        List<Vector3f> list = this.vbo.getVertices();
        for (int i = 0; i < list.size(); ++i) {
            if (this.vertexSelection.contains(i)) {
                gLAUX.glColor3i(255, 255, 255);
            } else {
                gLAUX.glColor3i(102, 68, 68);
            }
            if (i == this.specialVertex) {
                gLAUX.glColor3i(255, 255, 0);
                d *= 2.0;
            }
            gLAUX.glPushMatrix();
            gLAUX.glTranslated(list.get(i).getX(), list.get(i).getY(), list.get(i).getZ());
            gLAUX.auxSolidCube(d);
            gLAUX.glPopMatrix();
        }
    }

    protected void setTexture(GL gL, Texture texture) {
        gL.glTexImage2D(3553, 0, 6407, texture.getW(), texture.getH(), 0, 6407, 5121, texture.getBytes());
    }

    protected void setAlphaTexture(GL gL, Texture texture) {
        gL.glTexImage2D(3553, 0, 6408, texture.getW(), texture.getH(), 0, 6408, 5121, texture.getAlphaBytes());
        gL.glEnable(3042);
        gL.glBlendFunc(770, 771);
    }

    public Set<Integer> getVertexSelection() {
        return this.vertexSelection;
    }

    public void setVertexSelection(Set<Integer> set) {
        this.vertexSelection = set;
    }

    public boolean isDrawTexture() {
        return this.drawTexture;
    }

    public void setDrawTexture(boolean bl) {
        this.drawTexture = bl;
    }

    public boolean isDrawFaces() {
        return this.drawFaces;
    }

    public void setDrawFaces(boolean bl) {
        this.drawFaces = bl;
    }

    public boolean isDrawVertices() {
        return this.drawVertices;
    }

    public void setDrawVertices(boolean bl) {
        this.drawVertices = bl;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public VBO getVbo() {
        return this.vbo;
    }

    public void setVbo(VBO vBO) {
        this.vbo = vBO;
    }
}

