/*
 * Decompiled with CFR 0.152.
 */
package br.com.abby.loader;

import br.com.abby.loader.StreamParser;
import br.com.abby.loader.VBOLoader;
import br.com.abby.vbo.Face;
import br.com.abby.vbo.VBO;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class Max3DLoader
extends StreamParser
implements VBOLoader {
    private final int IDENTIFIER_3DS = 19789;
    private final int MESH_BLOCK = 15677;
    private final int OBJECT_BLOCK = 16384;
    private final int TRIMESH = 16640;
    private final int TRI_MATERIAL = 16688;
    private final int VERTICES = 16656;
    private final int FACES = 16672;
    private final int TEXCOORD = 16704;
    private final int TEX_MAP = 41472;
    private final int TEX_NAME = 40960;
    private final int TEX_FILENAME = 41728;
    private final int MATERIAL = 45055;
    private int chunkID;
    private int chunkEndOffset;
    private boolean endReached;
    private String currentObjName;

    @Override
    public VBO loadModel(URL uRL) throws FileNotFoundException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        VBO vBO = new VBO();
        this.readHeader(bufferedInputStream, vBO);
        if (this.chunkID != 19789) {
            System.err.println("Not a valid .3DS file!");
            return null;
        }
        while (!this.endReached) {
            this.readChunk(bufferedInputStream, vBO);
        }
        return null;
    }

    private void readHeader(InputStream inputStream, VBO vBO) throws IOException {
        this.chunkID = this.readShort(inputStream);
        this.chunkEndOffset = this.readInt(inputStream);
        this.endReached = this.chunkID < 0;
    }

    private void readChunk(InputStream inputStream, VBO vBO) throws IOException {
        this.readHeader(inputStream, vBO);
        switch (this.chunkID) {
            case 15677: {
                break;
            }
            case 16384: {
                this.currentObjName = this.readString(inputStream);
                break;
            }
            case 16640: {
                vBO.setName(this.currentObjName);
                break;
            }
            case 16656: {
                this.readVertices(inputStream, vBO);
                break;
            }
            case 16672: {
                this.readFaces(inputStream, vBO);
                break;
            }
            case 16704: {
                this.readTexCoords(inputStream, vBO);
                break;
            }
            case 40960: {
                break;
            }
            case 41728: {
                String string = this.readString(inputStream);
                break;
            }
            case 16688: {
                String string = this.readString(inputStream);
                int n = this.readShort(inputStream);
                for (int i = 0; i < n; ++i) {
                    int n2 = this.readShort(inputStream);
                }
                break;
            }
            case 45055: {
                break;
            }
            case 41472: {
                break;
            }
            default: {
                this.skipRead(inputStream);
            }
        }
    }

    private void skipRead(InputStream inputStream) throws IOException {
        for (int i = 0; i < this.chunkEndOffset - 6 && !this.endReached; ++i) {
            this.endReached = inputStream.read() < 0;
        }
    }

    private void readVertices(InputStream inputStream, VBO vBO) throws IOException {
        int n = this.readShort(inputStream);
        for (int i = 0; i < n; ++i) {
            float f = this.readFloat(inputStream);
            float f2 = this.readFloat(inputStream);
            float f3 = this.readFloat(inputStream);
            float f4 = f2;
            f2 = f3;
            f3 = -f4;
            vBO.getVertices().add(new Vector3f(f, f2, f3));
        }
    }

    private void readFaces(InputStream inputStream, VBO vBO) throws IOException {
        int n = this.readShort(inputStream);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[0] = this.readShort(inputStream);
            nArray[1] = this.readShort(inputStream);
            nArray[2] = this.readShort(inputStream);
            this.readShort(inputStream);
            Face face = new Face(3);
            face.vertexIndex = nArray;
            vBO.getFaces().add(face);
        }
    }

    private void readTexCoords(InputStream inputStream, VBO vBO) throws IOException {
        int n = this.readShort(inputStream);
        for (int i = 0; i < n; ++i) {
            Vector2f vector2f = new Vector2f();
            vector2f.x = this.readFloat(inputStream);
            vector2f.y = this.readFloat(inputStream) * -1.0f;
            vBO.getTextures().add(vector2f);
        }
    }
}

