/*
 * Decompiled with CFR 0.152.
 */
package org.jgl.context.render;

import org.jgl.context.GL_Context;
import org.jgl.context.GL_Vertex;
import org.jgl.context.render.GL_Render;

public class GL_Depth
extends GL_Render {
    protected float[] LineZ = new float[2];
    protected float z;
    protected float dzdx = 0.0f;
    protected float dzdy = 0.0f;
    private float[] TriZ = new float[3];
    protected float LeftPointZ;
    private float dzdxy;
    private float dzdyy;

    protected void init_z(GL_Vertex gL_Vertex, GL_Vertex gL_Vertex2) {
        this.LineZ[0] = gL_Vertex.Vertex[2];
        this.LineZ[1] = gL_Vertex2.Vertex[2];
    }

    @Override
    protected void init(GL_Vertex gL_Vertex, GL_Vertex gL_Vertex2) {
        super.init(gL_Vertex, gL_Vertex2);
        this.init_z(gL_Vertex, gL_Vertex2);
    }

    protected void set_first_z() {
        this.z = this.LineZ[0];
    }

    @Override
    protected void set_first_point() {
        super.set_first_point();
        this.set_first_z();
    }

    protected void init_z_dx(int n) {
        this.dzdx = (this.LineZ[1] - this.LineZ[0]) / (float)n;
    }

    protected void init_z_dy(int n) {
        this.dzdy = (this.LineZ[1] - this.LineZ[0]) / (float)n;
    }

    @Override
    protected void init_dx(int n) {
        this.init_z_dx(n);
    }

    @Override
    protected void init_dy(int n) {
        this.init_z_dy(n);
    }

    protected void z_inc_x() {
        this.z += this.dzdx;
    }

    protected void z_dec_x() {
        this.z -= this.dzdx;
    }

    protected void z_inc_y() {
        this.z += this.dzdy;
    }

    @Override
    protected void inc_x() {
        super.inc_x();
        this.z_inc_x();
    }

    @Override
    protected void dec_x() {
        super.dec_x();
        this.z_dec_x();
    }

    @Override
    protected void inc_y() {
        super.inc_y();
        this.z_inc_y();
    }

    @Override
    protected void put_pixel() {
        this.pixel.put_pixel(this.x, this.y, this.z, this.color);
    }

    @Override
    protected void put_pixel_by_index() {
        this.pixel.put_pixel_by_index(this.x, this.z, this.color);
    }

    protected void draw_horizontal_line(int n, int n2, int n3, float f) {
        this.LineZ[0] = f;
        this.draw_horizontal_line(n, n2, n3);
    }

    protected void init_z(GL_Vertex gL_Vertex, GL_Vertex gL_Vertex2, GL_Vertex gL_Vertex3) {
        this.TriZ[0] = gL_Vertex.Vertex[2];
        this.TriZ[1] = gL_Vertex2.Vertex[2];
        this.TriZ[2] = gL_Vertex3.Vertex[2];
    }

    @Override
    protected void init(GL_Vertex gL_Vertex, GL_Vertex gL_Vertex2, GL_Vertex gL_Vertex3) {
        super.init(gL_Vertex, gL_Vertex2, gL_Vertex3);
        this.init_z(gL_Vertex, gL_Vertex2, gL_Vertex3);
    }

    protected void set_left_z(int n) {
        this.LeftPointZ = this.TriZ[n];
    }

    @Override
    protected void set_left(int n) {
        super.set_left(n);
        this.set_left_z(n);
    }

    protected void init_z_dx_dy(int n, int n2, int n3, int n4) {
        float f = this.TriZ[n2] - this.TriZ[n4];
        float f2 = this.TriZ[n3] - this.TriZ[n4];
        this.dzdx = (f2 * (float)this.dyl - f * (float)this.dyr) / (float)n;
        this.dzdy = (f * (float)this.dxr - f2 * (float)this.dxl) / (float)n;
    }

    @Override
    protected void init_dx_dy(int n, int n2, int n3, int n4) {
        this.init_z_dx_dy(n, n2, n3, n4);
    }

    protected void init_z_other(boolean bl, int n) {
        this.dzdxy = this.dzdx * (float)n + this.dzdy;
        this.dzdyy = bl ? this.dzdxy - this.dzdx : this.dzdxy + this.dzdx;
    }

    @Override
    protected void init_other(boolean bl, int n) {
        this.init_z_other(bl, n);
    }

    protected void z_inc_y_once() {
        this.LeftPointZ += this.dzdxy;
    }

    @Override
    protected void inc_y_once() {
        this.z_inc_y_once();
    }

    protected void z_inc_y_more() {
        this.LeftPointZ += this.dzdyy;
    }

    @Override
    protected void inc_y_more() {
        this.z_inc_y_more();
    }

    @Override
    protected void draw_horizontal_line(int n) {
        this.draw_horizontal_line(this.LeftPoint, this.RightPoint, n, this.LeftPointZ);
    }

    public GL_Depth(GL_Context gL_Context) {
        super(gL_Context);
    }
}

