/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.narrowphase;

import org.dyn4j.Epsilon;
import org.dyn4j.collision.narrowphase.Raycast;
import org.dyn4j.geometry.Ray;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;

public class SegmentDetector {
    public static boolean raycast(Ray ray, double d, Segment segment, Transform transform, Raycast raycast) {
        Vector2 vector2 = ray.getStart();
        Vector2 vector22 = ray.getDirectionVector();
        Vector2 vector23 = transform.getTransformed(segment.getPoint1());
        Vector2 vector24 = transform.getTransformed(segment.getPoint2());
        Vector2 vector25 = vector23.to(vector24);
        if (segment.contains(vector2, transform)) {
            return false;
        }
        Vector2 vector26 = vector23.difference(vector2);
        double d2 = vector25.cross(vector26);
        double d3 = vector25.cross(vector22);
        if (Math.abs(d3) <= Epsilon.E) {
            double d4;
            Vector2 vector27 = vector22.cross(1.0);
            double d5 = vector27.dot(vector2);
            if (Math.abs(d5 - (d4 = vector27.dot(vector23))) < Epsilon.E) {
                double d6 = vector22.dot(vector2);
                double d7 = vector22.dot(vector23);
                double d8 = vector22.dot(vector24);
                if (d7 < 0.0 || d8 < 0.0) {
                    return false;
                }
                double d9 = 0.0;
                Vector2 vector28 = null;
                if (d7 < d8) {
                    d9 = d7 - d6;
                    vector28 = vector23.copy();
                } else {
                    d9 = d8 - d6;
                    vector28 = vector24.copy();
                }
                if (d > 0.0 && d9 > d) {
                    return false;
                }
                raycast.distance = d9;
                raycast.point = vector28;
                raycast.normal = vector22.getNegative();
                return true;
            }
            return false;
        }
        double d10 = d2 / d3;
        if (d10 < 0.0) {
            return false;
        }
        if (d > 0.0 && d10 > d) {
            return false;
        }
        double d11 = (d10 * vector22.x + vector2.x - vector23.x) / vector25.x;
        if (d11 < 0.0 || d11 > 1.0) {
            return false;
        }
        Vector2 vector29 = vector22.product(d10).add(vector2);
        Vector2 vector210 = vector23.to(vector24);
        vector210.normalize();
        vector210.right();
        double d12 = vector210.dot(vector22);
        if (d12 > 0.0) {
            vector210.negate();
        }
        raycast.point = vector29;
        raycast.normal = vector210;
        raycast.distance = d10;
        return true;
    }
}

